-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|


with Ada.Text_IO;                              use Ada.Text_IO;
with Ada.Float_Text_IO;                        use Ada.Float_Text_IO;
with Ada.Integer_Text_IO;                      use Ada.Integer_Text_IO;
with Ada.Long_Float_Text_IO;                   use Ada.Long_Float_Text_IO;

with JPATS_Atmosphere;
with JPATS_Atmosphere.Container.IOS_Interface;
with JPATS_Atmosphere.Free_Air_Controller;
with JPATS_Atmosphere.Microburst_Controller;
with JPATS_Atmosphere.Turbulence_Controller;
with JPATS_Atmosphere.Wind_Shear_Controller;
with JPATS_Atmosphere.Winds_Controller;

procedure JPATS_Atmosphere.EXECUTE_Atmosphere is

    An_Integration_Constant : Float := 1.0/60.0;

    A_DFW_Microburst_Position      : Integer := 1;
    A_Microburst_Model             : Integer := 3;
    A_Microburst_Intensity         : Float   := 0.0;
    A_Microburst_Activate          : Boolean := False;
    A_Turbulence_Intensity         : Float   := 10.0;
    A_Turbulence_Activate          : Boolean := False;
    A_Wind_Shear_Model             : Integer := 2;
    A_Wind_Shear_Intensity         : float   := 25.0;
    A_Wind_Shear_Activate          : Boolean := False;
    A_Surface_Wind_Velocity        : Float   := 25.0;    --| Knots
    A_Surface_Wind_Direction       : Float   := 15.5;    --| Degrees
    A_Surface_Wind_Altitude        : Float   := 7500.0;  --| Feet
    A_Cruise_Wind_Velocity         : Float   := 55.0;    --| Knots
    A_Cruise_Wind_Direction        : Float   := -18.9;   --| Degrees
    A_Cruise_Wind_Altitude         : Float   := 12500.0; --| Feet
    A_Cross_Wind_Velocity          : Float   := 36.0;    --| Knots
    A_Cross_Wind_Activate          : Boolean := False;   --| Feet
    A_Wind_Gust_Training_Direction : Float   := 125.5;   --| Degrees
    A_Wind_Gust_Training_Velocity  : Float   := 0.0;     --| Knots
    A_Field_Pressure               : Float   := 29.90;   --| inches of Hg
    A_Field_Temperature            : Float   := 59.0;    --| Degree Fahrenheit

    j:integer :=1;
begin

    JPATS_Atmosphere.Free_Air_Controller.Initialize;
    JPATS_Atmosphere.Microburst_Controller.Initialize;
    JPATS_Atmosphere.Turbulence_Controller.Initialize;
    JPATS_Atmosphere.Wind_Shear_Controller.Initialize;
    JPATS_Atmosphere.Winds_Controller.Initialize;

    JPATS_Atmosphere.Microburst_Controller.Initialize_Tables;
    JPATS_Atmosphere.Wind_Shear_Controller.Initialize_Tables;
---
    --| MICROBURST
    JPATS_Atmosphere.Container.IOS_Interface.Set_DFW_Microburst_Position(A_DFW_Microburst_Position);
    JPATS_Atmosphere.Container.IOS_Interface.Set_Microburst_Model(A_Microburst_Model);
    JPATS_Atmosphere.Container.IOS_Interface.Set_Microburst_Intensity(A_Microburst_Intensity);
    JPATS_Atmosphere.Container.IOS_Interface.Set_Microburst_Activate (A_Microburst_Activate);

    --| TURBULENCE
    JPATS_Atmosphere.Container.IOS_Interface.Set_Turbulence_Intensity(A_Turbulence_Intensity);
    JPATS_Atmosphere.Container.IOS_Interface.Set_Turbulence_Activate (A_Turbulence_Activate);

    --| WIND SHEAR
    JPATS_Atmosphere.Container.IOS_Interface.Set_Wind_Shear_Model(A_Wind_Shear_Model);
    JPATS_Atmosphere.Container.IOS_Interface.Set_Wind_Shear_Intensity(A_Wind_Shear_Intensity);
    JPATS_Atmosphere.Container.IOS_Interface.Set_Wind_Shear_Activate (A_Wind_Shear_Activate);

    --| SURFACE WINDS
    JPATS_Atmosphere.Container.IOS_Interface.Set_Surface_Wind_Velocity(A_Surface_Wind_Velocity);    --| Knots
    JPATS_Atmosphere.Container.IOS_Interface.Set_Surface_Wind_Direction (A_Surface_Wind_Direction); --| Degrees
    JPATS_Atmosphere.Container.IOS_Interface.Set_Surface_Wind_Altitude(A_Surface_Wind_Altitude);    --| Feet

    --| CRUISE WINDS
    JPATS_Atmosphere.Container.IOS_Interface.Set_Cruise_Wind_Velocity(A_Cruise_Wind_Velocity);      --| Knots
    JPATS_Atmosphere.Container.IOS_Interface.Set_Cruise_Wind_Direction (A_Cruise_Wind_Direction);   --| Degrees
    JPATS_Atmosphere.Container.IOS_Interface.Set_Cruise_Wind_Altitude(A_Cruise_Wind_Altitude);      --| Feet

    --| CROSS WINDS
    JPATS_Atmosphere.Container.IOS_Interface.Set_Cross_Wind_Velocity(A_Cross_Wind_Velocity);        --| Knots
    JPATS_Atmosphere.Container.IOS_Interface.Set_Cross_Wind_Activate (A_Cross_Wind_Activate);     --| Feet

    --| WIND GUST
    JPATS_Atmosphere.Container.IOS_Interface.Set_Wind_Gust_Training_Direction(A_Wind_Gust_Training_Direction); --| Degrees
    JPATS_Atmosphere.Container.IOS_Interface.Set_Wind_Gust_Training_Velocity (A_Wind_Gust_Training_Velocity);  --| Knots

    --| FIELD
    --JPATS_Atmosphere.Container.IOS_Interface.Set_Field_Pressure(A_Field_Pressure);        --| inches of Hg
   -- JPATS_Atmosphere.Container.IOS_Interface.Set_Field_Temperature(A_Field_Temperature);  --| Degree Fahrenheit

    ---
    for i in 1..2000 loop
        JPATS_Atmosphere.Free_Air_Controller.Update(An_Integration_Constant);
        JPATS_Atmosphere.Microburst_Controller.Update(An_Integration_Constant);
        JPATS_Atmosphere.Turbulence_Controller.Update(An_Integration_Constant);
        JPATS_Atmosphere.Wind_Shear_Controller.Update(An_Integration_Constant);
        JPATS_Atmosphere.Winds_Controller.Update(An_Integration_Constant);
        put_line(" ok ");

        put(JPATS_Atmosphere.Get_Steady_State_Wind_Velocity_Earth_Axis.x);      put(JPATS_Atmosphere.Get_Steady_State_Wind_Velocity_Earth_Axis.y);
        put(JPATS_Atmosphere.Get_Steady_State_Wind_Velocity_Earth_Axis.z);       put_line(" Get_Steady_State_Wind_Velocity_Earth_Axis " );

         put(JPATS_Atmosphere.Get_Steady_State_Wind_Increment_in_Velocity_Earth_Axis.x);       put(JPATS_Atmosphere.Get_Steady_State_Wind_Increment_in_Velocity_Earth_Axis.y);
        put(JPATS_Atmosphere.Get_Steady_State_Wind_Increment_in_Velocity_Earth_Axis.z);   put_line(" Get_Steady_State_Wind_Increment_in_Velocity_Earth_Axis " );

        --| Aircraft Free Air
        put(JPATS_Atmosphere.Get_Aircraft_Ambient_Temperature); put_line(" OAT ");
        put(JPATS_Atmosphere.Get_Aircraft_Ambient_Temperature_Ratio);put_line(" OAT ratio " );
        put(JPATS_Atmosphere.Get_Aircraft_Pressure_Altitude);put_line(" pressure altitude " );
        --| Wind Gust
        put(JPATS_Atmosphere.Get_Wind_Gust_Counter);                          put_line(" Get_Wind_Gust_Counter " );
        put(JPATS_Atmosphere.Get_Wind_Gust_Random_Counter);                 put_line(" Get_Wind_Gust_Random_Counter " );
        put(JPATS_Atmosphere.Get_Wind_Gust_New_Output);                   put_line(" Get_Wind_Gust_New_Output " );
        put(JPATS_Atmosphere.Get_Wind_Gust_Output);                          put_line(" Get_Wind_Gust_Output " );
        put(JPATS_Atmosphere.Get_Desired_Wind_Gust_Velocity);   put_line(" Get_Desired_Wind_Gust_Velocity " );
        put(JPATS_Atmosphere.Get_Wind_Gust_Velocity);          put_line(" Get_Wind_Gust_Velocity " );
         put(JPATS_Atmosphere.Get_Wind_Gust_Velocity_Earth_Axis.x);      put(JPATS_Atmosphere.Get_Wind_Gust_Velocity_Earth_Axis.y);
        put(JPATS_Atmosphere.Get_Wind_Gust_Velocity_Earth_Axis.z); put_line(" Get_Wind_Gust_Velocity_Earth_Axis " );
        put(JPATS_Atmosphere.Get_Wind_Gust_Direction*180.0/3.142);              put_line(" Get_Wind_Gust_Direction " );
        put(JPATS_Atmosphere.Get_Wind_Training_Direction*180.0/3.142);            put_line(" Get_Wind_Training_Direction " );
    --| Winds
        put(JPATS_Atmosphere.Get_Surface_Wind_Velocity);    put_line(" Get_Surface_Wind_Velocity " );
        put(JPATS_Atmosphere.Get_Surface_Wind_Altitude);             put_line(" Get_Surface_Wind_Altitude " );
        put(JPATS_Atmosphere.Get_Surface_Wind_Direction*180.0/3.142);               put_line(" Get_Surface_Wind_Direction " );
        put(JPATS_Atmosphere.Get_Cruise_Wind_Velocity);      put_line(" Get_Cruise_Wind_Velocity " );
        put(JPATS_Atmosphere.Get_Cruise_Wind_Altitude);               put_line(" Get_Cruise_Wind_Altitude " );
        put(JPATS_Atmosphere.Get_Cruise_Wind_Direction*180.0/3.142);             put_line(" Get_Cruise_Wind_Direction " );
        put(JPATS_Atmosphere.Get_Cross_Wind_Velocity);      put_line(" Get_Cross_Wind_Velocity " );
        put(JPATS_Atmosphere.Get_Cross_Wind_Altitude);          put_line(" Get_Cross_Wind_Altitude " );
        put(JPATS_Atmosphere.Get_Cross_Wind_Direction*180.0/3.142);             put_line(" Get_Cross_Wind_Direction " );
        put(JPATS_Atmosphere.Get_Winds_Velocity_Slope);                        put_line(" Get_Winds_Velocity_Slope " );
        put(JPATS_Atmosphere.Get_Winds_Direction_Slope);                        put_line(" Get_Winds_Direction_Slope " );
        put(JPATS_Atmosphere.Get_Wind_Velocity);           put_line(" Get_Wind_Velocity " );
        put(JPATS_Atmosphere.Get_Wind_Direction*180.0/3.142);                      put_line(" Get_Wind_Direction " );
    --| This function will give the SUMMED wind velocities generated by the atmospheric phenomenon of
    --| 1. A_Steady_State_Wind
    --| 2. A_Steady_State_Winds_Increments
    --| 3. A_Wind_Gust
    --| 4. A_Microburst and
    --| 5. A_Wind_Shear
        put(JPATS_Atmosphere.Get_Wind_Velocity_Earth_Axis.x);  put(JPATS_Atmosphere.Get_Wind_Velocity_Earth_Axis.y);
        put(JPATS_Atmosphere.Get_Wind_Velocity_Earth_Axis.z);       put_line(" Get_Wind_Velocity_Earth_Axis " );
        put(JPATS_Atmosphere.Get_Display_Head_Wind_Velocity);    put_line(" Get_Display_Head_Wind_Velocity " );
        put(JPATS_Atmosphere.Get_Display_Cross_Wind_Velocity);    put_line(" Get_Display_Cross_Wind_Velocity " );

        if j= 1000 then
    A_Wind_Gust_Training_Velocity  := 0.0;     --| Knots
    JPATS_Atmosphere.Container.IOS_Interface.Set_Wind_Gust_Training_Velocity (A_Wind_Gust_Training_Velocity);  --| Knots
    end if;
       put(j); put_line (" j ");
    j := j+1;

    end loop;



end JPATS_Atmosphere.EXECUTE_Atmosphere;

