#
# Script to print a file with a header containing version information.
#
foreach $name (@ARGV) {
    ($version, $user, $date) = split /\t/,`cleartool describe -fmt "%Vn\t%u\t%Vd" $name`;
    ($objectuser, $objectdate) = split /\t/,`cleartool describe -fmt "%u\t%Vd" ${name}\@\@`;
#    $labels = `cleartool describe -fmt "%Nl" $name`;
    if ($name =~ /\.ad[abs]$/) {
	$comment = "--";
    } else {
	$comment = "# ";
    }
    # Gatesify the filename and lop off the leading .\ if any
    $name =~ s/\//\\/g;
    $name =~ s/^\.\\//;
    
    print "${comment} -------------------------- VERSION INFORMATION --------------------------\n";
    print "${comment} Filename:         $name\n";
    print "${comment} File creator:     $objectuser\n";
    print "${comment} Creation date:    $objectdate\n";
    print "${comment} Version:          $version\n";
    print "${comment} Version creator:  $user\n";
    print "${comment} Version date:     $date\n";
#    print "${comment} ClearCase labels: $labels\n"; 
    print "${comment} ------------------------ END VERSION INFORMATION ------------------------\n";
    open THISFILE, "<$name";
    while (<THISFILE>) {
	print;
    }
    close THISFILE;
}

