-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Tone_Generator_G is

   procedure Update
     (An_Instance : in out Instance) is
   begin
      null;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;


   function Powered
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Powered;
   exception
      when others =>
         Log.Report(Package_Name & ".Powered()");
         raise;
   end Powered;

   function Ldg_Gear_Warn
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Ldg_Gear_Warn;
   exception
      when others =>
         Log.Report(Package_Name & ".Ldg_Gear_Warn()");
         raise;
   end Ldg_Gear_Warn;

   function Master_Warn_Caution
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Master_Warn_Caution;
   exception
      when others =>
         Log.Report(Package_Name & ".Master_Warn_Caution()");
         raise;
   end Master_Warn_Caution;

   function Audio_Front
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Audio_Front;
   exception
      when others =>
         Log.Report(Package_Name & ".Audio_Front()");
         raise;
   end Audio_Front;

   function G_Warn
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.G_Warn;
   exception
      when others =>
         Log.Report(Package_Name & ".G_Warn()");
         raise;
   end G_Warn;

   function Over_Speed
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Over_Speed;
   exception
      when others =>
         Log.Report(Package_Name & ".Over_Speed()");
         raise;
   end Over_Speed;


end Tone_Generator_G;
