-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic
   type Annunciator_Type is private;

   type Warn_Annunciator_Name_Type is (<>);
   type Warn_Array_Of_Annunciator_Type is array (Warn_Annunciator_Name_Type) of Annunciator_Type;
   type Warn_Array_Of_Boolean is array (Warn_Annunciator_Name_Type) of Boolean;

   type Caution_Annunciator_Name_Type is (<>);
   type Caution_Array_Of_Annunciator_Type is array (Caution_Annunciator_Name_Type) of Annunciator_Type;
   type Caution_Array_Of_Boolean is array (Caution_Annunciator_Name_Type) of Boolean;

   type Advisory_Annunciator_Name_Type is (<>);
   type Advisory_Array_Of_Annunciator_Type is array (Advisory_Annunciator_Name_Type) of Annunciator_Type;
   type Advisory_Array_Of_Boolean is array (Advisory_Annunciator_Name_Type) of Boolean;

   type Spare_Annunciator_Name_Type is (<>);
   type Spare_Array_Of_Annunciator_Type is array (Spare_Annunciator_Name_Type) of Annunciator_Type;
   type Spare_Array_Of_Boolean is array (Spare_Annunciator_Name_Type) of Boolean;

   with procedure Update_A_Annunciator (An_Annunciator : in out Annunciator_Type;
                                        Request        : in     Boolean;
                                        Power          : in     Boolean;
                                        Test           : in     Boolean;
                                        Reset          : in     Boolean);
   with function A_Annunciator_Flash_Request (A_Annunciator : in Annunciator_Type) return Boolean;

   with procedure Initialize_A_Annunciator (A_Annunciator : in out Annunciator_Type);

   with function A_Annunciator_Is_On (A_Annunciator : in Annunciator_Type) return Boolean;
   Package_Name : in String;

package Master_Caution_Panel_G is

   type Instance is private;

   procedure Update
     (An_Instance      : in out Instance;
      Warn_Request     : in     Warn_Array_Of_Boolean;
      Warn_Power       : in     Warn_Array_Of_Boolean;
      Caution_Request  : in     Caution_Array_Of_Boolean;
      Caution_Power    : in     Caution_Array_Of_Boolean;
      Advisory_Request : in     Advisory_Array_Of_Boolean;
      Advisory_Power   : in     Advisory_Array_Of_Boolean;
      Spare_Power      : in     Spare_Array_Of_Boolean;
      Warn_Reset       : in     Boolean;
      Caution_Reset    : in     Boolean;
      Test             : in     Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Warn_Flash_Command
     (An_Instance : in Instance)
      return Boolean;

   function Caution_Flash_Command
     (An_Instance : in Instance)
      return Boolean;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Warn_Annunciator_Name_Type)
     return Boolean;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Caution_Annunciator_Name_Type)
     return Boolean;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Advisory_Annunciator_Name_Type)
     return Boolean;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Spare_Annunciator_Name_Type)
     return Boolean;

private

   type Instance is
      record
         Warn_Annunciators     : Warn_Array_Of_Annunciator_Type;
         Caution_Annunciators  : Caution_Array_Of_Annunciator_Type;
         Advisory_Annunciators : Advisory_Array_Of_Annunciator_Type;
         Spare_Annunciators    : Spare_Array_Of_Annunciator_Type;
         Warn_Flash_Command    : Boolean;
         Caution_Flash_Command : Boolean;
      end record;

end Master_Caution_Panel_G;
