-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Master_Caution_Panel_G is

   procedure Update
     (An_Instance      : in out Instance;
      Warn_Request     : in     Warn_Array_Of_Boolean;
      Warn_Power       : in     Warn_Array_Of_Boolean;
      Caution_Request  : in     Caution_Array_Of_Boolean;
      Caution_Power    : in     Caution_Array_Of_Boolean;
      Advisory_Request : in     Advisory_Array_Of_Boolean;
      Advisory_Power   : in     Advisory_Array_Of_Boolean;
      Spare_Power      : in     Spare_Array_Of_Boolean;
      Warn_Reset       : in     Boolean;
      Caution_Reset    : in     Boolean;
      Test             : in     Boolean) is
      Flash_Request : Boolean;
   begin
      for Name in Warn_Annunciator_Name_Type
        loop
           Update_A_Annunciator (An_Annunciator => An_Instance.Warn_Annunciators (Name),
                                 Request        => Warn_Request (Name),
                                 Power          => Warn_Power (Name),
                                 Test           => Test,
                                 Reset          => Warn_Reset or not Warn_Request (Name));
        end loop;
      for Name in Warn_Annunciator_Name_Type
        loop
           Flash_Request := A_Annunciator_Flash_Request (An_Instance.Warn_Annunciators (Name));
           if Flash_Request then
              An_Instance.Warn_Flash_Command := True;
              exit;
           end if;
           An_Instance.Warn_Flash_Command := False;
        end loop;
      for Name in Caution_Annunciator_Name_Type
        loop
           Update_A_Annunciator (An_Annunciator => An_Instance.Caution_Annunciators (Name),
                                 Request        => Caution_Request (Name),
                                 Power          => Caution_Power (Name),
                                 Test           => Test,
                                 Reset          => Caution_Reset or not Caution_Request (Name));
        end loop;
      for Name in Caution_Annunciator_Name_Type
        loop
           Flash_Request := A_Annunciator_Flash_Request (An_Instance.Caution_Annunciators (Name));
           if Flash_Request then
              An_Instance.Caution_Flash_Command := True;
              exit;
           end if;
           An_Instance.Caution_Flash_Command := False;
        end loop;
      for Name in Advisory_Annunciator_Name_Type
        loop
           Update_A_Annunciator (An_Annunciator => An_Instance.Advisory_Annunciators (Name),
                                 Request        => Advisory_Request (Name),
                                 Power          => Advisory_Power (Name),
                                 Test           => Test,
                                 Reset          => True);
        end loop;
      for Name in Spare_Annunciator_Name_Type
        loop
           Update_A_Annunciator (An_Annunciator => An_Instance.Spare_Annunciators (Name),
                                 Request        => False,
                                 Power          => Spare_Power (Name),
                                 Test           => Test,
                                 Reset          => False);
        end loop;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin

      for Name in Warn_Annunciator_Name_Type
      loop
         Initialize_A_Annunciator (A_Annunciator => An_Instance.Warn_Annunciators (Name));
      end loop;

      for Name in Caution_Annunciator_Name_Type
      loop
         Initialize_A_Annunciator (A_Annunciator => An_Instance.Caution_Annunciators (Name));
      end loop;

      for Name in Advisory_Annunciator_Name_Type
      loop
         Initialize_A_Annunciator (A_Annunciator => An_Instance.Advisory_Annunciators (Name));
      end loop;

      for Name in Spare_Annunciator_Name_Type
      loop
         Initialize_A_Annunciator (A_Annunciator => An_Instance.Spare_Annunciators (Name));
      end loop;

      An_Instance.Warn_Flash_Command    := False;
      An_Instance.Caution_Flash_Command := False;

   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize ;

   function Warn_Flash_Command
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Warn_Flash_Command;
   exception
      when others =>
         Log.Report(Package_Name & ".Warn_Flash_Command()");
         raise;
   end Warn_Flash_Command;

   function Caution_Flash_Command
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Caution_Flash_Command;
   exception
      when others =>
         Log.Report(Package_Name & ".Caution_Flash_Command()");
         raise;
   end Caution_Flash_Command;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Warn_Annunciator_Name_Type)
     return Boolean
   is
   begin
      return A_Annunciator_Is_On (An_Instance.Warn_Annunciators (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_On()");
         raise;
   end Is_On;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Caution_Annunciator_Name_Type)
     return Boolean
   is
   begin
      return A_Annunciator_Is_On (An_Instance.Caution_Annunciators (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_On()");
         raise;
   end Is_On;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Advisory_Annunciator_Name_Type)
     return Boolean
   is
   begin
      return A_Annunciator_Is_On (An_Instance.Advisory_Annunciators (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_On()");
         raise;
   end Is_On;

   function Is_On
     (An_Instance : in Instance;
      Name        : in Spare_Annunciator_Name_Type)
     return Boolean
   is
   begin
      return A_Annunciator_Is_On (An_Instance.Spare_Annunciators (Name));
   exception
      when others =>
         Log.Report(Package_Name & ".Is_On()");
         raise;
   end Is_On;

end Master_Caution_Panel_G;
