-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Warning.Container;
with Log;

package body Jpats_Warning is

   --------------------------------
   -- Master_Caution_Illuminated --
   --------------------------------

   function Master_Caution_Illuminated return Boolean is
   begin
      return Container.Flasher.Is_Illuminated (Container.This_Subsystem.The_Caution_Flasher);
   exception
      when others =>
         Log.Report("Jpats_Warning.Master_Caution_Illuminated()");
         raise;
   end Master_Caution_Illuminated;

   -----------------------------
   -- Master_Warn_Illuminated --
   -----------------------------

   function Master_Warn_Illuminated return Boolean is
   begin
      return Container.Flasher.Is_Illuminated (Container.This_Subsystem.The_Warn_Flasher);
   exception
      when others =>
         Log.Report("Jpats_Warning.Master_Warn_Illuminated()");
         raise;
   end Master_Warn_Illuminated;


   -----------
   -- SOUND --
   -----------
   package Ctnr renames Container;
   Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;

   function Landing_Gear_Warning_Snd
     return Float
   is
   begin
      return Sound.Landing_Gear_Warning_Enable;
   exception
      when others =>
         Log.Report("Jpats_Warning.Landing_Gear_Warning_Snd()");
         raise;
   end Landing_Gear_Warning_Snd;

   function Warn_Caution_Fire_Snd
     return Float
   is
   begin
      return Sound.Warn_Caution_Fire_Enable;
   exception
      when others =>
         Log.Report("Jpats_Warning.Warn_Caution_Fire_Snd()");
         raise;
   end Warn_Caution_Fire_Snd;


end Jpats_Warning;

