-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Warning.Container;
with Jpats_Ios_Interface;
with Log;

package body Jpats_Warning.Ios_Interface is

   package Ctnr renames Container;
   package JII renames Jpats_Ios_Interface;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io  : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;


   procedure Fire_Warn_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Fire_Warn := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Warning.Ios_Interface.Fire_Warn_Command");
         raise;
   end Fire_Warn_Command;


   ----------------------------
   -- Register_Ios_Variables --
   ----------------------------

   procedure Register_Ios_Variables is
   begin
      JPATS_IOS_Interface.Register
        (Name          => "Fire_Warn",
         Variable      => Ios.Fire_Warn'Address,
         Set_Routine   => Fire_Warn_Command'Access);

      JPATS_IOS_Interface.Register
        (Name          => "Ldg_Gr_Test_Sw",
         Variable      => Io.Ldg_Gr_Test_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Fire_Det_No_1_Test_Sw",
         Variable      => Io.Fire_Det_No_1_Test_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Fire_Det_No_2_Test_Sw",
         Variable      => Io.Fire_Det_No_2_Test_Sw'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Master_Warn_Lt",
         Variable      => Io.Master_Warn_Lt'Address
         );
      JPATS_IOS_Interface.Register
        (Name          =>"Master_Caution_Lt",
         Variable      => Io.Master_Caution_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Eng_Fire_Lt",
         Variable      => Io.Eng_Fire_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Eng_Fire_Lt_Bottom",
         Variable      => Io.Eng_Fire_2'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Bat_Bus_Lt",
         Variable      => Io.Ann_Pnl_Bat_Bus_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Gen_Bus_Lt",
         Variable      => Io.Ann_Pnl_Gen_Bus_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Pmu_Fail_Lt",
         Variable      => Io.Ann_Pnl_Pmu_Fail_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Gen_Lt",
         Variable      => Io.Ann_Pnl_Gen_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Ckpt_Px_Lt",
         Variable      => Io.Ann_Pnl_Ckpt_Px_Lt'Address
         );


      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Canopy_Lt",
         Variable      => Io.Ann_Pnl_Canopy_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Fuel_Px_Lt",
         Variable      => Io.Ann_Pnl_Fuel_Px_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Oil_Px_Warn_Lt",
         Variable      => Io.Ann_Pnl_Oil_Px_Warn_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Obogs_Fail_Lt",
         Variable      => Io.Ann_Pnl_Obogs_Fail_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Chip_Lt",
         Variable      => Io.Ann_Pnl_Chip_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Ckpt_Alt_Lt",
         Variable      => Io.Ann_Pnl_Ckpt_Alt_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Spare1_Lt",
         Variable      => Io.Ann_Pnl_Spare1_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Hydr_Fl_Lo_Lt",
         Variable      => Io.Ann_Pnl_Hydr_Fl_Lo_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Oil_Px_Caut_Lt",
         Variable      => Io.Ann_Pnl_Oil_Px_Caut_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Bus_Tie_Lt",
         Variable      => Io.Ann_Pnl_Bus_Tie_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Fuel_Bal_Lt",
         Variable      => Io.Ann_Pnl_Fuel_Bal_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Pmu_Status_Lt",
         Variable      => Io.Ann_Pnl_Pmu_Status_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Hydr_Px_Lo_Lt",
         Variable      => Io.Ann_Pnl_Hydr_Px_Lo_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Tad_Fail_Lt",
         Variable      => Io.Ann_Pnl_Tad_Fail_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Obogs_Temp_Lt",
         Variable      => Io.Ann_Pnl_Obogs_Temp_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_L_Fuel_Lo_Lt",
         Variable      => Io.Ann_Pnl_L_Fuel_Lo_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_R_Fuel_Lo_Lt",
         Variable      => Io.Ann_Pnl_R_Fuel_Lo_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Duct_Temp_Lt",
         Variable      => Io.Ann_Pnl_Duct_Temp_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Ign_Sel_Lt",
         Variable      => Io.Ann_Pnl_Ign_Sel_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Trim_Off_Lt",
         Variable      => Io.Ann_Pnl_Trim_Off_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Boost_Pump_Lt",
         Variable      => Io.Ann_Pnl_Boost_Pump_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Anti_Ice_Lt",
         Variable      => Io.Ann_Pnl_Anti_Ice_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_Tad_Off_Lt",
         Variable      => Io.Ann_Pnl_Tad_Off_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_St_Ready_Lt",
         Variable      => Io.Ann_Pnl_St_Ready_Lt'Address
         );

      JPATS_IOS_Interface.Register
        (Name          =>"Ann_Pnl_M_Fuel_Bal",
         Variable      => Io.Ann_Pnl_M_Fuel_Bal'Address
         );

   exception
      when others =>
         Log.Report("Jpats_Warning.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;

end Jpats_Warning.Ios_Interface;

