-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Warning.Container;
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;
with Log;

package body Jpats_Warning.Io_Interface is

   package JIOT renames Jpats_Io_Types;
   Io : Container.Io_Interface_Instance renames Container.This_Io_Interface;

   procedure Register_Io_Variables
   is
   begin
      -- digital input
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_WARN_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Master_Warn_Sw'Address,
         A_Size          => Io.Master_Warn_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_CAUTION_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Master_Caution_Sw'Address,
         A_Size          => Io.Master_Caution_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FIRE_DET_NO_1_TEST_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fire_Det_No_1_Test_Sw'Address,
         A_Size          => Io.Fire_Det_No_1_Test_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "FIRE_DET_NO_2_TEST_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Fire_Det_No_2_Test_Sw'Address,
         A_Size          => Io.Fire_Det_No_2_Test_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "LDG_GR_TEST_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Ldg_Gr_Test_Sw'Address,
         A_Size          => Io.Ldg_Gr_Test_Sw'Size);

--       Jpats_Io.Map_To_Icd_mnemonic
--         (An_Interface    => JIOT.Flight_Deck,
--          An_Icd_Mnemonic => "LDG_GEAR_WARN_LOW_THROT_SW",
--          A_Direction     => IO_Types.Input,
--          An_Address      => Io.Ldg_Gear_Warn_Low_Throt_Sw'Address,
--          A_Size          => Io.Ldg_Gear_Warn_Low_Throt_Sw'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "WARNING_SILENCE_SW",
         A_Direction     => IO_Types.Input,
         An_Address      => Io.Warning_Silence_Sw'Address,
         A_Size          => Io.Warning_Silence_Sw'Size);


      -- digital output
      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_WARN_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Master_Warn_Lt'Address,
         A_Size          => Io.Master_Warn_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "MASTER_CAUTION_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Master_Caution_Lt'Address,
         A_Size          => Io.Master_Caution_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ENG_FIRE_1",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Eng_Fire_Lt'Address,
         A_Size          => Io.Eng_Fire_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ENG_FIRE_2",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Eng_Fire_2'Address,
         A_Size          => Io.Eng_Fire_2'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_BAT_BUS_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Bat_Bus_Lt'Address,
         A_Size          => Io.Ann_Pnl_Bat_Bus_Lt 'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_GEN_BUS_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Gen_Bus_Lt'Address,
         A_Size          => Io.Ann_Pnl_Gen_Bus_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_PMU_FAIL_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Pmu_Fail_Lt'Address,
         A_Size          => Io.Ann_Pnl_Pmu_Fail_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_GEN_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Gen_Lt'Address,
         A_Size          => Io.Ann_Pnl_Gen_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_CKPT_PX_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Ckpt_Px_Lt'Address,
         A_Size          => Io.Ann_Pnl_Ckpt_Px_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_CANOPY_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Canopy_Lt 'Address,
         A_Size          => Io.Ann_Pnl_Canopy_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_FUEL_PX_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Fuel_Px_Lt'Address,
         A_Size          => Io.Ann_Pnl_Fuel_Px_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         -- An_Icd_Mnemonic => "ANN_PNL_OIL_PX_WARN_LT",
         An_Icd_Mnemonic => "ANN_PNL_OIL_PX_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Oil_Px_Warn_Lt'Address,
         A_Size          => Io.Ann_Pnl_Oil_Px_Warn_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_OBOGS_FAIL_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Obogs_Fail_Lt'Address,
         A_Size          => Io.Ann_Pnl_Obogs_Fail_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_CHIP_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Chip_Lt'Address,
         A_Size          => Io.Ann_Pnl_Chip_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_CKPT_ALT_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Ckpt_Alt_Lt'Address,
         A_Size          => Io.Ann_Pnl_Ckpt_Alt_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_SPARE1_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Spare1_Lt'Address,
         A_Size          => Io.Ann_Pnl_Spare1_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_HYDR_FL_LO_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Hydr_Fl_Lo_Lt'Address,
         A_Size          => Io.Ann_Pnl_Hydr_Fl_Lo_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         -- An_Icd_Mnemonic => "ANN_PNL_OIL_PX_CAUT_LT",
         An_Icd_Mnemonic => "ANN_PNL_SPARE2_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Oil_Px_Caut_Lt'Address,
         A_Size          => Io.Ann_Pnl_Oil_Px_Caut_Lt 'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_BUS_TIE_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Bus_Tie_Lt'Address,
         A_Size          => Io.Ann_Pnl_Bus_Tie_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_FUEL_BAL_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Fuel_Bal_Lt'Address,
         A_Size          => Io.Ann_Pnl_Fuel_Bal_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_PMU_STATUS_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Pmu_Status_Lt'Address,
         A_Size          => Io.Ann_Pnl_Pmu_Status_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_HYDR_PX_LO_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Hydr_Px_Lo_Lt'Address,
         A_Size          => Io.Ann_Pnl_Hydr_Px_Lo_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_TAD_FAIL_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Tad_Fail_Lt'Address,
         A_Size          => Io.Ann_Pnl_Tad_Fail_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_OBOGS_TEMP_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Obogs_Temp_Lt'Address,
         A_Size          => Io.Ann_Pnl_Obogs_Temp_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_L_FUEL_LO_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_L_Fuel_Lo_Lt'Address,
         A_Size          => Io.Ann_Pnl_L_Fuel_Lo_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_R_FUEL_LO_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_R_Fuel_Lo_Lt'Address,
         A_Size          => Io.Ann_Pnl_R_Fuel_Lo_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_DUCT_TEMP_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Duct_Temp_Lt'Address,
         A_Size          => Io.Ann_Pnl_Duct_Temp_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_IGN_SEL_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Ign_Sel_Lt'Address,
         A_Size          => Io.Ann_Pnl_Ign_Sel_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_TRIM_OFF_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Trim_Off_Lt'Address,
         A_Size          => Io.Ann_Pnl_Trim_Off_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_BOOST_PUMP_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Boost_Pump_Lt'Address,
         A_Size          => Io.Ann_Pnl_Boost_Pump_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_ANTI_ICE_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Anti_Ice_Lt'Address,
         A_Size          => Io.Ann_Pnl_Anti_Ice_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_TAD_OFF_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Tad_Off_Lt'Address,
         A_Size          => Io.Ann_Pnl_Tad_Off_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_ST_READY_LT",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_St_Ready_Lt'Address,
         A_Size          => Io.Ann_Pnl_St_Ready_Lt'Size);

      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_M_FUEL_BAL",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_M_Fuel_Bal'Address,
         A_Size          => Io.Ann_Pnl_M_Fuel_Bal'Size);


      Jpats_Io.Map_To_Icd_mnemonic
        (An_Interface    => JIOT.Flight_Deck,
         An_Icd_Mnemonic => "ANN_PNL_DIMMING_IN",
         A_Direction     => IO_Types.Output,
         An_Address      => Io.Ann_Pnl_Dimming_Input'Address,
         A_Size          => Io.Ann_Pnl_Dimming_Input'Size);

--       Jpats_Io.Map_To_Icd_mnemonic
--         (An_Interface    => JIOT.Flight_Deck,
--          An_Icd_Mnemonic => "MAINT_LT_ON",
--          A_Direction     => IO_Types.Output,
--          An_Address      => Io.Maint_Lt_On'Address,
--          A_Size          => Io.Maint_Lt_On'Size);

--       Jpats_Io.Map_To_Icd_mnemonic
--         (An_Interface    => JIOT.Flight_Deck,
--          An_Icd_Mnemonic => "FAIL_LT_ON",
--          A_Direction     => IO_Types.Output,
--          An_Address      => Io.Fail_Lt_On'Address,
--          A_Size          => Io.Fail_Lt_On'Size);

      -- analog input
      -- analog output


   exception
      when others =>
         Log.Report("Jpats_Warning.Io_Interface.Register_Io_Variables()");
         raise;
   end Register_Io_Variables;

end Jpats_Warning.Io_Interface;

