-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  FIRE DETECTION
--  The aircraft is equipped with an overheat/fire detection system.
--  The detection system (Figure 1-14 and Figure 1-15) (dash one)
--  includes dual sensor tubes and responder assemblies. The
--  sensors, mounted around the exterior surface of the engine,
--  signal the respective responder assembly at a specific temperature.
--  The sensor tubes contain helium gas and a hydrogen
--  charged core material. The helium gas responds to the
--  sensor's overall threshold temperature (average temperature)
--  for overheat sensing. The hydrogen charged core responds
--  to highly localized heat (discrete temperatures) caused by
--  impinging flames or hot gases. Discrete temperatures result
--  in the release of hydrogen gas from the core, which
--  increases the helium gas pressure. Heating of the sensor (by
--  average or discrete temperatures) expands the helium gas,
--  which in turn pressurizes a diaphragm inside the responder.
--  If the diaphragm pressure reaches or exceeds the preset fire
--  detection point, an electrical circuit triggers the overheat/
--  fire alarm. Triggering the fire alarm illuminates a red FIRE
--  annunciator on each cockpit instrument panel and sounds
--  the master warning horn. To discriminate between fire or
--  overheat, retard the PCL. If the fire warning ceases, suspect
--  an overheat.
--  A fire detection system test switch, labeled FIRE, is provided
--  on the front cockpit left console test panel to verify
--  the function of the two fire detection systems. Momentarily
--  selecting the placarded 1 or 2 position will check system
--  integrity and lamp operation for the respective system. Flattening,
--  twisting, kinking or denting of the fire detection loop
--  will not affect test or flight operation. Power for the #1 fire
--  detection system is provided through a circuit breaker placarded
--  FIRE 1, located on the battery bus circuit breaker
--  panel in the front cockpit, and power for the #2 system is
--  provided through a circuit breaker placarded FIRE 2,
--  located on the generator bus circuit breaker panel in the
--  front cockpit.
--  In addition to the fire detectors, fire protection is provided
--  by the firewall fluid and cockpit air shutoff valves. The shutoff
--  valves are mechanically operated by the emergency firewall
--  shutoff handle, placarded EMERGENCY FIREWALL
--  SHUTOFF - PUSH BUTTON, PULL HANDLE, located on
--  the left console panel in the front cockpit (Figure 1-5) (dash one). To
--  activate the emergency firewall shutoff valves, push the button
--  and pull up on the handle (approximately 0.5 inch).
--  Cables attached to the handle will close the valves at the
--  firewall, cutting off fuel flow and hydraulic fluid flow to the
--  engine as well as cutting off bleed air flow and hydraulic
--  fluid flow from the engine. The valves may be reset by
--  pushing the handle down.

--  CENTRAL WARNING/CAUTION/ADVISORY AND ANNUNCIATOR SYSTEM (CWS)
--  The central warning/caution/advisory annunciator system
--  (CWS) includes annunciators and switchlights (Figure 1-
--  58) (dash one) located on the instrument panels and glareshields (Figure
--  1-3 and Figure 1-4) (dash one), and an aural tone generator to
--  quickly identify malfunctions and/or status of major aircraft
--  systems. The main annunciator panel, located on the lower
--  right side of the instrument panel in both cockpits, displays
--  red warning legends, amber caution legends, and green systems
--  status legends. The annunciator panel interconnects
--  with the master caution and warning switchlights on the
--  glareshield. The master caution/warning system on both
--  glareshields includes an amber master caution switchlight, a
--  red master warning switchlight, and a red fire switchlight.
--  Redundant power for the main annunciator panel and master
--  warning switchlights and fire annunciator is provided
--  through circuit breakers placarded CWS, one located on the
--  battery bus circuit breaker panel in the front cockpit, and
--  one located on the generator bus circuit breaker panel in the
--  front cockpit. See Section III (dash one) for annunciator
--  causes and references.

--  MASTER WARN AND MASTER CAUTION SWITCHLIGHTS AND FIRE WARNING ANNUNCIATOR
--  Resettable, color coded master warning, master caution
--  switchlights and a fire warning annunciator are located
--  under the lip of the glareshield in each cockpit. The red
--  warning switchlights illuminate MASTER WARN, the
--  amber caution switchlights illuminate MASTER CAUTION,
--  and the red fire warning annunciators illuminate
--  FIRE.
--  When a warning or caution annunciator on the main annunciator
--  panel in either cockpit illuminates, the respective
--  master warn or master caution switchlights will flash in
--  each cockpit. Pressing the flashing master caution or master
--  warn switchlight in either cockpit will extinguish the lamp
--  and rearm the switchlight for subsequent or additional system
--  failures or malfunctions. Any time the red FIRE annunciator
--  illuminates, the master warn switchlight and master
--  warn tone are triggered. The specific annunciator on the
--  main annunciator panel will remain illuminated after the
--  master switchlight has been reset, until the malfunction or
--  failure has been corrected.

--  AURAL WARNING TONE GENERATOR
--  An electronic tone generator located in the AOA computer
--  unit under the forward glareshield provides various Distin-
--  guishable tones for pilot warnings. Tones generated by the
--  tone generator are routed through the audio amplifiers and
--  then to the helmet audio connections.
--  Figure 1-59 (dash one) provides the tone descriptions and the purpose
--  of each tone.
--  Power for the tone generator unit is provided through a circuit
--  breaker placarded AURAL WARN, located on the generator
--  bus circuit breaker panel in the front cockpit.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------



private package Jpats_Warning.Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Warning.Controller;
