-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Warning.Container;

with Jpats_Electrical;
with Jpats_Environmental;
with Jpats_Fuel;
with Jpats_Hydraulics;
with Jpats_Secondary_Flight_Controls;
with Jpats_Powerplant;
with Jpats_Flight_Instruments;
with Jpats_Flight_Instruments.Container;
with Jpats_Landing_Gear;
with Jpats_Landing_Gear_Types;
with Jpats_Simulated_Aircraft;
with Jpats_Engine_Data_Manager;
with Jpats_Scu;
with Jpats_Electrical_Types;
with Normalized_Types;
with Jpats_Lights;
with Length_Types;
with Log;

package body Jpats_Warning.Controller is

   procedure Initialize is
      package Ctnr          renames Container;
      package Panel         renames Ctnr.Master_Caution_Panel;
      package Flasher       renames Ctnr.Flasher;
      package Annunciator   renames Ctnr.Annunciator;
      package Fire_Sensors  renames Ctnr.Fire_Sensors;

      The_Panel            : Panel.Instance        renames Ctnr.This_Subsystem.The_Master_Caution_Panel;
      The_Warn_Flasher     : Flasher.Instance      renames Ctnr.This_Subsystem.The_Warn_Flasher;
      The_Caution_Flasher  : Flasher.Instance      renames Ctnr.This_Subsystem.The_Caution_Flasher;
      The_Fire_1_Annunciator : Annunciator.Instance  renames Ctnr.This_Subsystem.The_Fire_1_Annunciator;
      The_Fire_2_Annunciator : Annunciator.Instance  renames Ctnr.This_Subsystem.The_Fire_2_Annunciator;
      The_Fire_Sensors     : Fire_Sensors.Instance renames Ctnr.This_Subsystem.The_Fire_Sensors;

   begin
      Panel.Initialize (The_Panel);
      Flasher.Initialize (The_Warn_Flasher);
      Flasher.Initialize (The_Caution_Flasher);
      Fire_Sensors.Initialize (The_Fire_Sensors);
      Annunciator.Initialize (The_Fire_1_Annunciator);
      Annunciator.Initialize (The_Fire_2_Annunciator);

      --|Initialize tone generator.
      null;
   exception
      when others =>
         Log.Report("Jpats_Warning.Controller.Initialize()");
         raise;
   end Initialize;



   procedure Update
     (Iconst : in Float) is


      package Ctnr          renames Container;
      package Ele           renames Jpats_Electrical;
      package Ele_T         renames Jpats_Electrical_Types;
      package Env           renames Jpats_Environmental;
      package Fuel          renames Jpats_Fuel;
      package Hyd           renames Jpats_Hydraulics;
      package Sfc           renames Jpats_Secondary_Flight_Controls;
      package Pwrplnt       renames Jpats_Powerplant;
      package Flt_Instr     renames Jpats_Flight_Instruments;
      package Panel         renames Ctnr.Master_Caution_Panel;
      package Flasher       renames Ctnr.Flasher;
      package Annunciator   renames Ctnr.Annunciator;
      package Fire_Sensors  renames Ctnr.Fire_Sensors;
      package Edm           renames Jpats_Engine_Data_Manager;
      package Scu           renames Jpats_Scu;
      package Gear          renames Jpats_Landing_Gear;
      package Gear_T        renames Jpats_Landing_Gear_Types;
      package Lts           renames Jpats_Lights;

      The_Panel              : Panel.Instance        renames Ctnr.This_Subsystem.The_Master_Caution_Panel;
      The_Warn_Flasher       : Flasher.Instance      renames Ctnr.This_Subsystem.The_Warn_Flasher;
      The_Caution_Flasher    : Flasher.Instance      renames Ctnr.This_Subsystem.The_Caution_Flasher;
      The_Fire_1_Annunciator : Annunciator.Instance  renames Ctnr.This_Subsystem.The_Fire_1_Annunciator;
      The_Fire_2_Annunciator : Annunciator.Instance  renames Ctnr.This_Subsystem.The_Fire_2_Annunciator;
      The_Fire_Sensors       : Fire_Sensors.Instance renames Ctnr.This_Subsystem.The_Fire_Sensors;


      Warn_Flash_Command_Last_Pass    : Boolean renames Ctnr.This_Subsystem.Warn_Flash_Command_Last_Pass;
      Caution_Flash_Command_Last_Pass : Boolean renames Ctnr.This_Subsystem.Caution_Flash_Command_Last_Pass;
      Warn_Flash_Command              : Boolean renames Ctnr.This_Subsystem.Warn_Flash_Command;
      Caution_Flash_Command           : Boolean renames Ctnr.This_Subsystem.Caution_Flash_Command;
      Silenced                        : Boolean renames Ctnr.This_Subsystem.Silenced;
      Warning_Silence_Sw_Last_Pass    : Boolean renames Ctnr.This_Subsystem.Warning_Silence_Sw_Last_Pass;
      Ldg_Gr_Enable_Lp                : Float   renames Ctnr.This_Subsystem.Ldg_Gr_Enable_Lp;

      A_W_Q   : Ctnr.Aural_Warn_Queue_Type renames Ctnr.This_Subsystem.Aural_Warn_Queue;
      A_W_Q_V : Boolean renames Ctnr.This_Subsystem.Aural_Warn_Queue_Value;

      Io  : Ctnr.Io_Interface_Instance  renames Ctnr.This_Io_Interface;
      Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
      Sound : Ctnr.Sound_Interface_Instance renames Ctnr.This_Sound_Interface;

      Power_To_Mcw_Panel : constant Boolean := (Ele.Is_Powered (Ele_T.Cws_Cb_Fwd_Gen_Bus) or
                                                  Ele.Is_Powered (Ele_T.Cws_Cb_Fwd_Batt_Bus));


      Warn_Request : constant Ctnr.Warn_Array_Of_Boolean :=
        (Ctnr.Bat_Bus     => Ele.Bat_Bus_Annunciator_Request,
         Ctnr.Canopy      => Env.Canopy_Annunciator_Request,
         Ctnr.Gen_Bus     => Ele.Gen_Bus_Annunciator_Request,
         Ctnr.Fuel_Px     => Fuel.Fuel_Px_Annunciator_Request,
         Ctnr.Pmu_Fail    => Pwrplnt.Pmu_Fail_Annunciator_Request,
         Ctnr.Oil_Px_Warn => Scu.Oil_Px_Warn_Request,
         Ctnr.Gen         => Ele.Gen_Annunciator_Request,
         Ctnr.Obogs_Fail  => Env.Obogs_Fail_Annunciator_Request,
         Ctnr.Ckpt_Px     => (Edm.Cockpit_Press_Hi_Output and Ele.Is_Powered (Ele_T.Edm_Cb_Fwd_Batt_Bus)),
         Ctnr.Chip        => Pwrplnt.Chip_Annunciator_Request);

      Warn_Power : constant Ctnr.Warn_Array_Of_Boolean :=
        (Ctnr.Bat_Bus     => Power_To_Mcw_Panel,
         Ctnr.Canopy      => Power_To_Mcw_Panel,
         Ctnr.Gen_Bus     => Power_To_Mcw_Panel,
         Ctnr.Fuel_Px     => Power_To_Mcw_Panel,
         Ctnr.Pmu_Fail    => Power_To_Mcw_Panel,
         Ctnr.Oil_Px_Warn => Power_To_Mcw_Panel,
         Ctnr.Gen         => Power_To_Mcw_Panel,
         Ctnr.Obogs_Fail  => Power_To_Mcw_Panel,
         Ctnr.Ckpt_Px     => Power_To_Mcw_Panel,
         Ctnr.Chip        => Power_To_Mcw_Panel);

      Caution_Request : constant Ctnr.Caution_Array_Of_Boolean :=
        (Ctnr.Ckpt_Alt              => Edm.Cockpit_Alt_Hi_Output,
         Ctnr.Fuel_Bal              => Edm.Auto_Balance_Fail_Output,
         Ctnr.L_Fuel_Lo             => Fuel.L_Fuel_Lo_Annunciator_Request,
         Ctnr.Pmu_Status            => Pwrplnt.Pmu_Status_Annunciator_Request,
         Ctnr.R_Fuel_Lo             => Fuel.R_Fuel_Lo_Annunciator_Request,
         Ctnr.Hydr_Fl_Lo            => Hyd.Hydr_Fl_Lo_Annunciator_Request,
         Ctnr.Hydr_Px_Lo_Ehyd_Fl_Lo => Hyd.Emerg_Hydr_Px_Lo_Annunciator_Request,
         Ctnr.Duct_Temp             => Env.Duct_Temp_Annunciator_Request,
         Ctnr.Tad_Fail              => Sfc.Tad_Fail_Annunciator_Request,
         Ctnr.Bus_Tie               => Ele.Bus_Tie_Annunciator_Request,
         Ctnr.Oil_Px_Caut           => Scu.Oil_Px_Caution_Request,
         Ctnr.Obogs_Temp            => Env.Obogs_Temp_Annunciator_Request);

      Caution_Power : constant Ctnr.Caution_Array_Of_Boolean :=
        (Ctnr.Ckpt_Alt              => Power_To_Mcw_Panel,
         Ctnr.Fuel_Bal              => Power_To_Mcw_Panel,
         Ctnr.L_Fuel_Lo             => Power_To_Mcw_Panel,
         Ctnr.Pmu_Status            => Power_To_Mcw_Panel,
         Ctnr.R_Fuel_Lo             => Power_To_Mcw_Panel,
         Ctnr.Hydr_Fl_Lo            => Power_To_Mcw_Panel,
         Ctnr.Hydr_Px_Lo_Ehyd_Fl_Lo => Power_To_Mcw_Panel,
         Ctnr.Duct_Temp             => Power_To_Mcw_Panel,
         Ctnr.Tad_Fail              => Power_To_Mcw_Panel,
         Ctnr.Bus_Tie               => Power_To_Mcw_Panel,
         Ctnr.Oil_Px_Caut           => Power_To_Mcw_Panel,
         Ctnr.Obogs_Temp            => Power_To_Mcw_Panel);

      Advisory_Request : constant Ctnr.Advisory_Array_Of_Boolean :=
        (Ctnr.Trim_Off   => Sfc.Trim_Off_Annunciator_Request,
         Ctnr.Boost_Pump => Fuel.Boost_Pump_Annunciator_Request,
         Ctnr.Anti_Ice   => Flt_Instr.Anti_Ice_Annunciator_Request,
         Ctnr.Ign_Sel    => Pwrplnt.Ign_Select_Annunciator_Request,
         Ctnr.Tad_Off    => Sfc.Tad_Off_Annunciator_Request,
         Ctnr.M_Fuel_Bal => Fuel.M_Fuel_Bal_Annunciator_Request,
         Ctnr.St_Ready   => Pwrplnt.Start_Ready_Annunciator_Request);

      Advisory_Power : constant Ctnr.Advisory_Array_Of_Boolean :=
        (Ctnr.Trim_Off   => Power_To_Mcw_Panel,
         Ctnr.Boost_Pump => Power_To_Mcw_Panel,
         Ctnr.Anti_Ice   => Power_To_Mcw_Panel,
         Ctnr.Ign_Sel    => Power_To_Mcw_Panel,
         Ctnr.Tad_Off    => Power_To_Mcw_Panel,
         Ctnr.M_Fuel_Bal => Power_To_Mcw_Panel,
         Ctnr.St_Ready   => Power_To_Mcw_Panel);


      Spare_Power : constant Ctnr.Spare_Array_Of_Boolean :=
        (Ctnr.Spare_1 => Power_To_Mcw_Panel,
         Ctnr.Spare_2 => Power_To_Mcw_Panel);

      Fire_Sensor_Input : Container.Fire_Sensors_Array_Of_Boolean := (others => False);


--      Airspeed : constant Length_Types.Knots := Length_Types.Feet_Per_Sec_To_Knots(Jpats_Simulated_Aircraft.Get_True_Airspeed);
--      Airspeed : constant Length_Types.Knots := Jpats_Simulated_Aircraft.Get_Calibrated_Airspeed;
      Airspeed : constant Length_Types.Knots := JPATS_Flight_Instruments.Primary_Ias;

      Ldg_Position_Warn_Condition_1 : Boolean;
      Ldg_Position_Warn_Condition_2 : Boolean;
      Ldg_Position_Warn_Condition_3 : Boolean;
      Ldg_Position_Warn : Boolean;
      Master_Caution_Warn : Boolean;
      Fire_Warn_Per_Eng_Torque : Boolean;

   begin


      Panel.Update
        (An_Instance      => The_Panel,
         Warn_Request     => Warn_Request,
         Warn_Power       => Warn_Power,
         Caution_Request  => Caution_Request,
         Caution_Power    => Caution_Power,
         Advisory_Request => Advisory_Request,
         Advisory_Power   => Advisory_Power,
         Spare_Power      => Spare_Power,
         Warn_Reset       => Io.Master_Warn_Sw,
         Caution_Reset    => Io.Master_Caution_Sw,
         Test             => Lts.Lamp_Test_Sw and Ele.Is_Powered (Ele_T.Test_Lts_Cb));


      Io.Ann_Pnl_Bat_Bus_Lt      := Panel.Is_On (The_Panel, Ctnr.Bat_Bus);
      Io.Ann_Pnl_Gen_Bus_Lt      := Panel.Is_On (The_Panel, Ctnr.Gen_Bus);
      Io.Ann_Pnl_Pmu_Fail_Lt     := Panel.Is_On (The_Panel, Ctnr.Pmu_Fail);
      Io.Ann_Pnl_Gen_Lt          := Panel.Is_On (The_Panel, Ctnr.Gen);
      Io.Ann_Pnl_Ckpt_Px_Lt      := Panel.Is_On (The_Panel, Ctnr.Ckpt_Px);
      Io.Ann_Pnl_Canopy_Lt       := Panel.Is_On (The_Panel, Ctnr.Canopy);
      Io.Ann_Pnl_Fuel_Px_Lt      := Panel.Is_On (The_Panel, Ctnr.Fuel_Px);
      Io.Ann_Pnl_Oil_Px_Warn_Lt  := Panel.Is_On (The_Panel, Ctnr.Oil_Px_Warn);
      Io.Ann_Pnl_Obogs_Fail_Lt   := Panel.Is_On (The_Panel, Ctnr.Obogs_Fail);
      Io.Ann_Pnl_Chip_Lt         := Panel.Is_On (The_Panel, Ctnr.Chip);
      Io.Ann_Pnl_Ckpt_Alt_Lt     := Panel.Is_On (The_Panel, Ctnr.Ckpt_Alt);
      Io.Ann_Pnl_Spare1_Lt       := Panel.Is_On (The_Panel, Ctnr.Spare_1);
      Io.Ann_Pnl_Hydr_Fl_Lo_Lt   := Panel.Is_On (The_Panel, Ctnr.Hydr_Fl_Lo);
      Io.Ann_Pnl_Bus_Tie_Lt      := Panel.Is_On (The_Panel, Ctnr.Bus_Tie);
      Io.Ann_Pnl_Fuel_Bal_Lt     := Panel.Is_On (The_Panel, Ctnr.Fuel_Bal);
      Io.Ann_Pnl_Pmu_Status_Lt   := Panel.Is_On (The_Panel, Ctnr.Pmu_Status);
      Io.Ann_Pnl_Hydr_Px_Lo_Lt   := Panel.Is_On (The_Panel, Ctnr.Hydr_Px_Lo_Ehyd_Fl_Lo);
      Io.Ann_Pnl_Tad_Fail_Lt     := Panel.Is_On (The_Panel, Ctnr.Tad_Fail);
      Io.Ann_Pnl_Obogs_Temp_Lt   := Panel.Is_On (The_Panel, Ctnr.Obogs_Temp);
      Io.Ann_Pnl_L_Fuel_Lo_Lt    := Panel.Is_On (The_Panel, Ctnr.L_Fuel_Lo);
      Io.Ann_Pnl_R_Fuel_Lo_Lt    := Panel.Is_On (The_Panel, Ctnr.R_Fuel_Lo);
      Io.Ann_Pnl_Duct_Temp_Lt    := Panel.Is_On (The_Panel, Ctnr.Duct_Temp);
      Io.Ann_Pnl_Ign_Sel_Lt      := Panel.Is_On (The_Panel, Ctnr.Ign_Sel);
      Io.Ann_Pnl_Trim_Off_Lt     := Panel.Is_On (The_Panel, Ctnr.Trim_Off);
      Io.Ann_Pnl_Boost_Pump_Lt   := Panel.Is_On (The_Panel, Ctnr.Boost_Pump);
      Io.Ann_Pnl_Anti_Ice_Lt     := Panel.Is_On (The_Panel, Ctnr.Anti_Ice);
      Io.Ann_Pnl_Tad_Off_Lt      := Panel.Is_On (The_Panel, Ctnr.Tad_Off);
      Io.Ann_Pnl_St_Ready_Lt     := Panel.Is_On (The_Panel, Ctnr.St_Ready);
      Io.Ann_Pnl_M_Fuel_Bal      := Panel.Is_On (The_Panel, Ctnr.M_Fuel_Bal);
      Io.Ann_Pnl_Oil_Px_Caut_Lt  := Panel.Is_On (The_Panel, Ctnr.Oil_Px_Caut);

      Io.Ann_Pnl_Dimming_Input := Lts.Day_Night_Relay;


      --|Update fire detectors.
      --ios for engine fire (engine) or test switch...

      Fire_Warn_Per_Eng_Torque := Ios.Fire_Warn_Per_Eng_Torque and Pwrplnt.Engine_Torque_Pct >= 0.25;

      if Ele.Is_Powered (Ele_T.Fire_Detect_Cb_Fwd_Aux_Batt_Bus) then
         Fire_Sensor_Input (Ctnr.Number_1) := (Ios.Fire_Warn
                                               or Fire_Warn_Per_Eng_Torque
                                               or Pwrplnt.Fire_Warning_Request); -- fire/sensor malf here
      else
         Fire_Sensor_Input (Ctnr.Number_1) := False;
      end if;

      if Ele.Is_Powered (Ele_T.Fire_Detect_Cb_Fwd_Gen_Bus) then
--          Fire_Sensor_Input (Ctnr.Number_2) := (Ios.Fire_Warn
--                                                or Fire_Warn_Per_Eng_Torque
--                                                or Pwrplnt.Fire_Warning_Request);  -- fire/sensor malf here
         Fire_Sensor_Input (Ctnr.Number_2) := (Fire_Warn_Per_Eng_Torque
                                               or Pwrplnt.Fire_Warning_Request);  -- fire/sensor malf here
      else
         Fire_Sensor_Input (Ctnr.Number_2) := False;
      end if;

      Fire_Sensors.Update
        (An_Instance => The_Fire_Sensors,
         Fire        => Fire_Sensor_Input);

      Annunciator.Update
        (An_Instance => The_Fire_1_Annunciator,
         Request     => Fire_Sensors.Is_Fire (The_Fire_Sensors, Ctnr.Number_1),
         Power       => Ele.Is_Powered (Ele_T.Fire_Detect_Cb_Fwd_Aux_Batt_Bus),
         Test        => ((Lts.Lamp_Test_Sw and  Ele.Is_Powered (Ele_T.Test_Lts_Cb))
                         or (Io.Fire_Det_No_1_Test_Sw and  Ele.Is_Powered (Ele_T.Fire_Detect_Cb_Fwd_Aux_Batt_Bus))),
         Reset       => Io.Master_Warn_Sw);

      Annunciator.Update
        (An_Instance => The_Fire_2_Annunciator,
         Request     => Fire_Sensors.Is_Fire (The_Fire_Sensors, Ctnr.Number_2),
         Power       => Ele.Is_Powered (Ele_T.Fire_Detect_Cb_Fwd_Gen_Bus),
         Test        => ((Lts.Lamp_Test_Sw and  Ele.Is_Powered (Ele_T.Test_Lts_Cb))
                         or (Io.Fire_Det_No_2_Test_Sw and Ele.Is_Powered (Ele_T.Fire_Detect_Cb_Fwd_Gen_Bus))),
         Reset       => Io.Master_Warn_Sw);

      Io.Eng_Fire_Lt := Annunciator.Is_On (The_Fire_1_Annunciator);
      Io.Eng_Fire_2  := Annunciator.Is_On (The_Fire_2_Annunciator);

      -- Update switch lights.

      Warn_Flash_Command := (((Annunciator.Flash_Request(The_Fire_1_Annunciator) or
                              Annunciator.Flash_Request(The_Fire_2_Annunciator)) or
                             (Panel.Warn_Flash_Command (The_Panel)) or
                              (Warn_Flash_Command and not Io.Master_Warn_Sw)) and Power_To_Mcw_Panel);

      --****************************************************************************************************************
      --****************************************************************************************************************
      --****************************************************************************************************************

--       if Warn_Flash_Command /= Warn_Flash_Command_Last_Pass then
--          if Warn_Flash_Command then
--             if Annunciator.Flash_Request(The_Fire_1_Annunciator) then
--                Log.Report("The_Fire_1_Annunciator = T");
--             end if;
--             if Annunciator.Flash_Request(The_Fire_2_Annunciator) then
--                Log.Report("The_Fire_2_Annunciator = T");
--             end if;
--             if Panel.Warn_Flash_Command (The_Panel) then
--                Log.Report("The_Panel = T");
--             end if;
--             if Warn_Flash_Command and not Io.Master_Warn_Sw then
--                Log.Report("Warn_Flash_Command and not Io.Master_Warn_Sw = T");
--             end if;
--          else
--            Log.Report("Warn_Flash_Command = F");
--          end if;
--       end if;

      --****************************************************************************************************************
      --****************************************************************************************************************
      --****************************************************************************************************************

      Flasher.Update
        (An_Instance   => The_Warn_Flasher,
         Iconst        => Iconst,
         Flash_Command => Warn_Flash_Command);


      Caution_Flash_Command := (Panel.Caution_Flash_Command (The_Panel) or
                                (Caution_Flash_Command and not Io.Master_Caution_Sw)) and Power_To_Mcw_Panel;

      --****************************************************************************************************************
      --****************************************************************************************************************
      --****************************************************************************************************************

--       if Caution_Flash_Command /= Caution_Flash_Command_Last_Pass then
--          if Caution_Flash_Command then
--             if Panel.Caution_Flash_Command (The_Panel) then
--                Log.Report("The_Panel = T");
--             end if;
--             if Caution_Flash_Command and not Io.Master_Caution_Sw then
--                Log.Report("Caution_Flash_Command and not Io.Master_Caution_Sw = T");
--             end if;
--          else
--            Log.Report("Caution_Flash_Command = F");
--          end if;
--       end if;


      --****************************************************************************************************************
      --****************************************************************************************************************
      --****************************************************************************************************************

      Flasher.Update
        (An_Instance   => The_Caution_Flasher,
         Iconst        => Iconst,
         Flash_Command => Caution_Flash_Command);


      Io.Master_Warn_Lt    := Flasher.Is_Illuminated (The_Warn_Flasher);
      Io.Master_Caution_Lt := Flasher.Is_Illuminated (The_Caution_Flasher);

      --|Update tone generator (aoa warnings).

      if not Ele.Is_Powered(Ele_T.Adc_Cb) then
         Ldg_Position_Warn_Condition_1 := False;
      elsif Flt_Instr.Container.This_Ios_Interface.Adc_Fail then
         Ldg_Position_Warn_Condition_1 := False;
      else
         Ldg_Position_Warn_Condition_1 := (Gear.Gear_Handle_Is_Up and
                                           Pwrplnt.Landing_Gear_Warn_Low_Throttle_Switch and
                                           Airspeed < 120.0);
      end if;

      if Io.Warning_Silence_Sw and not Warning_Silence_Sw_Last_Pass then
         Silenced := True;
      elsif not Pwrplnt.Landing_Gear_Warn_Low_Throttle_Switch then
         Silenced := False;
      end if;

      Warning_Silence_Sw_Last_Pass := Io.Warning_Silence_Sw;

      Ldg_Position_Warn_Condition_1 := Ldg_Position_Warn_Condition_1 and not Silenced;
      Ldg_Position_Warn_Condition_2 := (Gear.Is_Open (Gear_T.Nose_Gear_Down_And_Locked_Switch) and
                                        Gear.Is_Open (Gear_T.Left_Gear_Down_And_Locked_Switch) and
                                        Gear.Is_Open (Gear_T.Right_Gear_Down_And_Locked_Switch) and
                                        Sfc.Flap_Handle_Landing);
      Ldg_Position_Warn_Condition_3 := (Gear.Is_Closed (Gear_T.Left_Landing_Gear_A1_WOW_Relay) and
                                        Gear.Gear_Handle_Is_Up);

      Ldg_Position_Warn := (Ldg_Position_Warn_Condition_1 or
                            Ldg_Position_Warn_Condition_2 or
                            Ldg_Position_Warn_Condition_3);

      if ((Ldg_Position_Warn or Io.Ldg_Gr_Test_Sw) and
          (Ele.Is_Powered(Ele_T.Aural_Warn_Cb) and Ele.Is_Powered(Ele_T.Ldg_Gr_Cont_Cb))) then
         Sound.Landing_Gear_Warning_Enable := 1.0;
      else
         Sound.Landing_Gear_Warning_Enable := 0.0;
      end if;

      Ldg_Gr_Enable_Lp := Sound.Landing_Gear_Warning_Enable;

      Master_Caution_Warn := Warn_Flash_Command or Caution_Flash_Command;

      A_W_Q (A_W_Q'First+1..A_W_Q'Last) :=
        A_W_Q (A_W_Q'First..A_W_Q'Last-1);
      A_W_Q (A_W_Q'First) := Master_Caution_Warn;
      A_W_Q_V := True;

      for I in A_W_Q'Range
      loop
         A_W_Q_V := A_W_Q (I);
         exit when not A_W_Q_V;
      end loop;

      if A_W_Q_V and Ele.Is_Powered(Ele_T.Aural_Warn_Cb) then
         Sound.Warn_Caution_Fire_Enable := 1.0;
      else
         Sound.Warn_Caution_Fire_Enable := 0.0;
      end if;

      Warn_Flash_Command_Last_Pass    := Warn_Flash_Command;
      Caution_Flash_Command_Last_Pass := Caution_Flash_Command;

      Ctnr.Tone_Generator.Update
        (An_Instance => Ctnr.This_Subsystem.The_Tone_Generator);

      ---------------------------------
      -- FLIGHT DATA RECORDER LIGHTS --
      ---------------------------------

--       Io.Fail_Lt_On := ((not Ele.Is_Powered (Ele_T.Fdr_Cb))
--                         and Ele.Is_Powered (Ele_T.Inst_Lts_Cb));

--       Io.Maint_Lt_On := (Ele.Is_Powered (Ele_T.Inst_Lts_Cb)
--                          and Lts.Lamp_Test_Sw and Ele.Is_Powered (Ele_T.Test_Lts_Cb));

   exception
      when others =>
         Log.Report("Jpats_Warning.Controller.Update()");
         raise;
   end Update;

end Jpats_Warning.Controller;

