-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Annunciator_G;
with Master_Caution_Panel_G;
with Fire_Sensor_G;
with Fire_Sensor_Collection_G;
with Flasher_G;
with Tone_Generator_G;

private package Jpats_Warning.Container is

   -- annunciators
   package Annunciator is new Annunciator_G
     (Package_Name => "Jpats_Warning.Container.Annunciator");

   type Warn_Annunciator_Name_Type is (Bat_Bus,
                                       Canopy,
                                       Gen_Bus,
                                       Fuel_Px,
                                       Pmu_Fail,
                                       Oil_Px_Warn,
                                       Gen,
                                       Obogs_Fail,
                                       Ckpt_Px,
                                       Chip);
   type Warn_Array_Of_Annunciator_Type is array (Warn_Annunciator_Name_Type) of Annunciator.Instance;
   type Warn_Array_Of_Boolean is array (Warn_Annunciator_Name_Type) of Boolean;

   type Caution_Annunciator_Name_Type is (Ckpt_Alt,
                                          Fuel_Bal,
                                          L_Fuel_Lo,
                                          Pmu_Status,
                                          R_Fuel_Lo,
                                          Hydr_Fl_Lo,
                                          Hydr_Px_Lo_Ehyd_Fl_Lo,
                                          Duct_Temp,
                                          Tad_Fail,
                                          Bus_Tie,
                                          Obogs_Temp,
                                          Oil_Px_Caut);
   type Caution_Array_Of_Annunciator_Type is array (Caution_Annunciator_Name_Type) of Annunciator.Instance;
   type Caution_Array_Of_Boolean is array (Caution_Annunciator_Name_Type) of Boolean;

   type Advisory_Annunciator_Name_Type is (Trim_Off,
                                           Boost_Pump,
                                           Anti_Ice,
                                           Ign_Sel,
                                           Tad_Off,
                                           M_Fuel_Bal,
                                           St_Ready);
   type Advisory_Array_Of_Annunciator_Type is array (Advisory_Annunciator_Name_Type) of Annunciator.Instance;
   type Advisory_Array_Of_Boolean is array (Advisory_Annunciator_Name_Type) of Boolean;

   type Spare_Annunciator_Name_Type is (Spare_1,
                                        Spare_2);
   type Spare_Array_Of_Annunciator_Type is array (Spare_Annunciator_Name_Type) of Annunciator.Instance;
   type Spare_Array_Of_Boolean is array (Spare_Annunciator_Name_Type) of Boolean;

-- master caution panel
   package Master_Caution_Panel is new Master_Caution_Panel_G
     (Annunciator_Type                   => Annunciator.Instance,
      Warn_Annunciator_Name_Type         => Warn_Annunciator_Name_Type,
      Warn_Array_Of_Annunciator_Type     => Warn_Array_Of_Annunciator_Type,
      Warn_Array_Of_Boolean              => Warn_Array_Of_Boolean,
      Caution_Annunciator_Name_Type      => Caution_Annunciator_Name_Type,
      Caution_Array_Of_Annunciator_Type  => Caution_Array_Of_Annunciator_Type,
      Caution_Array_Of_Boolean           => Caution_Array_Of_Boolean,
      Advisory_Annunciator_Name_Type     => Advisory_Annunciator_Name_Type,
      Advisory_Array_Of_Annunciator_Type => Advisory_Array_Of_Annunciator_Type,
      Advisory_Array_Of_Boolean          => Advisory_Array_Of_Boolean,
      Spare_Annunciator_Name_Type        => Spare_Annunciator_Name_Type,
      Spare_Array_Of_Annunciator_Type    => Spare_Array_Of_Annunciator_Type,
      Spare_Array_Of_Boolean             => Spare_Array_Of_Boolean,
      Update_A_Annunciator               => Annunciator.Update,
      A_Annunciator_Flash_Request        => Annunciator.Flash_Request,
      Initialize_A_Annunciator           => Annunciator.Initialize,
      A_Annunciator_Is_On                => Annunciator.Is_On,
      Package_Name                       => "Jpats_Warning.Container.Master_Caution_Panel");

-- fire sensors
   package Fire_Sensor is new Fire_Sensor_G
     (Package_Name  => "Jpats_Warning.Container.Fire_Sensor");
   type Fire_Sensor_Name_Type is (Number_1, Number_2);
   type Array_Of_Fire_Sensor_Type is array (Fire_Sensor_Name_Type) of Fire_Sensor.Instance;
   type Fire_Sensors_Array_Of_Boolean is array (Fire_Sensor_Name_Type) of Boolean;
   package Fire_Sensors is new Fire_Sensor_Collection_G
     (Fire_Sensor_Name_Type         => Fire_Sensor_Name_Type,
      Fire_Sensor_Type              => Fire_Sensor.Instance,
      Array_Of_Fire_Sensor_Type     => Array_Of_Fire_Sensor_Type,
      Fire_Sensors_Array_Of_Boolean => Fire_Sensors_Array_Of_Boolean,
      A_Sensor_Is_Fire              => Fire_Sensor.Is_Fire,
      Update_A_Sensor               => Fire_Sensor.Update,
      Initialize_A_Sensor           => Fire_Sensor.Initialize,
      Package_Name                  => "Jpats_Warning.Container.Fire_Sensors");

-- master caution and warn flashers
   package Flasher is new Flasher_G
     (Flash_Hz     => 2,
      Package_Name => "Jpats_Warning.Container.Flasher");

-- tone generator
   package Tone_Generator is new Tone_Generator_G
     (Package_Name => "Jpats_Warning.Container.Tone_Generator");

-- queue for aural cb delay
   type Aural_Warn_Queue_Type is array (1..3) of Boolean;

   type Instance is
      record
         The_Fire_1_Annunciator   : Annunciator.Instance;
         The_Fire_2_Annunciator   : Annunciator.Instance;
         The_Master_Caution_Panel : Master_Caution_Panel.Instance;
         The_Fire_Sensors         : Fire_Sensors.Instance;
         The_Warn_Flasher         : Flasher.Instance;
         The_Caution_Flasher      : Flasher.Instance;
         The_Tone_Generator       : Tone_Generator.Instance;

         -- Added to record for replay to work....
         Warn_Flash_Command_Last_Pass    : Boolean := False;
         Caution_Flash_Command_Last_Pass : Boolean := False;
         Warn_Flash_Command              : Boolean := False;
         Caution_Flash_Command           : Boolean := False;
         Silenced                        : Boolean := False;
         Warning_Silence_Sw_Last_Pass    : Boolean := False;
         Ldg_Gr_Enable_Lp                : Float   := 0.0;
         Aural_Warn_Queue                : Aural_Warn_Queue_Type := (others => False);
         Aural_Warn_Queue_Value          : Boolean := False;

      end record;
   This_Subsystem : Instance;

   type Io_Interface_Instance is
      record
         -- digital input
         Master_Warn_Sw                : Boolean := False;
         Master_Caution_Sw             : Boolean := False;
         Fire_Det_No_1_Test_Sw         : Boolean := False;
         Fire_Det_No_2_Test_Sw         : Boolean := False;
         Ldg_Gr_Test_Sw                : Boolean := False;
         Ldg_Gear_Warn_Low_Throt_Sw    : Boolean := False;
         Warning_Silence_Sw            : Boolean := False;

         -- digital output
         Master_Warn_Lt                : Boolean := False;
         Master_Caution_Lt             : Boolean := False;
         Eng_Fire_Lt                   : Boolean := False;
         Eng_Fire_2                    : Boolean := False;
--          Maint_Lt_On                   : Boolean := False;
--          Fail_Lt_On                    : Boolean := False;

         Ann_Pnl_Bat_Bus_Lt            : Boolean := False;
         Ann_Pnl_Gen_Bus_Lt            : Boolean := False;
         Ann_Pnl_Pmu_Fail_Lt           : Boolean := False;
         Ann_Pnl_Gen_Lt                : Boolean := False;
         Ann_Pnl_Ckpt_Px_Lt            : Boolean := False;
         Ann_Pnl_Canopy_Lt             : Boolean := False;
         Ann_Pnl_Fuel_Px_Lt            : Boolean := False;
         Ann_Pnl_Oil_Px_Warn_Lt        : Boolean := False;
         Ann_Pnl_Obogs_Fail_Lt         : Boolean := False;
         Ann_Pnl_Chip_Lt               : Boolean := False;
         Ann_Pnl_Ckpt_Alt_Lt           : Boolean := False;
         Ann_Pnl_Spare1_Lt             : Boolean := False;
         Ann_Pnl_Hydr_Fl_Lo_Lt         : Boolean := False;
         Ann_Pnl_Oil_Px_Caut_Lt        : Boolean := False;
         Ann_Pnl_Bus_Tie_Lt            : Boolean := False;
         Ann_Pnl_Fuel_Bal_Lt           : Boolean := False;
         Ann_Pnl_Pmu_Status_Lt         : Boolean := False;
         Ann_Pnl_Hydr_Px_Lo_Lt         : Boolean := False;
         Ann_Pnl_Tad_Fail_Lt           : Boolean := False;
         Ann_Pnl_Obogs_Temp_Lt         : Boolean := False;
         Ann_Pnl_L_Fuel_Lo_Lt          : Boolean := False;
         Ann_Pnl_R_Fuel_Lo_Lt          : Boolean := False;
         Ann_Pnl_Duct_Temp_Lt          : Boolean := False;
         Ann_Pnl_Ign_Sel_Lt            : Boolean := False;
         Ann_Pnl_Trim_Off_Lt           : Boolean := False;
         Ann_Pnl_Boost_Pump_Lt         : Boolean := False;
         Ann_Pnl_Anti_Ice_Lt           : Boolean := False;
         Ann_Pnl_Tad_Off_Lt            : Boolean := False;
         Ann_Pnl_St_Ready_Lt           : Boolean := False;
         Ann_Pnl_M_Fuel_Bal            : Boolean := False;

         Ann_Pnl_Dimming_Input         : Boolean := False;

         -- analog input
         -- analog output

         -- spare
         Spare_Io_1                    : Boolean;
      end record;

   Io_Size : constant Integer := 4;

   for Io_Interface_Instance use
      record
         --spare
         Spare_Io_1                    at  000*Io_Size range 0..31;

         -- digital input
         Master_Warn_Sw                at  001*Io_Size range 0..31;
         Master_Caution_Sw             at  002*Io_Size range 0..31;
         Fire_Det_No_1_Test_Sw         at  003*Io_Size range 0..31;
         Fire_Det_No_2_Test_Sw         at  004*Io_Size range 0..31;
         Ldg_Gr_Test_Sw                at  005*Io_Size range 0..31;
         Ldg_Gear_Warn_Low_Throt_Sw    at  006*Io_Size range 0..31;
         Warning_Silence_Sw            at  007*Io_Size range 0..31;

         -- digital output
         Master_Warn_Lt                at  008*Io_Size range 0..31;
         Master_Caution_Lt             at  009*Io_Size range 0..31;
         Eng_Fire_Lt                   at  010*Io_Size range 0..31;
         Eng_Fire_2                    at  011*Io_Size range 0..31;
--          Maint_Lt_On                   at  012*Io_Size range 0..31;
--          Fail_Lt_On                    at  013*Io_Size range 0..31;

         Ann_Pnl_Bat_Bus_Lt            at  012*Io_Size range 0..31;
         Ann_Pnl_Gen_Bus_Lt            at  013*Io_Size range 0..31;
         Ann_Pnl_Pmu_Fail_Lt           at  014*Io_Size range 0..31;
         Ann_Pnl_Gen_Lt                at  015*Io_Size range 0..31;
         Ann_Pnl_Ckpt_Px_Lt            at  016*Io_Size range 0..31;
         Ann_Pnl_Canopy_Lt             at  017*Io_Size range 0..31;
         Ann_Pnl_Fuel_Px_Lt            at  018*Io_Size range 0..31;
         Ann_Pnl_Oil_Px_Warn_Lt        at  019*Io_Size range 0..31;
         Ann_Pnl_Obogs_Fail_Lt         at  020*Io_Size range 0..31;
         Ann_Pnl_Chip_Lt               at  021*Io_Size range 0..31;
         Ann_Pnl_Ckpt_Alt_Lt           at  022*Io_Size range 0..31;
         Ann_Pnl_Spare1_Lt             at  023*Io_Size range 0..31;
         Ann_Pnl_Hydr_Fl_Lo_Lt         at  024*Io_Size range 0..31;
         Ann_Pnl_Oil_Px_Caut_Lt        at  025*Io_Size range 0..31;
         Ann_Pnl_Bus_Tie_Lt            at  026*Io_Size range 0..31;
         Ann_Pnl_Fuel_Bal_Lt           at  027*Io_Size range 0..31;
         Ann_Pnl_Pmu_Status_Lt         at  028*Io_Size range 0..31;
         Ann_Pnl_Hydr_Px_Lo_Lt         at  029*Io_Size range 0..31;
         Ann_Pnl_Tad_Fail_Lt           at  030*Io_Size range 0..31;
         Ann_Pnl_Obogs_Temp_Lt         at  031*Io_Size range 0..31;
         Ann_Pnl_L_Fuel_Lo_Lt          at  032*Io_Size range 0..31;
         Ann_Pnl_R_Fuel_Lo_Lt          at  033*Io_Size range 0..31;
         Ann_Pnl_Duct_Temp_Lt          at  034*Io_Size range 0..31;
         Ann_Pnl_Ign_Sel_Lt            at  035*Io_Size range 0..31;
         Ann_Pnl_Trim_Off_Lt           at  036*Io_Size range 0..31;
         Ann_Pnl_Boost_Pump_Lt         at  037*Io_Size range 0..31;
         Ann_Pnl_Anti_Ice_Lt           at  038*Io_Size range 0..31;
         Ann_Pnl_Tad_Off_Lt            at  039*Io_Size range 0..31;
         Ann_Pnl_St_Ready_Lt           at  040*Io_Size range 0..31;
         Ann_Pnl_M_Fuel_Bal            at  041*Io_Size range 0..31;

         Ann_Pnl_Dimming_Input         at  042*Io_Size range 0..31; --043*Io_Size range 0..31;

         -- analog input                   044*Io_Size range 0..31;
         -- analog output

      end record;

   This_Io_Interface : Io_Interface_Instance;


   type Ios_Interface_Instance is
      record

         Fire_Warn                     : Boolean := False; -- mfen10
         Fire_Warn_Per_Eng_Torque      : Boolean := False; --

      end record;
   This_Ios_Interface : Ios_Interface_Instance;

   type Sound_Interface_Instance is
      record
         Landing_Gear_Warning_Enable  : Float := 0.0;
         Warn_Caution_Fire_Enable     : Float := 0.0;
      end record;
   This_Sound_Interface : Sound_Interface_Instance;


end Jpats_Warning.Container;
