-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Flasher_G is

   procedure Illuminate
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Illuminated := True;
   exception
      when others =>
         Log.Report(Package_Name & ".Illuminate()");
         raise;
   end Illuminate;

   procedure Turn_Off
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Illuminated := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_Off()");
         raise;
   end Turn_Off;

   function Is_Illuminated
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return An_Instance.Is_Illuminated;
   exception
      when others =>
         Log.Report(Package_Name & ".Is_Illuminated()");
         raise;
   end Is_Illuminated;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Is_Illuminated := False;
      An_Instance.Flash_Timer    := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance   : in out Instance;
      Iconst        : in     Float;
      Flash_Command : in     Boolean)
   is
   begin

      if Flash_Command then

         An_Instance.Flash_Timer := An_Instance.Flash_Timer + Iconst;

         if An_Instance.Flash_Timer > 1.0 then
            An_Instance.Flash_Timer := 0.0;
         end if;

         for I in 1..(2*Flash_Hz)
         loop
            if An_Instance.Flash_Timer < Float(I)/(2.0*Float(Flash_Hz)) then
               if I mod 2 = 0 then
                  Turn_Off (An_Instance);
                  exit;
               else
                  Illuminate (An_Instance);
                  exit;
               end if;
            end if;
         end loop;

      else

         An_Instance.Flash_Timer := 0.0;
         Turn_Off (An_Instance);

      end if;

   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

end Flasher_G;
