-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic

   type Fire_Sensor_Name_Type is (<>);
   type Fire_Sensor_Type is private;
   type Array_Of_Fire_Sensor_Type is array (Fire_Sensor_Name_Type) of Fire_Sensor_Type;
   type Fire_Sensors_Array_Of_Boolean is array (Fire_Sensor_Name_Type) of Boolean;

   with function A_Sensor_Is_Fire (A_Sensor : in Fire_Sensor_Type) return Boolean;
   with procedure Update_A_Sensor (A_Sensor : in out Fire_Sensor_Type;
                                   Is_Fire  : in     Boolean);
   with procedure Initialize_A_Sensor (A_Sensor : in out Fire_Sensor_Type);
   Package_Name : in String;

package Fire_Sensor_Collection_G is

   type Instance is private;

   procedure Update
     (An_Instance : in out Instance;
      Fire        : in     Fire_Sensors_Array_Of_Boolean);

   procedure Initialize
     (An_Instance : in out Instance);

   function Is_Fire
     (An_Instance : in Instance;
      Name        : in Fire_Sensor_Name_Type)
      return Boolean;

private

   type Instance is
      record
         Fire_Sensors : Array_Of_Fire_Sensor_Type;
      end record;

end Fire_Sensor_Collection_G;
