-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Annunciator_G is

   procedure Turn_On_Not_Acknowledged
     (An_Instance : in out Instance) is
   begin
      An_Instance.State         := On_Not_Acknowledged;
      An_Instance.Flash_Request := True;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_On_Not_Acknowledged()");
         raise;
   end Turn_On_Not_Acknowledged;

   procedure Turn_Off
     (An_Instance : in out Instance) is
   begin
      An_Instance.State         := Off;
      An_Instance.Flash_Request := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_Off()");
         raise;
   end Turn_Off;

   procedure Turn_On_Acknowledged
     (An_Instance : in out Instance) is
   begin
      An_Instance.State         := On_Acknowledged;
      An_Instance.Flash_Request := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Turn_On_Acknowledged()");
         raise;
   end Turn_On_Acknowledged;

   function State
     (An_Instance : in Instance)
      return State_Type is
   begin
      return An_Instance.State;
   exception
      when others =>
         Log.Report(Package_Name & ".State()");
         raise;
   end State;

   function Flash_Request
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Flash_Request;
   exception
      when others =>
         Log.Report(Package_Name & ".Flash_Request()");
         raise;
   end Flash_Request;

   function Is_On
     (An_Instance : in Instance)
     return Boolean
   is
   begin
      return not (An_Instance.State = Off);
   exception
      when others =>
         Log.Report(Package_Name & ".Is_On()");
         raise;
   end Is_On;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.State         := Off;
      An_Instance.Flash_Request := False;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance : in out Instance;
      Request     : in     Boolean;
      Power       : in     Boolean;
      Test        : in     Boolean;
      Reset       : in     Boolean) is
      Current_State : State_Type := State (An_Instance);
   begin
      case Current_State is
         when Off =>

            if (Request or Test) and Power then
               Turn_On_Not_Acknowledged (An_Instance);
            end if;


         when On_Not_Acknowledged =>


            if Power then

               if Test and Request then
                  null;
               elsif Test then
                  Turn_On_Acknowledged (An_Instance);
               else
                  if Reset and Request then
                     Turn_On_Acknowledged (An_Instance);
                  elsif Reset then
                    Turn_Off (An_Instance);
                  end if;
               end if;

            else
               Turn_Off (An_Instance);
            end if;


         when On_Acknowledged =>

            if not ((Request or Test) and Power) then
               Turn_Off (An_Instance);
            end if;

      end case;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;


end Annunciator_G;


