-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;

package Visibility is


  type Instance is private;

-- Access Visibility_NM
   function  Visibility_NM (An_Instance : in Instance) return Float;
   procedure Set_Visibility_NM
     (An_Instance : in out Instance;
      Visibility_Selected : in Float);

-- Access Visibliity_KM
   function  Visibility_KM (An_Instance : in Instance) return Float;
   procedure Set_Visibility_KM
     (An_Instance : in out Instance;
      Visibility_Selected : in Float);

-- Access Rwy_Vis_Range_FT
   function  Rwy_Vis_Range_FT (An_Instance : in Instance) return Integer;
   procedure Set_Rwy_Vis_Range_FT
     (An_Instance : in out Instance;
      Rvr_Selected : in Integer);

-- Access Rwy_Vis_Range_M
   function  Rwy_Vis_Range_M (An_Instance : in Instance) return Integer;
   procedure Set_Rwy_Vis_Range_M
     (An_Instance : in out Instance;
      Rvr_Selected : in Integer);

-- Method Calculate_Visibility
   procedure Calculate_Visibility
     (An_Instance : in out Instance;
      Precipitation_Type : in Integer;
      Precipitation_Level : in Integer);

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance);


private

  type Instance is record
    Visibility_NM : Float;
    Visibility_KM : Float;
    Rwy_Vis_Range_FT : Integer;
    Rwy_Vis_Range_M : Integer;
  end record;


end Visibility;
