-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Visibility is

   Old_Visibility : Float := 100.0;
   Precipitation_Type_N1 : Integer := 0;

-- Access Visibility_NM
   function  Visibility_NM
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Visibility_NM;
   end Visibility_NM;

   procedure Set_Visibility_NM
     (An_Instance : in out Instance;
      Visibility_Selected : in Float) is
   begin
      if Visibility_Selected > 500.0 then
         An_Instance.Visibility_Nm := 500.0;
      elsif Visibility_Selected < 0.0 then
         An_Instance.Visibility_Nm := 0.0;
      else
         An_Instance.Visibility_NM := Visibility_Selected;
      end if;
      An_Instance.Visibility_Km := An_Instance.Visibility_Nm * 1.609;
   end Set_Visibility_NM;

-- Access Visibility_KM
   function  Visibility_KM
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Visibility_KM;
   end Visibility_KM;

   procedure Set_Visibility_KM
     (An_Instance : in out Instance;
      Visibility_Selected : in Float) is
   begin
      if Visibility_Selected >  804.5 then
         An_Instance.Visibility_Km := 804.5;
      elsif Visibility_Selected < 0.0 then
         An_Instance.Visibility_Km := 0.0;
      else
         An_Instance.Visibility_KM := Visibility_Selected;
      end if;
      An_Instance.Visibility_Nm := An_Instance.Visibility_Km * 0.6214;
   end Set_Visibility_KM;

-- Access Rwy_Vis_Range_FT
   function  Rwy_Vis_Range_FT
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Rwy_Vis_Range_FT;
   end Rwy_Vis_Range_FT;

   procedure Set_Rwy_Vis_Range_FT
     (An_Instance : in out Instance;
      Rvr_Selected : in Integer) is
   begin
      if Rvr_Selected > 65535 then
         An_Instance.Rwy_Vis_Range_Ft := 65535;
      elsif Rvr_Selected < 0 then
         An_Instance.Rwy_Vis_Range_Ft := 1;
      else
         An_Instance.Rwy_Vis_Range_Ft := Rvr_Selected;
      end if;
      An_Instance.Rwy_Vis_Range_M :=
        Integer(Float(An_Instance.Rwy_Vis_Range_Ft) * 0.3048);
   end Set_Rwy_Vis_Range_FT;

-- Access Rwy_Vis_Range_M
   function  Rwy_Vis_Range_M
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Rwy_Vis_Range_M;
   end Rwy_Vis_Range_M;

   procedure Set_Rwy_Vis_Range_M
     (An_Instance : in out Instance;
      Rvr_Selected : in Integer) is
   begin
      if Rvr_Selected > 19975 then
         An_Instance.Rwy_Vis_Range_M := 19975;
      elsif Rvr_Selected < 0 then
         An_Instance.Rwy_Vis_Range_M := 0;
      else
         An_Instance.Rwy_Vis_Range_M := Rvr_Selected;
      end if;
      An_Instance.Rwy_Vis_Range_Ft :=
        Integer(Float(An_Instance.Rwy_Vis_Range_M) * 3.2808);
   end Set_Rwy_Vis_Range_M;

-- Method Calculate_Visibility
   procedure Calculate_Visibility
     (An_Instance : in out Instance;
      Precipitation_Type : in Integer;
      Precipitation_Level : in Integer) is
   begin
      if Precipitation_Type /= 0 and
        Precipitation_Type_N1 = 0 then
         Old_Visibility := An_Instance.Visibility_Nm;
      end if;

      if Precipitation_Type = 1 or Precipitation_Type = 3 then
         if Precipitation_Level = 1 then
            An_Instance.Visibility_Nm := 7.57;
         elsif Precipitation_Level = 2 then
            An_Instance.Visibility_Nm := 1.894;
         elsif Precipitation_Level = 3 then
            An_Instance.Visibility_Nm := 0.682;
         else
            An_Instance.Visibility_Nm := 7.57;
         end if;
      elsif Precipitation_Type = 2 then
         if Precipitation_Level = 1 then
            An_Instance.Visibility_Nm := 1.646;
         elsif Precipitation_Level = 2 then
            An_Instance.Visibility_Nm := 0.263;
         elsif Precipitation_Level = 3 then
            An_Instance.Visibility_Nm := 0.165;
         else
            An_Instance.Visibility_Nm := 1.646;
         end if;
      elsif Precipitation_Type_N1 /= 0 then
         An_Instance.Visibility_Nm := Old_Visibility;
      end if;

      Precipitation_Type_N1 := Precipitation_Type;

      An_Instance.Visibility_Km := An_Instance.Visibility_Nm * 1.609;
   end Calculate_Visibility;

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Visibility_Nm := 500.0;
      An_Instance.Visibility_Km := 804.5;
      An_Instance.Rwy_Vis_Range_Ft := 0;
      An_Instance.Rwy_Vis_Range_M := 0;
   end Initialize;


end Visibility;



