-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;
with Lightning;
with Cloud_Layer;

package Vis_Precipitation is


  type Instance is private;

-- Access Rain_Enable
   function  Rain_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_Rain_Enable
     (An_Instance : in out Instance;
      Rain_On : in Boolean);

-- Access Hail_Enable
   function  Hail_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_Hail_Enable
     (An_Instance : in out Instance;
      Hail_On : in Boolean);

-- Access Falling_Snow
   function  Falling_Snow (An_Instance : in Instance) return Boolean;
   procedure Set_Falling_Snow
     (An_Instance : in out Instance;
      Falling_Snow_On : in Boolean);

-- Access Precipitation_Level
   function  Precipitation_Level (An_Instance : in Instance) return Integer;
   procedure Set_Precipitation_Level
     (An_Instance : in out Instance;
      Precipitation_Level_Selected : in Integer);

-- Access Precipitation_Type
   function  Precipitation_Type (An_Instance : in Instance) return Integer;
   procedure Set_Precipitation_Type
     (An_Instance : in out Instance;
      Precipitation_Type_Selected : in Integer);

-- Access In_Moisture
   function  In_Moisture (An_Instance : in Instance) return Boolean;
   procedure Set_In_Moisture
     (An_Instance : in out Instance;
      In_Moisture_True : in Boolean);

-- Lightning Access Methods
   function Enabled (An_Instance : in Instance) return Boolean;
   function Visible (An_Instance : in Instance) return Boolean;
   function Intensity (An_Instance : in Instance) return Integer;
   function Direction (An_Instance : in Instance) return Float;
   function Distance (An_Instance : in Instance) return Float;
   function Thunder (An_Instance : in Instance) return Boolean;

   procedure Set_Enabled
     (An_Instance : in out Instance;
      Selected_Enable : in Boolean);
   procedure Set_Visible
     (An_Instance : in out Instance;
      Lightning_Visible : in Boolean);
   procedure Set_Intensity
     (An_Instance : in out Instance;
      Intensity_Selected : in Integer);
   procedure Set_Direction
     (An_Instance : in out Instance;
      Direction_Selected : in Float);
   procedure Set_Distance
     (An_Instance : in out Instance;
      Distance_Selected : in Float);
   procedure Set_Thunder
     (An_Instance : in out Instance;
      Thunder_On : in Boolean);

   procedure Calculate_Lightning_Direction
     (An_Instance : in out Instance;
      Lightning_Id : in Integer;
      Ac_Latitude : in Long_Float;
      Ac_Longitude : in Long_Float;
      Ac_Heading : in Float;
      Lightning_Latitude : in Long_Float;
      Lightning_Longitude : in Long_Float;
      Integration_Constant : in Float);

-- Method Determine_Precip_Type
   procedure Determine_Precip_Type (An_Instance : in out Instance);

-- Method Determine_Moisture
   procedure Determine_Moisture
     (An_Instance : in out Instance;
      Cloud_Layer_1 : in Cloud_Layer.Instance;
      Cloud_Layer_2 : in Cloud_Layer.Instance;
      Fog_Top : in Integer;
      Ac_Altitude : in Integer;
      Airport_Altitude : in Integer);

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance);


private

  type Instance is record
    Rain_Enable : Boolean;
    Hail_Enable : Boolean;
    Falling_Snow : Boolean;
    Precipitation_Level : Integer;
    Precipitation_Type : Integer;
    In_Moisture : Boolean;
    The_Lightning : Lightning.Instance;
  end record;


end Vis_Precipitation;
