-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Vis_Precipitation is


-- Access Rain_Enable
   function  Rain_Enable
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Rain_Enable;
   end Rain_Enable;

   procedure Set_Rain_Enable
     (An_Instance : in out Instance;
      Rain_On : in Boolean) is
   begin
      An_Instance.Rain_Enable := Rain_On;
   end Set_Rain_Enable;

-- Access Hail_Enable
   function  Hail_Enable
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Hail_Enable;
   end Hail_Enable;

   procedure Set_Hail_Enable
     (An_Instance : in out Instance;
      Hail_On : in Boolean) is
   begin
      An_Instance.Hail_Enable := Hail_On;
   end Set_Hail_Enable;

-- Access Falling_Snow
   function  Falling_Snow
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Falling_Snow;
   end Falling_Snow;

   procedure Set_Falling_Snow
     (An_Instance : in out Instance;
      Falling_Snow_On : in Boolean) is
   begin
      An_Instance.Falling_Snow := Falling_Snow_On;
   end Set_Falling_Snow;

-- Access Precipitation_Level
   function  Precipitation_Level
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Precipitation_Level;
   end Precipitation_Level;

   procedure Set_Precipitation_Level
     (An_Instance : in out Instance;
      Precipitation_Level_Selected : in Integer) is
   begin
      An_Instance.Precipitation_Level := Precipitation_Level_Selected;
   end Set_Precipitation_Level;

-- Access Precipitation_Type
   function  Precipitation_Type
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Precipitation_Type;
   end Precipitation_Type;

   procedure Set_Precipitation_Type
     (An_Instance : in out Instance;
      Precipitation_Type_Selected : in Integer) is
   begin
      An_Instance.Precipitation_Type := Precipitation_Type_Selected;
   end Set_Precipitation_Type;

-- Access In_Moisture
   function  In_Moisture
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.In_Moisture;
   end In_Moisture;

   procedure Set_In_Moisture
     (An_Instance : in out Instance;
      In_Moisture_True : in Boolean) is
   begin
      An_Instance.In_Moisture := In_Moisture_True;
   end Set_In_Moisture;

-- Method Determine_Precip_Type
   procedure Determine_Precip_Type
     (An_Instance : in out Instance) is
   begin
      if An_Instance.Rain_Enable then
         An_Instance.Precipitation_Type := 1;
      elsif An_Instance.Falling_Snow then
         An_Instance.Precipitation_Type := 2;
      elsif An_Instance.Hail_Enable then
         An_Instance.Precipitation_Type := 3;
      else
         An_Instance.Precipitation_Type := 0;
      end if;
   end Determine_Precip_Type;

-- Method Determine_Moisture
   procedure Determine_Moisture
     (An_Instance : in out Instance;
      Cloud_Layer_1 : in Cloud_Layer.Instance;
      Cloud_Layer_2 : in Cloud_Layer.Instance;
      Fog_Top : in Integer;
      Ac_Altitude : in Integer;
      Airport_Altitude : in Integer) is
      Cloud_Top_1 : Integer;
      Cloud_Ceiling_1 :Integer;
      Cloud_Top_2 : Integer;
      Cloud_Ceiling_2 : Integer;
      Layer_1_Overcast : Boolean;
      Layer_2_Overcast : Boolean;
   begin
      Cloud_Ceiling_1 := Cloud_Layer.Ceiling(Cloud_Layer_1) + Airport_Altitude;
      Cloud_Top_1 := Cloud_Layer.Top(Cloud_Layer_1);
      Cloud_Ceiling_2 := Cloud_Layer.Ceiling(Cloud_Layer_2);
      Cloud_Top_2 := Cloud_Layer.Top(Cloud_Layer_2);
      Layer_1_Overcast := Cloud_Layer.Overcast(Cloud_Layer_1);
      Layer_2_Overcast := Cloud_Layer.Overcast(Cloud_Layer_2);
      if An_Instance.Rain_Enable then
         if ((Cloud_Top_2  > 0) and Layer_2_Overcast) then
            An_Instance.In_Moisture := Ac_Altitude < Cloud_Top_2;
         else
            An_Instance.In_Moisture := Ac_Altitude < Cloud_Top_1;
         end if;
      else
         An_Instance.In_Moisture :=
           ((Ac_Altitude > Cloud_Ceiling_1) and
            (Ac_Altitude < Cloud_Top_1) and
            Layer_1_Overcast) or
           ((Ac_Altitude > Cloud_Ceiling_2) and
            (Ac_Altitude < Cloud_Top_2) and
            Layer_2_Overcast) or
           (Ac_Altitude < Fog_Top + Airport_Altitude);
      end if;
   end Determine_Moisture;

-- Lightning Functions
   function Enabled
     (An_Instance : in Instance)
      return Boolean is
   begin
      return Lightning.Enabled(An_Instance.The_Lightning);
   end Enabled;

   function Visible
     (An_Instance : in Instance)
      return Boolean is
   begin
      return Lightning.Visible(An_Instance.The_Lightning);
   end Visible;

   function Intensity
     (An_Instance : in Instance)
      return Integer is
   begin
      return Lightning.Intensity(An_Instance.The_Lightning);
   end Intensity;

   function Direction
     (An_Instance : in Instance)
      return Float is
   begin
      return Lightning.Direction(An_Instance.The_Lightning);
   end Direction;

   function Distance
     (An_Instance : in Instance)
      return Float is
   begin
      return Lightning.Distance(An_Instance.The_Lightning);
   end Distance;

   function Thunder
     (An_Instance : in Instance)
      return Boolean is
   begin
      return Lightning.Thunder(An_Instance.The_Lightning);
   end Thunder;

   procedure Set_Enabled
     (An_Instance : in out Instance;
      Selected_Enable : in Boolean) is
   begin
      Lightning.Set_Enabled(An_Instance.The_Lightning, Selected_Enable);
   end Set_Enabled;

   procedure Set_Visible
     (An_Instance : in out Instance;
      Lightning_Visible : in Boolean) is
   begin
      Lightning.Set_Visible(An_Instance.The_Lightning, Lightning_Visible);
   end Set_Visible;

   procedure Set_Intensity
     (An_Instance : in out Instance;
      Intensity_Selected : in Integer) is
   begin
      Lightning.Set_Intensity(An_Instance.The_Lightning, Intensity_Selected);
   end Set_Intensity;

   procedure Set_Direction
     (An_Instance : in out Instance;
      Direction_Selected : in Float) is
   begin
      Lightning.Set_Direction(An_Instance.The_Lightning, Direction_Selected);
   end Set_Direction;

   procedure Set_Distance
     (An_Instance : in out Instance;
      Distance_Selected : in Float) is
   begin
      Lightning.Set_Distance(An_Instance.The_Lightning, Distance_Selected);
   end Set_Distance;

   procedure Set_Thunder
     (An_Instance : in out Instance;
      Thunder_On : in Boolean) is
   begin
      Lightning.Set_Thunder(An_Instance.The_Lightning, Thunder_On);
   end Set_Thunder;

   procedure Calculate_Lightning_Direction
     (An_Instance : in out Instance;
      Lightning_Id : in Integer;
      Ac_Latitude : in Long_Float;
      Ac_Longitude : in Long_Float;
      Ac_Heading : in Float;
      Lightning_Latitude : in Long_Float;
      Lightning_Longitude : in Long_Float;
      Integration_Constant : in Float) is
   begin
      Lightning.Calculate_Lightning_Direction
        (An_Instance.The_Lightning,
         Lightning_Id,
         Ac_Latitude, Ac_Longitude, Ac_Heading,
         Lightning_Latitude, Lightning_Longitude,
         Integration_Constant);
   end Calculate_Lightning_Direction;

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Rain_Enable := False;
      An_Instance.Hail_Enable := False;
      An_Instance.Falling_Snow := False;
      An_Instance.Precipitation_Level := 1;
      An_Instance.Precipitation_Type := 0;
      An_Instance.In_Moisture := False;
      Lightning.Initialize(An_Instance.The_Lightning);
   end Initialize;


end Vis_Precipitation;
