-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;

package Vis_Environment is


  type Instance is private;

-- Access Temperature_Deg_F
   function  Temperature_Deg_F (An_Instance : in Instance) return Float;
   procedure Set_Temperature_Deg_F
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float);

-- Access Temperature_Deg_C
   function  Temperature_Deg_C (An_Instance : in Instance) return Float;
   procedure Set_Temperature_Deg_C
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float);

-- Access Dewpoint_F
   function  Dewpoint_F (An_Instance : in Instance) return Float;
   procedure Set_Dewpoint_F
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float);

-- Access Dewpoint_C
   function  Dewpoint_C (An_Instance : in Instance) return Float;
   procedure Set_Dewpoint_C
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float);

-- Access Wind_Speed
   function  Wind_Speed (An_Instance : in Instance) return Float;
   procedure Set_Wind_Speed
     (An_Instance : in out Instance;
      Wind_Speed_Selected : in Float);

-- Access Wind_Direction
   function  Wind_Direction (An_Instance : in Instance) return Float;
   procedure Set_Wind_Direction
     (An_Instance : in out Instance;
      Wind_Direction_Selected : in Float);

-- Access Field_Pressure_HG
   function  Field_Pressure_Hg (An_Instance : in Instance) return Float;
   procedure Set_Field_Pressure_Hg
     (An_Instance : in out Instance;
      Field_Pressure_Selected : in Float);

-- Access Field_Pressure_MB
   function  Field_Pressure_Mb (An_Instance : in Instance) return Float;
   procedure Set_Field_Pressure_Mb
     (An_Instance : in out Instance;
      Field_Pressure_Selected : in Float);

-- Access Sea_Level_Pressure_Hg
   function  Sea_Level_Pressure_Hg (An_Instance : in Instance) return Float;
   procedure Set_Sea_Level_Pressure_Hg
     (An_Instance : in out Instance;
      Sea_Level_Pressure_Selected : in Float);

-- Access Sea_Level_Pressure_Mb
   function  Sea_Level_Pressure_Mb (An_Instance : in Instance) return Float;
   procedure Set_Sea_Level_Pressure_Mb
     (An_Instance : in out Instance;
      Sea_Level_Pressure_Selected : in Float);


private

  type Instance is record
    Temperature_Deg_F : Float;
    Temperature_Deg_C : Float;
    Dewpoint_F : Float;
    Dewpoint_C : Float;
    Wind_Speed : Float;
    Wind_Direction : Float;
    Field_Pressure_Hg : Float;
    Field_Pressure_Mb : Float;
    Sea_Level_Pressure_Hg : Float;
    Sea_Level_Pressure_Mb : Float;
  end record;


end Vis_Environment;
