-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Vis_Environment is


-- Access Temperature_Deg_F
   function  Temperature_Deg_F
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Temperature_Deg_F;
   end Temperature_Deg_F;

   procedure Set_Temperature_Deg_F
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float) is
   begin
      An_Instance.Temperature_Deg_F := Demanded_Temperature;
      An_Instance.Temperature_Deg_C :=
        5.0 / 9.0 *(Demanded_Temperature - 32.0);
      An_Instance.Dewpoint_F := Demanded_Temperature - 5.0;
      An_Instance.Dewpoint_C :=
        5.0 / 9.0 * (An_Instance.Dewpoint_F - 32.0);
   end Set_Temperature_Deg_F;

-- Access Temperature_Deg_C
   function  Temperature_Deg_C
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Temperature_Deg_C;
   end Temperature_Deg_C;

   procedure Set_Temperature_Deg_C
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float) is
   begin
      An_Instance.Temperature_Deg_C := Demanded_Temperature;
      An_Instance.Temperature_Deg_F :=
        9.0 / 5.0 * Demanded_Temperature + 32.0;
      An_Instance.Dewpoint_C := Demanded_Temperature - 5.0;
      An_Instance.Dewpoint_F :=
        9.0 / 5.0 * An_Instance.Dewpoint_C + 32.0;
   end Set_Temperature_Deg_C;

-- Access Dewpoint_F
   function  Dewpoint_F
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Dewpoint_F;
   end Dewpoint_F;

   procedure Set_Dewpoint_F
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float) is
   begin
      An_Instance.Dewpoint_F := Demanded_Temperature;
      An_Instance.Dewpoint_C :=
        5.0 / 9.0 * (Demanded_Temperature - 32.0);
   end Set_Dewpoint_F;

-- Access Dewpoint_C
   function  Dewpoint_C
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Dewpoint_C;
   end Dewpoint_C;

   procedure Set_Dewpoint_C
     (An_Instance : in out Instance;
      Demanded_Temperature : in Float) is
   begin
      An_Instance.Dewpoint_C := Demanded_Temperature;
      An_Instance.Dewpoint_F :=
        9.0 / 5.0 * Demanded_Temperature + 32.0;
   end Set_Dewpoint_C;

-- Access Wind_Speed
   function  Wind_Speed
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Wind_Speed;
   end Wind_Speed;

   procedure Set_Wind_Speed
     (An_Instance : in out Instance;
      Wind_Speed_Selected : in Float) is
   begin
      An_Instance.Wind_Speed := Wind_Speed_Selected;
   end Set_Wind_Speed;

-- Access Wind_Direction
   function  Wind_Direction
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Wind_Direction;
   end Wind_Direction;

   procedure Set_Wind_Direction
     (An_Instance : in out Instance;
      Wind_Direction_Selected : in Float) is
   begin
      An_Instance.Wind_Direction := Wind_Direction_Selected;
   end Set_Wind_Direction;

-- Access Field_Pressure_Hg
   function  Field_Pressure_Hg
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Field_Pressure_Hg;
   end Field_Pressure_Hg;

   procedure Set_Field_Pressure_Hg
     (An_Instance : in out Instance;
      Field_Pressure_Selected : in Float) is
   begin
      An_Instance.Field_Pressure_Hg := Field_Pressure_Selected;
      An_Instance.Field_Pressure_Mb :=
        Field_Pressure_Selected * 33.8642 + 0.01;
   end Set_Field_Pressure_Hg;

-- Access Field_Pressure_Mb
   function  Field_Pressure_Mb
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Field_Pressure_Mb;
   end Field_Pressure_Mb;

   procedure Set_Field_Pressure_Mb
     (An_Instance : in out Instance;
      Field_Pressure_Selected : in Float) is
   begin
      An_Instance.Field_Pressure_Mb := Field_Pressure_Selected;
      An_Instance.Field_Pressure_Hg :=
        (Field_Pressure_Selected - 0.01) / 33.8642;
   end Set_Field_Pressure_Mb;

-- Access Sea_Level_Pressure_Hg
   function  Sea_Level_Pressure_Hg
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Sea_Level_Pressure_Hg;
   end Sea_Level_Pressure_Hg;

   procedure Set_Sea_Level_Pressure_Hg
     (An_Instance : in out Instance;
      Sea_Level_Pressure_Selected : in Float) is
   begin
      An_Instance.Sea_Level_Pressure_Hg := Sea_Level_Pressure_Selected;
      An_Instance.Sea_Level_Pressure_Mb :=
        Sea_Level_Pressure_Selected * 33.8642 + 0.01;
   end Set_Sea_Level_Pressure_Hg;

-- Access Sea_Level_Pressure_Mb
   function  Sea_Level_Pressure_Mb
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Sea_Level_Pressure_Mb;
   end Sea_Level_Pressure_Mb;

   procedure Set_Sea_Level_Pressure_Mb
     (An_Instance : in out Instance;
      Sea_Level_Pressure_Selected : in Float) is
   begin
      An_Instance.Sea_Level_Pressure_Mb := Sea_Level_Pressure_Selected;
      An_Instance.Sea_Level_Pressure_Hg :=
        (Sea_Level_Pressure_Selected - 0.01) /  33.8642;
   end Set_Sea_Level_Pressure_Mb;


end Vis_Environment;
