-------------------------------------------------------------------------------
--
--           
--                    
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;
with Lat_Long_Types;

package Storms is


  type Instance is private;

-- Access Storm 1
   function  Storm_1
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 1
   procedure Set_Storm_1
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 2
   function  Storm_2
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 2
   procedure Set_Storm_2
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 3
   function  Storm_3
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 3
   procedure Set_Storm_3
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 4
   function  Storm_4
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 4
   procedure Set_Storm_4
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 5
   function  Storm_5
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 5
   procedure Set_Storm_5
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 6
   function  Storm_6
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 6
   procedure Set_Storm_6
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 7
   function  Storm_7
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 7
   procedure Set_Storm_7
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 8
   function  Storm_8
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 8
   procedure Set_Storm_8
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 9
   function  Storm_9
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 9
   procedure Set_Storm_9
     (An_Instance : in out Instance;
      On : in Boolean);
-- Access Storm 10
   function  Storm_10
     (An_Instance : in Instance)
      return Boolean;
-- Mutate Storm 10
   procedure Set_Storm_10
     (An_Instance : in out Instance;
      On : in Boolean);

-- Mutate Storm Ceiling
   procedure Set_Storm_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Jpats_Visual_Weather_Types.Storm_Ceiling_Type);
-- Access Storm ceiling
   function Storm_Ceiling
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Ceiling_Type;

   -- Mutate storm top
   procedure Set_Storm_Top
     (An_Instance : in out Instance;
      An_Top : in Jpats_Visual_Weather_Types.Storm_Top_Type);
   -- Access Storm Top
   function Storm_Top
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Top_Type;

   -- Mutate Storm Direction
   procedure Set_Storm_Direction
     (An_Instance : in out Instance;
      An_Direction : Jpats_Visual_Weather_Types.Storm_Direction_Type);
   -- Access Storm Direction
   function Storm_Direction
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Direction_Type;

   -- Mutate Storm Speed
   procedure Set_Storm_Speed
     (An_Instance : in out Instance;
      An_Speed : in Jpats_Visual_Weather_Types.Storm_Speed_Type);
   -- Access Storm Speed
   function Storm_Speed
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Speed_Type;

   -- Mutate Storm Rotation
   procedure Set_Storm_Rotation
     (An_Instance : in out Instance;
      An_Rotation : in Jpats_Visual_Weather_Types.Storm_Rotation_Type);
   -- Access Storm Rotation
   function Storm_Rotation
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Rotation_Type;

   -- Mutate Storm Name
   procedure Set_Storm_Name
     (An_Instance : in out Instance;
      An_Name : in Jpats_Visual_Weather_Types.Storm_Name_Type);
   -- Access Storm Name
   function Storm_Name
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Name_Type;

    -- Mutate Storm Length
   procedure Set_Storm_Length
     (An_Instance : in out Instance;
      An_Length : in Jpats_Visual_Weather_Types.Storm_Length_Type);
   -- Access Storm Length
   function Storm_Length
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Length_Type;

   -- Mutate Storm Width
   procedure Set_Storm_Width
     (An_Instance : in out Instance;
      An_Width : in Jpats_Visual_Weather_Types.Storm_Width_Type);
   -- Access Storm Width
   function Storm_Width
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Width_Type;

    -- Mutate Storm height
   procedure Set_Storm_Height
     (An_Instance : in out Instance;
      An_Height : in Jpats_Visual_Weather_Types.Storm_Height_Type);
   -- Access Storm Height
   function Storm_Height
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Height_Type;

   -- Mutate Storm Lightning Frequency
   procedure Set_Storm_Lightning_Frequency
     (An_Instance : in out Instance;
      An_Frequency : in Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type);
   -- Access Storm Lightning Frequency
   function Storm_Lightning_Frequency
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type;

   -- Mutate Storm Location
   procedure Set_Storm_Location
     (An_Instance : in out Instance;
      An_Latitude : in Lat_Long_Types.Latitude_Degrees;
      An_Longitude : in Lat_Long_Types.Longitude_Degrees);
   -- Access Storm Location
   function Storm_Location
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Location_Type;


function Storm_Active
     (An_Instance : in Instance) return Boolean;

function Storm_Lightning_Active
     (An_Instance : in Instance) return Boolean;

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance);

   procedure Update
     (An_Instance : in out Instance;
      Iconst : in Float);

private

   type Instance is record
      Storm_1   : Boolean;
      Storm_2   : Boolean;
      Storm_3   : Boolean;
      Storm_4   : Boolean;
      Storm_5   : Boolean;
      Storm_6   : Boolean;
      Storm_7   : Boolean;
      Storm_8   : Boolean;
      Storm_9   : Boolean;
      Storm_10  : Boolean;
      Storm_Ceiling   : Jpats_Visual_Weather_Types.Storm_Ceiling_Type;
      Storm_Top : Jpats_Visual_Weather_Types.Storm_Top_Type;
      Storm_Direction : Jpats_Visual_Weather_Types.Storm_Direction_Type;
      Storm_Speed     : Jpats_Visual_Weather_Types.Storm_Speed_Type;
      Storm_Rotation  : Jpats_Visual_Weather_Types.Storm_Rotation_Type;
      Storm_Name      : Jpats_Visual_Weather_Types.Storm_Name_Type;
      Storm_Length    : Jpats_Visual_Weather_Types.Storm_Length_Type;
      Storm_Width     : Jpats_Visual_Weather_Types.Storm_Width_Type;
      Storm_Height    : Jpats_Visual_Weather_Types.Storm_Height_Type;
      Storm_Location  : Jpats_Visual_Weather_Types.Storm_Location_Type;
      Storm_Lightning_Frequency : Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type;
      Active    : Boolean;
  end record;


end Storms;
