-------------------------------------------------------------------------------
--
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Visual_Weather_Types;
with ada.Numerics.Elementary_Functions;
use ada.Numerics.Elementary_Functions;
--with Log; use Log;

package body Storms is

   Ft_Per_Deg : constant := 6076.1 * 60.0;
   Kts_To_Fps : constant := 1.0/0.59249;

-- Get Storm_1
   function  Storm_1
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_1;
   end Storm_1;

-- Set Storm_1
   procedure Set_Storm_1
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_1 := On;
      if (On) then
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 255152;
         An_Instance.Storm_Width := 292335;
         An_Instance.Storm_Height := 10981;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "01";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_1;

-- Get Storm_2
   function  Storm_2
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_2;
   end Storm_2;

-- Set Storm_2
   procedure Set_Storm_2
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_2 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 521502;
         An_Instance.Storm_Width := 277807;
         An_Instance.Storm_Height := 13663;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "02";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_2;

-- Get Storm_3
   function  Storm_3
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_3;
   end Storm_3;

-- Set Storm_3
   procedure Set_Storm_3
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_3 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 178732;
         An_Instance.Storm_Width := 149229;
         An_Instance.Storm_Height := 15485;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "03";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_3;

-- Get Storm_4
   function  Storm_4
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_4;
   end Storm_4;

-- Set Storm_4
   procedure Set_Storm_4
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_4 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 345154;
         An_Instance.Storm_Width := 356528;
         An_Instance.Storm_Height := 18218;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "04";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_4;

-- Get Storm_5
   function  Storm_5
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_5;
   end Storm_5;

-- Set Storm_5
   procedure Set_Storm_5
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_5 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 265551;
         An_Instance.Storm_Width := 335694;
         An_Instance.Storm_Height := 22266;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "05";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_5;

-- Get Storm_6
   function  Storm_6
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_6;
   end Storm_6;

-- Set Storm_6
   procedure Set_Storm_6
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_6 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 409790;
         An_Instance.Storm_Width := 264374;
         An_Instance.Storm_Height := 25050;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "06";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_6;

-- Get Storm_7
   function  Storm_7
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_7;
   end Storm_7;

-- Set Storm_7
   procedure Set_Storm_7
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_7 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 152745;
         An_Instance.Storm_Width := 162453;
         An_Instance.Storm_Height := 30743;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "07";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_7;

-- Get Storm_8
   function  Storm_8
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_8;
   end Storm_8;

-- Set Storm_8
   procedure Set_Storm_8
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_8 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 278016;
         An_Instance.Storm_Width := 262958;
         An_Instance.Storm_Height := 45456;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "08";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_8;

-- Get Storm_9
   function  Storm_9
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_9;
   end Storm_9;

-- Set Storm_9
   procedure Set_Storm_9
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_9 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_10 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 352061;
         An_Instance.Storm_Width := 339840;
         An_Instance.Storm_Height := 45546;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "09";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_9;

-- Get Storm_10
   function  Storm_10
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_10;
   end Storm_10;

-- Set Storm_10
   procedure Set_Storm_10
     (An_Instance : in out Instance;
      On : in Boolean) is
   begin
      An_Instance.Storm_10 := On;
      if (On) then
         An_Instance.Storm_1 := False;
         An_Instance.Storm_2 := False;
         An_Instance.Storm_3 := False;
         An_Instance.Storm_4 := False;
         An_Instance.Storm_5 := False;
         An_Instance.Storm_6 := False;
         An_Instance.Storm_7 := False;
         An_Instance.Storm_8 := False;
         An_Instance.Storm_9 := False;
         An_Instance.Storm_Ceiling := 2000;
         An_Instance.Storm_Length := 214376;
         An_Instance.Storm_Width := 267132;
         An_Instance.Storm_Height := 45602;
         An_Instance.Storm_Direction := 120;
         An_Instance.Storm_Rotation := 0;
         An_Instance.Storm_Speed := 20;
         An_Instance.Storm_Lightning_Frequency := 5;
         An_Instance.Storm_Top := An_Instance.Storm_Ceiling + An_Instance.Storm_Height;
         An_Instance.Storm_Name := "10";
         An_Instance.Active := True;
       else
         An_Instance.Active := False;
       end if;
   end Set_Storm_10;

   procedure Set_Storm_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Jpats_Visual_Weather_Types.Storm_Ceiling_Type) is
   begin
      An_Instance.Storm_Ceiling := An_Altitude;
      An_Instance.Storm_Top := An_Altitude + An_Instance.Storm_Height;
   end Set_Storm_Ceiling;

   function Storm_Ceiling
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Ceiling_Type is
   begin
      return An_Instance.Storm_Ceiling;
   end Storm_Ceiling;

   procedure Set_Storm_Top
     (An_Instance : in out Instance;
      An_Top : in Jpats_Visual_Weather_Types.Storm_Top_Type) is
   begin
      An_Instance.Storm_Top := An_Top;
   end Set_Storm_Top;

   function Storm_Top
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Top_Type is
   begin
      return An_Instance.Storm_Top;
   end Storm_Top;

   function  Storm_Active
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Active;
   end Storm_Active;

   function  Storm_Lightning_Active
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Storm_Lightning_Frequency > 1;
   end Storm_Lightning_Active;

   procedure Set_Active
     (An_Instance : in out Instance;
      Is_Active : in Boolean) is
   begin
      An_Instance.Active := Is_Active;
   end Set_Active;

   procedure Set_Storm_Direction
     (An_Instance : in out Instance;
      An_Direction : in Jpats_Visual_Weather_Types.Storm_Direction_Type) is
   begin
      An_Instance.Storm_Direction := An_Direction;
   end Set_Storm_Direction;

   function Storm_Direction
     (An_Instance : in Instance) 
     return Jpats_Visual_Weather_Types.Storm_Direction_Type is
   begin
     return An_Instance.Storm_Direction;
   end Storm_Direction;

   procedure Set_Storm_Speed
     (An_Instance : in out Instance;
      An_Speed : in Jpats_Visual_Weather_Types.Storm_Speed_Type) is
   begin
      An_Instance.Storm_Speed := An_Speed;
   end Set_Storm_Speed;

   function Storm_Speed
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Speed_Type is
   begin
      return An_Instance.Storm_Speed;
   end Storm_Speed;

   procedure Set_Storm_Rotation
     (An_Instance : in out Instance;
      An_Rotation : in Jpats_Visual_Weather_Types.Storm_Rotation_Type) is
   begin
      An_Instance.Storm_Rotation := An_Rotation;
   end Set_Storm_Rotation;

   function Storm_Rotation
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Rotation_Type is
   begin
      return An_Instance.Storm_Rotation;
   end Storm_Rotation;

   procedure Set_Storm_Name
     (An_Instance : in out Instance;
      An_Name : in Jpats_Visual_Weather_Types.Storm_Name_Type) is
   begin
      An_Instance.Storm_Name := An_Name;
   end Set_Storm_Name;

   function Storm_Name
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Name_Type is
   begin
      return An_Instance.Storm_Name;
   end Storm_Name;

   procedure Set_Storm_Length
     (An_Instance : in out Instance;
      An_Length : in Jpats_Visual_Weather_Types.Storm_Length_Type) is
   begin
      An_Instance.Storm_Length := An_Length;
   end Set_Storm_Length;

   function Storm_Length
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Length_Type is
   begin
      return An_Instance.Storm_Length;
   end Storm_Length;

   procedure Set_Storm_Width
     (An_Instance : in out Instance;
      An_Width : in Jpats_Visual_Weather_Types.Storm_Width_Type) is
   begin
      An_Instance.Storm_Width := An_Width;
   end Set_Storm_Width;

   function Storm_Width
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Width_Type is
   begin
      return An_Instance.Storm_Width;
   end Storm_Width;

   procedure Set_Storm_Height
     (An_Instance : in out Instance;
      An_Height : in Jpats_Visual_Weather_Types.Storm_Height_Type) is
   begin
      An_Instance.Storm_Height := An_Height;
   end Set_Storm_Height;

   function Storm_Height
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Height_Type is
   begin
      return An_Instance.Storm_Height;
   end Storm_Height;

   procedure Set_Storm_Lightning_Frequency
     (An_Instance : in out Instance;
      An_Frequency : in Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type) is
   begin
      An_Instance.Storm_Lightning_Frequency := An_Frequency;
   end Set_Storm_Lightning_Frequency;

   function Storm_Lightning_Frequency
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type is
   begin
      return An_Instance.Storm_Lightning_Frequency;
   end Storm_Lightning_Frequency;

   procedure Set_Storm_Location
     (An_Instance : in out Instance;
      An_Latitude : in Lat_Long_Types.Latitude_Degrees;
      An_Longitude : in Lat_Long_Types.Longitude_Degrees) is
   begin
      An_Instance.Storm_Location.Latitude := An_Latitude;
      An_Instance.Storm_Location.Longitude := An_Longitude;
   end Set_Storm_Location;

   function Storm_Location
     (An_Instance : in Instance)
     return Jpats_Visual_Weather_Types.Storm_Location_Type is
   begin
      return An_Instance.Storm_Location;
   end Storm_Location;

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Storm_1  := False;
      An_Instance.Storm_2  := False;
      An_Instance.Storm_3  := False;
      An_Instance.Storm_4  := False;
      An_Instance.Storm_5  := False;
      An_Instance.Storm_6  := False;
      An_Instance.Storm_7  := False;
      An_Instance.Storm_8  := False;
      An_Instance.Storm_9  := False;
      An_Instance.Storm_10 := False;
      An_Instance.Active   := False;
      An_Instance.Storm_Ceiling  := 0;
      An_Instance.Storm_Top := 0;
      An_Instance.Storm_Speed := 0;
      An_Instance.Storm_Direction := 0;
      An_Instance.Storm_Rotation := 0;
      An_Instance.Storm_Lightning_Frequency := 1;
      An_Instance.Storm_Name := "  ";
      An_Instance.Storm_Location.Latitude := 0.0;
      An_Instance.Storm_Location.Longitude := 0.0;
   end Initialize;

-- Update
   procedure Update
     (An_Instance : in out Instance;
      Iconst : in Float) is

   begin

      An_Instance.Storm_Location.Latitude :=
         An_Instance.Storm_Location.Latitude +
         Long_Float(Float(An_Instance.Storm_Speed * Kts_To_Fps)/Ft_Per_Deg*Iconst*
         Cos(Float(An_Instance.Storm_Direction),360.0));

      An_Instance.Storm_Location.Longitude :=
         An_Instance.Storm_Location.Longitude +
         Long_Float(Float(An_Instance.Storm_Speed * Kts_To_Fps)/Ft_Per_Deg*Iconst*
         Sin(Float(An_Instance.Storm_Direction),360.0) /
         Cos(Float(An_Instance.Storm_Location.Latitude),360.0));

   end Update;

end Storms;
