-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;

package Lightning is


  type Instance is private;

-- Access Enabled
   function  Enabled (An_Instance : in Instance) return Boolean;
   procedure Set_Enabled
     (An_Instance : in out Instance;
      Lightning_Selected : in Boolean);

-- Access Visible
   function  Visible (An_Instance : in Instance) return Boolean;
   procedure Set_Visible
     (An_Instance : in out Instance;
      Lightning_Visible : in Boolean);

-- Access Intensity
   function  Intensity (An_Instance : in Instance) return Integer;
   procedure Set_Intensity
     (An_Instance : in out Instance;
      Lightning_Intensity : in Integer);

-- Access Direction
   function  Direction (An_Instance : in Instance) return Float;
   procedure Set_Direction
     (An_Instance : in out Instance;
      Lightning_Direction : in Float);

-- Access Distance
   function Distance (An_Instance : in Instance) return Float;
   procedure Set_Distance
     (An_Instance : in out Instance;
      Lightning_Distance : in Float);

-- Access Thunder
   function Thunder (An_Instance : in Instance) return Boolean;
   procedure Set_Thunder
     (An_Instance : in out Instance;
      Thunder_On : in Boolean);

-- Method Calculate_Direction
   procedure Calculate_Lightning_Direction
     (An_Instance : in out Instance;
      Lightning_Id : in Integer;
      AC_Latitude : in Long_Float;
      AC_Longitude : in Long_Float;
      Ac_Heading : in Float;
      Lightning_Latitude : in Long_Float;
      Lightning_Longitude : in Long_Float;
      Integration_Constant : in Float);

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance);


private

  type Instance is record
    Enabled : Boolean;
    Visible : Boolean;
    Intensity : Integer;
    Direction : Float;
    Distance : Float;
    Thunder : Boolean;
  end record;


end Lightning;
