-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Jim F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Lat_Long_Types;

package JPATS_Visual_Weather_Types is

    subtype Storm_Ceiling_Type is Integer range 0..35000;
    subtype Storm_Location_Type is Lat_Long_Types.Position;
    subtype Storm_Direction_Type is Integer range 0..360;
    subtype Storm_Rotation_Type is Integer;
    subtype Storm_Speed_Type is Integer;
    subtype Storm_Length_Type is Integer;
    subtype Storm_Width_Type is Integer;
    subtype Storm_Height_Type is Integer;
    subtype Storm_Name_Type is String(1..2);
    subtype Storm_Lightning_Frequency_Type is Integer range 1..5;
    subtype Storm_Top_Type is Integer;
    subtype Cloud_Ceiling_Type is Integer range 0..35000;
    subtype Cloud_Top_Type is Integer range 0..40000;
    Max_Cloud_Top : constant := 39000;
    Max_Cloud_Ceiling : constant := 19900;
    Dawn : constant := 1;
    Day : constant := 2;
    Dusk : constant := 3;
    Night : constant := 4;
    No_Override : constant := 0;
    Cavu : constant := 1;
    Cati : constant := 2;
    Catii : constant := 3;
    Catiiia: constant := 4;
    Catiiib : constant := 5;
    Light_Precip : constant := 1;
    Med_Precip : constant := 2;
    Heavy_Precip : constant := 3;
    Rain_Precip : constant := 1;
    Snow_Precip : constant := 2;
    No_Precip : constant := 0;
end JPATS_Visual_Weather_Types;
