-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;

package JPATS_Visual_Weather is

-- General Weather Get Functions
   function Category_Level return Integer;
   function Radar_In_Control return Boolean;
   function Weather_Preset return Integer;
   function Ifr_Conditions return Boolean;
   function Clear_Weather return Boolean;
   function Bright_Day return Boolean;
   function Time_Of_Day return Integer;
   function Current_Time return Integer;
   function Ambient_Lighting return Float;
   function Winter_Scene return Boolean;

-- Visibility Get Functions
   function  Visibility_NM  return Float;
   function  Visibility_KM  return Float;
   function  Rwy_Vis_Range_FT  return Integer;
   function  Rwy_Vis_Range_M  return Integer;

-- Cloud Get Functions
   function  Lower_Cloud_Layer_Broken return Boolean;
   function  Lower_Cloud_Layer_Scattered return Boolean;
   function  Lower_Cloud_Layer_Overcast return Boolean;
   function  Upper_Cloud_Layer_Broken return Boolean;
   function  Upper_Cloud_Layer_Scattered return Boolean;
   function  Upper_Cloud_Layer_Overcast return Boolean;
   function  Cirrus_Clouds  return Boolean;
   function  Scud_Enabled return Boolean;
   function  Lower_Cloud_Layer_Active return Boolean;
   function  Lower_Cloud_Ceiling
     return  Jpats_Visual_Weather_Types.Cloud_Ceiling_Type;
   function  Lower_Cloud_Top return Jpats_Visual_Weather_Types.Cloud_Top_Type;
   function  Upper_Cloud_Layer_Active return Boolean;
   function  Upper_Cloud_Ceiling
     return  Jpats_Visual_Weather_Types.Cloud_Ceiling_Type;
   function  Upper_Cloud_Top return Jpats_Visual_Weather_Types.Cloud_Top_Type;

-- Storm Get Functions
   function  Storm_1 return Boolean;
   function  Storm_2 return Boolean;
   function  Storm_3 return Boolean;
   function  Storm_4 return Boolean;
   function  Storm_5 return Boolean;
   function  Storm_6 return Boolean;
   function  Storm_7 return Boolean;
   function  Storm_8 return Boolean;
   function  Storm_9 return Boolean;
   function  Storm_10 return Boolean;
   function  Storm_Active return Boolean;
   function  Storm_Lightning_Active return Boolean;
   function  Storm_Ceiling
     return  Jpats_Visual_Weather_Types.Storm_Ceiling_Type;
   function  Storm_Direction
     return  Jpats_Visual_Weather_Types.Storm_Direction_Type;
   function  Storm_Speed
     return  Jpats_Visual_Weather_Types.Storm_Speed_Type;
   function  Storm_Rotation
     return  Jpats_Visual_Weather_Types.Storm_Rotation_Type;
   function  Storm_Location
     return  Jpats_Visual_Weather_Types.Storm_Location_Type;
   function  Storm_Lightning_Frequency
     return  Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type;

-- Storm Update
   procedure Update_Storms(Iconst : in Float);

-- Celestial Get Functions
   function  Manual_Sun_Position_Enable return Boolean;
   function  Manual_Moon_Position_Enable return Boolean;
   function  Atmospheric_Illuminance return Integer;
   function  Sun_Elevation return Float;
   function  Sun_Azimuth return Float;
   function  Moon_Azimuth return Float;
   function  Moon_Elevation return Float;
   function  Moon_Phase return Integer;
   function  Star_Field return Integer;

-- Precipitation Get Functions
   function  Rain_Enable  return Boolean;
   function  Hail_Enable  return Boolean;
   function  Falling_Snow  return Boolean;
   function  Precipitation_Level  return Integer;
   function  Precipitation_Type  return Integer;
   function  In_Moisture  return Boolean;
   function  Lightning_Enabled  return Boolean;
   function  Lightning_Visible  return Boolean;
   function  Lightning_Intensity  return Integer;
   function  Lightning_Distance return Float;
   function  Lightning_Direction  return Float;
   function  Lightning_Thunder return Boolean;

-- Fog Get Functions
   function  Fog_Active  return Boolean;
   function  Fog_Top  return Integer;
   function  Patch_Fog  return Boolean;

end JPATS_Visual_Weather;
