-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Clouds;
with Celestial;
with Storms;
with Visibility;
with Vis_Precipitation;
--with Vis_Environment;
with Fog;
with Jpats_Visual_Weather.Container;

package body JPATS_Visual_Weather is

-- General Weather Get Functions
   function Category_Level
     return Integer is
   begin
      return Container.This_Subsystem.Category_Level;
   end Category_Level;

   function Radar_In_Control
     return Boolean is
   begin
      return Container.This_Subsystem.Radar_In_Control;
   end Radar_In_Control;

   function Weather_Preset
     return Integer is
   begin
      return Container.This_Subsystem.Weather_Preset;
   end Weather_Preset;

   function Ifr_Conditions
     return Boolean is
   begin
      return Container.This_Subsystem.Ifr_Conditions;
   end Ifr_Conditions;

   function Clear_Weather
     return Boolean is
   begin
      return Container.This_Subsystem.Clear_Weather;
   end Clear_Weather;

   function Bright_Day
     return Boolean is
   begin
      return Container.This_Subsystem.Bright_Day;
   end Bright_Day;

   function Time_Of_Day
     return Integer is
   begin
      return Container.This_Subsystem.Time_Of_Day;
   end Time_Of_Day;

   function Current_Time
     return Integer is
   begin
      return Container.This_Subsystem.Current_Time;
   end Current_Time;

   function Ambient_Lighting
     return Float is
   begin
      return Container.This_Subsystem.Ambient_Lighting;
   end Ambient_Lighting;

   function Winter_Scene
     return Boolean is
   begin
      return Container.This_Subsystem.Winter_Scene;
   end Winter_Scene;

-- Visibility Get Functions
   function  Visibility_NM  return Float is
   begin
      return Visibility.Visibility_Nm(Container.This_Subsystem.The_Visibility);
   end Visibility_Nm;

   function  Visibility_KM  return Float is
   begin
      return Visibility.Visibility_Km(Container.This_Subsystem.The_Visibility);
   end Visibility_Km;

   function  Rwy_Vis_Range_FT  return Integer is
   begin
      return Visibility.Rwy_Vis_Range_Ft
        (Container.This_Subsystem.The_Visibility);
   end Rwy_Vis_Range_Ft;

   function  Rwy_Vis_Range_M  return Integer is
   begin
      return Visibility.Rwy_Vis_Range_M
        (Container.This_Subsystem.The_Visibility);
   end Rwy_Vis_Range_M;

-- Cloud Get Functions
   function  Lower_Cloud_Layer_Broken  return Boolean is
   begin
      return Clouds.Lower_Layer_Broken
        (Container.This_Subsystem.The_Clouds);
   end Lower_Cloud_Layer_Broken;

   function  Lower_Cloud_Layer_Scattered  return Boolean is
   begin
      return Clouds.Lower_Layer_Scattered
        (Container.This_Subsystem.The_Clouds);
   end Lower_Cloud_Layer_Scattered;

   function  Lower_Cloud_Layer_Overcast  return Boolean is
   begin
      return Clouds.Lower_Layer_Overcast
        (Container.This_Subsystem.The_Clouds);
   end Lower_Cloud_Layer_Overcast;

   function  Upper_Cloud_Layer_Broken  return Boolean is
   begin
      return Clouds.Upper_Layer_Broken
        (Container.This_Subsystem.The_Clouds);
   end Upper_Cloud_Layer_Broken;

   function  Upper_Cloud_Layer_Scattered  return Boolean is
   begin
      return Clouds.Upper_Layer_Scattered
        (Container.This_Subsystem.The_Clouds);
   end Upper_Cloud_Layer_Scattered;

   function  Upper_Cloud_Layer_Overcast  return Boolean is
   begin
      return Clouds.Upper_Layer_Overcast
        (Container.This_Subsystem.The_Clouds);
   end Upper_Cloud_Layer_Overcast;

   function  Cirrus_Clouds  return Boolean is
   begin
      return Clouds.Cirrus_Clouds(Container.This_Subsystem.The_Clouds);
   end Cirrus_Clouds;

   function Scud_Enabled
     return Boolean is
   begin
      return Clouds.Scud_Enabled(Container.This_Subsystem.The_Clouds);
   end Scud_Enabled;

   function Lower_Cloud_Ceiling
     return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type is
   begin
      return Clouds.Lower_Layer_Ceiling(Container.This_Subsystem.The_Clouds);
   end Lower_Cloud_Ceiling;

   function Lower_Cloud_Top
     return Jpats_Visual_Weather_Types.Cloud_Top_Type is
   begin
      return Clouds.Lower_Layer_Top(Container.This_Subsystem.The_Clouds);
   end Lower_Cloud_Top;

   function Lower_Cloud_Layer_Active  return Boolean is
   begin
      return Clouds.Lower_Layer_Active
        (Container.This_Subsystem.The_Clouds);
   end Lower_Cloud_Layer_Active;

   function Upper_Cloud_Ceiling
     return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type is
   begin
      return Clouds.Upper_Layer_Ceiling(Container.This_Subsystem.The_Clouds);
   end Upper_Cloud_Ceiling;

   function Upper_Cloud_Top
     return Jpats_Visual_Weather_Types.Cloud_Top_Type is
   begin
      return Clouds.Upper_Layer_Top(Container.This_Subsystem.The_Clouds);
   end Upper_Cloud_Top;

   function Upper_Cloud_Layer_Active  return Boolean is
   begin
      return Clouds.Upper_Layer_Active
        (Container.This_Subsystem.The_Clouds);
   end Upper_Cloud_Layer_Active;

-- Storm Get Functions
   function  Storm_1 return Boolean  is
   begin
      return Storms.Storm_1
        (Container.This_Subsystem.The_Storms);
   end Storm_1;

   function  Storm_2 return Boolean  is
   begin
      return Storms.Storm_2
        (Container.This_Subsystem.The_Storms);
   end Storm_2;

   function  Storm_3 return Boolean  is
   begin
      return Storms.Storm_3
        (Container.This_Subsystem.The_Storms);
   end Storm_3;

   function  Storm_4 return Boolean  is
   begin
      return Storms.Storm_4
        (Container.This_Subsystem.The_Storms);
   end Storm_4;

   function  Storm_5 return Boolean  is
   begin
      return Storms.Storm_5
        (Container.This_Subsystem.The_Storms);
   end Storm_5;

   function  Storm_6 return Boolean  is
   begin
      return Storms.Storm_6
        (Container.This_Subsystem.The_Storms);
   end Storm_6;

   function  Storm_7 return Boolean  is
   begin
      return Storms.Storm_7
        (Container.This_Subsystem.The_Storms);
   end Storm_7;

   function  Storm_8 return Boolean  is
   begin
      return Storms.Storm_8
        (Container.This_Subsystem.The_Storms);
   end Storm_8;

   function  Storm_9 return Boolean  is
   begin
      return Storms.Storm_9
        (Container.This_Subsystem.The_Storms);
   end Storm_9;

   function  Storm_10 return Boolean  is
   begin
      return Storms.Storm_10
        (Container.This_Subsystem.The_Storms);
   end Storm_10;

   function Storm_Active  return Boolean is
   begin
      return Storms.Storm_Active
        (Container.This_Subsystem.The_Storms);
   end Storm_Active;

   function Storm_Lightning_Active  return Boolean is
   begin
      return Storms.Storm_Lightning_Active
        (Container.This_Subsystem.The_Storms);
   end Storm_Lightning_Active;

   function Storm_Ceiling
     return Jpats_Visual_Weather_Types.Storm_Ceiling_Type is
   begin
      return Storms.Storm_Ceiling(Container.This_Subsystem.The_Storms);
   end Storm_Ceiling;

   function Storm_Direction
     return Jpats_Visual_Weather_Types.Storm_Direction_Type is
   begin
      return Storms.Storm_Direction(Container.This_Subsystem.The_Storms);
   end Storm_Direction;

   function Storm_Speed
     return Jpats_Visual_Weather_Types.Storm_Speed_Type is
   begin
      return Storms.Storm_Speed(Container.This_Subsystem.The_Storms);
   end Storm_Speed;

   function Storm_Rotation
     return Jpats_Visual_Weather_Types.Storm_Rotation_Type is
   begin
      return Storms.Storm_Rotation(Container.This_Subsystem.The_Storms);
   end Storm_Rotation;

   function Storm_Location
     return Jpats_Visual_Weather_Types.Storm_Location_Type is
   begin
      return Storms.Storm_Location(Container.This_Subsystem.The_Storms);
   end Storm_Location;

   function Storm_Lightning_Frequency
     return Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type is
   begin
      return Storms.Storm_Lightning_Frequency(Container.This_Subsystem.The_Storms);
   end Storm_Lightning_Frequency;

-- Storm Update
   procedure Update_Storms(Iconst : in Float) is
   begin
      Storms.Update(Container.This_Subsystem.The_Storms, Iconst);
   end Update_Storms;

-- Celestial Get Functions
   function Manual_Sun_Position_Enable return Boolean is
   begin
      return Celestial.Manual_Sun_Position_Enable(Container.This_Subsystem.The_Celestial);
   end Manual_Sun_Position_Enable;

   function Manual_Moon_Position_Enable return Boolean is
   begin
      return Celestial.Manual_Moon_Position_Enable(Container.This_Subsystem.The_Celestial);
   end Manual_Moon_Position_Enable;

   function Atmospheric_Illuminance return Integer is
   begin
      return Celestial.Atmospheric_Illuminance(Container.This_Subsystem.The_Celestial);
   end Atmospheric_Illuminance;

   function Sun_Azimuth return Float is
   begin
      return Celestial.Sun_Azimuth(Container.This_Subsystem.The_Celestial);
   end Sun_Azimuth;

   function Sun_Elevation return Float is
   begin
      return Celestial.Sun_Elevation(Container.This_Subsystem.The_Celestial);
   end Sun_Elevation;

   function  Moon_Azimuth  return Float is
   begin
      return Celestial.Moon_Azimuth(Container.This_Subsystem.The_Celestial);
   end Moon_Azimuth;

   function  Moon_Elevation  return Float is
   begin
      return Celestial.Moon_Elevation(Container.This_Subsystem.The_Celestial);
   end Moon_Elevation;

   function  Moon_Phase  return Integer is
   begin
      return Celestial.Moon_Phase(Container.This_Subsystem.The_Celestial);
   end Moon_Phase;

   function  Star_Field  return Integer is
   begin
      return Celestial.Star_Field (Container.This_Subsystem.The_Celestial);
   end Star_Field;

-- Precipitation Get Functions
   function  Rain_Enable  return Boolean is
   begin
      return Vis_Precipitation.Rain_Enable
        (Container.This_Subsystem.The_Precipitation);
   end Rain_Enable;

   function  Hail_Enable  return Boolean is
   begin
      return Vis_Precipitation.Hail_Enable
        (Container.This_Subsystem.The_Precipitation);
   end Hail_Enable;

   function  Falling_Snow  return Boolean is
   begin
      return Vis_Precipitation.Falling_Snow
        (Container.This_Subsystem.The_Precipitation);
   end Falling_Snow;

   function  Precipitation_Level  return Integer is
   begin
      return Vis_Precipitation.Precipitation_Level
        (Container.This_Subsystem.The_Precipitation);
   end Precipitation_Level;

   function  Precipitation_Type  return Integer is
   begin
      return Vis_Precipitation.Precipitation_Type
        (Container.This_Subsystem.The_Precipitation);
   end Precipitation_Type;

   function  In_Moisture  return Boolean is
   begin
      return Vis_Precipitation.In_Moisture
        (Container.This_Subsystem.The_Precipitation);
   end In_Moisture;

   function  Lightning_Enabled  return Boolean is
   begin
      return Vis_Precipitation.Enabled
        (Container.This_Subsystem.The_Precipitation);
   end Lightning_Enabled;

   function  Lightning_Visible  return Boolean is
   begin
      return Vis_Precipitation.Visible
        (Container.This_Subsystem.The_Precipitation);
   end Lightning_Visible;

   function  Lightning_Intensity  return Integer is
   begin
      return Vis_Precipitation.Intensity
        (Container.This_Subsystem.The_Precipitation);
   end Lightning_Intensity;

   function  Lightning_Direction  return Float is
   begin
      return Vis_Precipitation.Direction
        (Container.This_Subsystem.The_Precipitation);
   end Lightning_Direction;

   function  Lightning_Distance return Float is
   begin
      return Vis_Precipitation.Distance
        (Container.This_Subsystem.The_Precipitation);
   end Lightning_Distance;

   function  Lightning_Thunder return Boolean is
   begin
      return Vis_Precipitation.Thunder
        (Container.This_Subsystem.The_Precipitation);
   end Lightning_Thunder;

-- Fog Get Functions
   function  Fog_Active  return Boolean is
   begin
      return Fog.Fog_Active(Container.This_Subsystem.The_Fog);
   end Fog_Active;

   function  Fog_Top  return Integer is
   begin
      return Fog.Fog_Top(Container.This_Subsystem.The_Fog);
   end Fog_Top;

   function  Patch_Fog  return Boolean is
   begin
      return Fog.Patch_Fog(Container.This_Subsystem.The_Fog);
   end Patch_Fog;

end JPATS_Visual_Weather;
