-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_IOS_Interface;

package JPATS_Visual_Weather.Ios_IF is


-- Access The_Snow_Enabled
   procedure Set_Snow_Enabled (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Rain_Enabled
   procedure Set_Precip_Type (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Fog_Enabled
   procedure Set_Fog_Type (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Lightning_Enabled
   procedure Set_Lightning_Enabled (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Hail_Enabled
   procedure Set_Hail_Enabled (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Weather_Override
   procedure Set_Weather_Override (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Time_Of_Day
   procedure Set_Time_Of_Day (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Fog_Top
   procedure Set_Fog_Top (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_RVR_FT
   procedure Set_Rvr_ft (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Visibility_NM
   procedure Set_Visibility_Nm (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_RVR_M
   procedure Set_Rvr_M (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Visibility_KM
   procedure Set_Visibility_Km (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Scud_Enable
   procedure Set_Scud_Enable (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_LCL_Ceiling
   procedure Set_LCL_Ceiling (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_LCL_Top
   procedure Set_LCL_Top (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_UCL_Ceiling
   procedure Set_UCL_Ceiling (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_UCL_Top
   procedure Set_UCL_Top (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_LCL_Type
   procedure Set_Lcl_Type (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_UCL_Type
   procedure Set_Ucl_Type (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Moon
   procedure Set_Moon_Azimuth (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Moon_Elevation (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Moon_Phase (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Moving Storms
   procedure Set_Storm_Type (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Ceiling (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Speed (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Rotation (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Direction (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Change (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Select (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Latitude (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Longitude (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Location_Select (Pdata : in JPATS_IOS_Interface.Set_Value);
   procedure Set_Storm_Lightning_Frequency (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Variable_Ceiling
   procedure Set_Variable_Ceiling (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Cirrus_Clouds
   procedure Set_Cirrus_Clouds (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Precipitation_Level
   procedure Set_Precipitation_Level (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access The_Weather_Off
   procedure Set_Weather_Off (Pdata : in JPATS_IOS_Interface.Set_Value);

-- Access Apply_Weather
   procedure Set_Apply_Weather (Pdata : in JPATS_IOS_Interface.Set_Value);

   procedure Register_Ios_Variables;

end JPATS_Visual_Weather.Ios_IF;
