-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Ios_Interface;
with System;
with Jpats_Visual_Weather.Container;

package body JPATS_Visual_Weather.IOS_if is

   IOS : Container.Ios_Interface_Instance renames
     Container.This_Ios_Interface;

   procedure Set_Time_Of_Day( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Time_Of_Day := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Time_Of_Day_Was_Set := True;
   end Set_Time_Of_Day;

   procedure Set_Snow_Enabled( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Snow_Enabled := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Snow_Enabled_Was_Set := True;
   end Set_Snow_Enabled;

   procedure Set_Precip_Type( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Precip_Type := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Precip_Type_Was_Set := True;
   end Set_Precip_Type;

   procedure Set_Fog_Type( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Fog_Type := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Fog_Type_Was_Set := True;
   end Set_Fog_Type;

   procedure Set_Lightning_Enabled( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Lightning_Enabled := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Lightning_Enabled_Was_Set := True;
   end Set_Lightning_Enabled;

   procedure Set_Hail_Enabled( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Hail_Enabled := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Hail_Enabled_Was_Set := True;
   end Set_Hail_Enabled;

   procedure Set_Fog_Top( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Fog_Top := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Fog_Top_Was_Set := True;
   end Set_Fog_Top;

   procedure Set_Rvr_Ft( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Rvr_Ft := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Rvr_Ft_Was_Set := True;
   end Set_Rvr_Ft;

   procedure Set_Visibility_Nm( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Visibility_Nm := JPATS_IOS_Interface.Convert_To_Float( pData );
      IOS.Visibility_Nm_Was_Set := True;
   end Set_Visibility_Nm;

   procedure Set_Scud_Enable( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Scud_Enable := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Scud_Enable_Was_Set := True;
   end Set_Scud_Enable;

   procedure Set_Lcl_Ceiling( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Lcl_Ceiling := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Lcl_Ceiling_Was_Set := True;
   end Set_Lcl_Ceiling;

   procedure Set_Lcl_Top( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Lcl_Top := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Lcl_Top_Was_Set := True;
   end Set_Lcl_Top;

   procedure Set_Ucl_Ceiling( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Ucl_Ceiling := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Ucl_Ceiling_Was_Set := True;
   end Set_Ucl_Ceiling;

   procedure Set_Ucl_Top( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Ucl_Top := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Ucl_Top_Was_Set := True;
   end Set_Ucl_Top;

   procedure Set_Lcl_Type( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Lcl_Type := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Lcl_Type_Was_Set := True;
   end Set_Lcl_Type;

   procedure Set_Ucl_Type( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Ucl_Type := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Ucl_Type_Was_Set := True;
   end Set_Ucl_Type;

   procedure Set_Moon_Azimuth( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Moon_Azimuth := JPATS_IOS_Interface.Convert_To_Float( pData );
      IOS.Moon_Azimuth_Was_Set := True;
   end Set_Moon_Azimuth;

   procedure Set_Moon_Elevation( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Moon_Elevation := JPATS_IOS_Interface.Convert_To_Float( pData );
      IOS.Moon_Elevation_Was_Set := True;
   end Set_Moon_Elevation;

   procedure Set_Moon_Phase( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Moon_Phase := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Moon_Phase_Was_Set := True;
   end Set_Moon_Phase;

   procedure Set_Storm_Type( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Type := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Storm_Type_Was_Set := True;
   end Set_Storm_Type;

   procedure Set_Storm_Ceiling( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Ceiling := JPATS_IOS_Interface.Convert_To_Integer( pData );
      if IOS.Storm_Ceiling > 30000 then
         IOS.Storm_Ceiling := 30000;
      end if;
      if IOS.Storm_Ceiling < 0 then
         IOS.Storm_Ceiling := 0;
      end if;
      IOS.Storm_Ceiling_Was_Set := True;
   end Set_Storm_Ceiling;

   procedure Set_Storm_Speed( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Speed := JPATS_IOS_Interface.Convert_To_Integer( pData );
      if IOS.Storm_Speed > 300 then
         IOS.Storm_Speed := 300;
      end if;
      if IOS.Storm_Speed < 0 then
         IOS.Storm_Speed := 0;
      end if;
      IOS.Storm_Speed_Was_Set := True;
   end Set_Storm_Speed;

   procedure Set_Storm_Rotation( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Rotation := JPATS_IOS_Interface.Convert_To_Integer( pData );
      if IOS.Storm_Rotation > 360 then
         IOS.Storm_Rotation := 360;
      end if;
      if IOS.Storm_Rotation < 0 then
         IOS.Storm_Rotation := 0;
      end if;
      IOS.Storm_Rotation_Was_Set := True;
   end Set_Storm_Rotation;

   procedure Set_Storm_Direction( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Direction := JPATS_IOS_Interface.Convert_To_Integer( pData );
      if IOS.Storm_Rotation > 360 then
         IOS.Storm_Rotation := 360;
      end if;
      if IOS.Storm_Rotation < 0 then
         IOS.Storm_Rotation := 0;
      end if;
      IOS.Storm_Direction_Was_Set := True;
   end Set_Storm_Direction;

   procedure Set_Storm_Latitude( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Latitude := JPATS_IOS_Interface.Convert_To_Long_Float( pData );
      IOS.Storm_Location_Was_Set := True;
   end Set_Storm_Latitude;

   procedure Set_Storm_Longitude( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Longitude := JPATS_IOS_Interface.Convert_To_Long_Float( pData );
      IOS.Storm_Location_Was_Set := True;
   end Set_Storm_Longitude;

   procedure Set_Storm_Change( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Change := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Storm_Change_Was_Set := True;
   end Set_Storm_Change;

   procedure Set_Storm_Select( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Select := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Storm_Select_Was_Set := True;
   end Set_Storm_Select;

   procedure Set_Storm_Lightning_Frequency( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Lightning_Frequency := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Storm_Lightning_Frequency_Was_Set := True;
   end Set_Storm_Lightning_Frequency;

   procedure Set_Storm_Location_Select( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Storm_Location_Select := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Storm_Location_Select_Was_Set := True;
   end Set_Storm_Location_Select;

   procedure Set_Cirrus_Clouds( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Cirrus_Clouds := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Cirrus_Clouds_Was_Set := True;
   end Set_Cirrus_Clouds;

   procedure Set_Precipitation_Level( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Precipitation_Level :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Precipitation_Level_Was_Set := True;
   end Set_Precipitation_Level;

   procedure Set_Weather_Off ( Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Weather_Off := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Weather_Off_Was_Set := True;
   end Set_Weather_Off;

   procedure Set_Weather_Override ( Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Weather_Override := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Weather_Override_Was_Set := True;
   end Set_Weather_Override;

   procedure Set_Visibility_Km (Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Visibility_Km := JPATS_IOS_Interface.Convert_To_Float( pData );
      IOS.Visibility_Km_Was_Set := True;
   end Set_Visibility_Km;

   procedure Set_Rvr_M ( Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Rvr_M := JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Rvr_M_Was_Set := True;
   end Set_Rvr_M;

   procedure Set_Variable_Ceiling ( Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Variable_Ceiling := JPATS_IOS_Interface.Convert_To_Bool( pData );
      IOS.Variable_Ceiling_Was_Set := True;
   end Set_Variable_Ceiling;

   procedure Set_Apply_Weather ( Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Apply_Weather := Jpats_Ios_Interface.Convert_To_Bool(Pdata);
      Ios.Apply_Weather_Was_Set := True;
   end Set_Apply_Weather;

   procedure Register_Ios_Variables  is
   begin
      JPATS_IOS_Interface.Register
      (Name          => "Time_Of_Day",
       Variable      => IOS.Time_Of_Day'address,
       Set_Routine   => Set_Time_Of_Day'access );

      JPATS_IOS_Interface.Register
      (Name          => "Snow_Enabled",
       Variable      => IOS.Snow_Enabled'address,
       Set_Routine   => Set_Snow_Enabled'access );

      JPATS_IOS_Interface.Register
      (Name          => "Precip_Type",
       Variable      => Ios.Precip_Type'Address,
       Set_Routine   => Set_Precip_Type'Access);

      JPATS_IOS_Interface.Register
      (Name          => "Fog_Type",
       Variable      => IOS.Fog_Type'address,
       Set_Routine   => Set_Fog_Type'access );

      JPATS_IOS_Interface.Register
      (Name          => "Lightning_Enabled",
       Variable      => IOS.Lightning_Enabled'address,
       Set_Routine   => Set_Lightning_Enabled'access );

      JPATS_IOS_Interface.Register
      (Name          => "Moon Azimuth",
       Variable      => IOS.Moon_Azimuth'address,
       Set_Routine   => Set_Moon_Azimuth'access );

      JPATS_IOS_Interface.Register
      (Name          => "Moon Elevation",
       Variable      => IOS.Moon_Elevation'address,
       Set_Routine   => Set_Moon_Elevation'access );

      JPATS_IOS_Interface.Register
      (Name          => "Moon Phase",
       Variable      => IOS.Moon_Phase'address,
       Set_Routine   => Set_Moon_Phase'access );

      JPATS_IOS_Interface.Register
      (Name          => "Hail_Enabled",
       Variable      => IOS.Hail_Enabled'address,
       Set_Routine   => Set_Hail_Enabled'access );

      JPATS_IOS_Interface.Register
      (Name          => "Fog_Top",
       Variable      => IOS.Fog_Top'address,
       Set_Routine   => Set_Fog_Top'access );

      JPATS_IOS_Interface.Register
      (Name          => "Rvr_Ft",
       Variable      => IOS.Rvr_Ft'address,
       Set_Routine   => Set_Rvr_Ft'access );

      JPATS_IOS_Interface.Register
      (Name          => "Rvr_M",
       Variable      => IOS.Rvr_M'address,
       Set_Routine   => Set_Rvr_M'access );

      JPATS_IOS_Interface.Register
      (Name          => "Visibility_Nm",
       Variable      => IOS.Visibility_Nm'address,
       Set_Routine   => Set_Visibility_Nm'access );

      JPATS_IOS_Interface.Register
      (Name          => "Visibility_Km",
       Variable      => IOS.Visibility_Km'address,
       Set_Routine   => Set_Visibility_Km'access );

      JPATS_IOS_Interface.Register
      (Name          => "Scud_Enable",
       Variable      => IOS.Scud_Enable'address,
       Set_Routine   => Set_Scud_Enable'access );

      JPATS_IOS_Interface.Register
      (Name          => "Lcl_Ceiling",
       Variable      => IOS.Lcl_Ceiling'address,
       Set_Routine   => Set_Lcl_Ceiling'access );

      JPATS_IOS_Interface.Register
      (Name          => "Lcl_Top",
       Variable      => IOS.Lcl_Top'address,
       Set_Routine   => Set_Lcl_Top'access );

      JPATS_IOS_Interface.Register
      (Name          => "Ucl_Ceiling",
       Variable      => IOS.Ucl_Ceiling'address,
       Set_Routine   => Set_Ucl_Ceiling'access );

      JPATS_IOS_Interface.Register
      (Name          => "Ucl_Top",
       Variable      => IOS.Ucl_Top'address,
       Set_Routine   => Set_Ucl_Top'access );

      JPATS_IOS_Interface.Register
      (Name          => "Lcl_Type",
       Variable      => IOS.Lcl_Type'address,
       Set_Routine   => Set_Lcl_Type'access );

      JPATS_IOS_Interface.Register
      (Name          => "Ucl_Type",
       Variable      => IOS.Ucl_Type'address,
       Set_Routine   => Set_Ucl_Type'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Type",
       Variable      => IOS.Storm_Type'address,
       Set_Routine   => Set_Storm_Type'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Ceiling",
       Variable      => IOS.Storm_Ceiling'address,
       Set_Routine   => Set_Storm_Ceiling'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Top",
       Variable      => IOS.Storm_Top'address );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Latitude",
       Variable      => IOS.Storm_Latitude'address,
       Set_Routine   => Set_Storm_Latitude'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Longitude",
       Variable      => IOS.Storm_Longitude'address,
       Set_Routine   => Set_Storm_Longitude'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Speed",
       Variable      => IOS.Storm_Speed'address,
       Set_Routine   => Set_Storm_Speed'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Rotation",
       Variable      => IOS.Storm_Rotation'address,
       Set_Routine   => Set_Storm_Rotation'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Heading",
       Variable      => IOS.Storm_Heading'address);

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Length",
       Variable      => IOS.Storm_Length'address );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Active",
       Variable      => IOS.Storm_Active'address );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Width",
       Variable      => IOS.Storm_Width'address );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Name",
       Variable      => IOS.Storm_Name'address );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Direction",
       Variable      => IOS.Storm_Direction'address,
       Set_Routine   => Set_Storm_Direction'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Change",
       Variable      => IOS.Storm_Change'address,
       Set_Routine   => Set_Storm_Change'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Select",
       Variable      => IOS.Storm_Select'address,
       Set_Routine   => Set_Storm_Select'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Location_Select",
       Variable      => IOS.Storm_Location_Select'address,
       Set_Routine   => Set_Storm_Location_Select'access );

      JPATS_IOS_Interface.Register
      (Name          => "Storm_Lightning_Frequency",
       Variable      => IOS.Storm_Lightning_Frequency'address,
       Set_Routine   => Set_Storm_Lightning_Frequency'access );

      JPATS_IOS_Interface.Register
      (Name          => "Cirrus_Clouds",
       Variable      => IOS.Cirrus_Clouds'address,
       Set_Routine   => Set_Cirrus_Clouds'access );

      JPATS_IOS_Interface.Register
      (Name          => "Weather_Off",
       Variable      => IOS.Weather_Off'address,
       Set_Routine   => Set_Weather_Off'access );

      JPATS_IOS_Interface.Register
      (Name          => "Apply_Weather",
       Variable      => IOS.Apply_Weather'address,
       Set_Routine   => Set_Apply_Weather'access );

      JPATS_IOS_Interface.Register
      (Name          => "Precipitation_Level",
       Variable      => IOS.Precipitation_Level'address,
       Set_Routine   => Set_Precipitation_Level'access );

   end Register_Ios_Variables;

end JPATS_Visual_Weather.IOS_IF;