 -------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather.Container;
with Jpats_Visual_Weather.Ios_If;
with Jpats_Simulated_Aircraft; Use Jpats_Simulated_Aircraft;
with Clouds;
with Celestial;
with Storms;
with Cloud_Layer;
with Visibility;
with Vis_Precipitation;
with Fog;
with Jpats_Visual_Weather_Types;
with Jpats_Visual_Airport;
with Lat_Long_Types;
with Jpats_Visual_Buffer;
with Log;

package body JPATS_Visual_Weather.Controller is

   Clear_Clouds : Clouds.Instance;
   Clear_Visibility : Visibility.Instance;
   Clear_Precipitation : Vis_Precipitation.Instance;
   Clear_Fog : Fog.Instance;
   Old_Clouds : Clouds.Instance;
   Old_Visibility : Visibility.Instance;
   Old_Precipitation : Vis_Precipitation.Instance;
   Old_Fog : Fog.Instance;

   Ios : Container.Ios_Interface_Instance renames
         Container.This_Ios_Interface;

   Last_Storm_Location : Jpats_Visual_Weather_Types.Storm_Location_Type;
   Storm_Location_Initialized : Boolean := False;

-- Method Initialize
   procedure Initialize is
   begin

      Container.This_Subsystem.Category_Level :=
        Jpats_Visual_Weather_Types.No_Override;
      Container.This_Subsystem.Radar_In_Control := False;
      Container.This_Subsystem.Weather_Preset := 0;
      Container.This_Subsystem.Ifr_Conditions := False;
      Container.This_Subsystem.Clear_Weather := True;
      Container.This_Subsystem.Time_Of_Day := Jpats_Visual_Weather_Types.Day;
      Container.This_Subsystem.Ambient_Lighting := 10.0;
      Container.This_Subsystem.Winter_Scene := False;

      Clouds.Initialize(Container.This_Subsystem.The_Clouds);

      Celestial.Initialize(Container.This_Subsystem.The_Celestial);

      Visibility.Initialize(Container.This_Subsystem.The_Visibility);

      Vis_Precipitation.Initialize(Container.This_Subsystem.The_Precipitation);

      --      Vis_Environment.Set_Temperature_Deg_C
      --       (Container.This_Subsystem.The_Environment, 15.0);
--      Vis_Environment.Set_Wind_Speed
--        (Container.This_Subsystem.The_Environment, 0.0);
--      Vis_Environment.Set_Wind_Direction
--        (Container.This_Subsystem.The_Environment, 0.0);
--      Vis_Environment.Set_Field_Pressure_Hg
--        (Container.This_Subsystem.The_Environment, 29.92);
--      Vis_Environment.Set_Sea_Level_Pressure_Hg
--        (Container.This_Subsystem.The_Environment, 29.92);

      Fog.Initialize(Container.This_Subsystem.The_Fog);

      Clear_Clouds := Container.This_Subsystem.The_Clouds;
      Clear_Visibility := Container.This_Subsystem.The_Visibility;
      Clear_Precipitation := Container.This_Subsystem.The_Precipitation;
      Clear_Fog := Container.This_Subsystem.The_Fog;

      Container.This_Ios_Interface.Snow_Enabled := false;
      Container.This_Ios_Interface.Precip_Type := 0;
      Container.This_Ios_Interface.Fog_Type := 0;
      Container.This_Ios_Interface.Lightning_Enabled := false;
      
      Container.This_Ios_Interface.Hail_Enabled := false;
      Container.This_Ios_Interface.Weather_Override := 0;
      Container.This_Ios_Interface.Time_Of_Day := 2;
      Container.This_Ios_Interface.Fog_Top := 0;
      Container.This_Ios_Interface.Rvr_Ft := 0;
      Container.This_Ios_Interface.Visibility_Nm := 100.0;
      Container.This_Ios_Interface.Rvr_M := 0;
      Container.This_Ios_Interface.Visibility_Km := 160.9;
      Container.This_Ios_Interface.Scud_Enable := false;
      Container.This_Ios_Interface.LCL_Ceiling := 0;
      Container.This_Ios_Interface.LCL_Top := 0;
      Container.This_Ios_Interface.UCL_Ceiling := 0;
      Container.This_Ios_Interface.UCL_Top := 0;
      Container.This_Ios_Interface.Lcl_Type := 0;
      Container.This_Ios_Interface.Ucl_Type := 0;
      Container.This_Ios_Interface.Storm_Type := 0;
      Container.This_Ios_Interface.Storm_Active := false;
      Container.This_Ios_Interface.Storm_Ceiling := 0;
      Container.This_Ios_Interface.Storm_Top := 0;
      Container.This_Ios_Interface.Storm_Length := 0;
      Container.This_Ios_Interface.Storm_Width := 0;
      Container.This_Ios_Interface.Storm_Latitude := 0.0;
      Container.This_Ios_Interface.Storm_Longitude := 0.0;
      Container.This_Ios_Interface.Storm_Speed := 0;
      Container.This_Ios_Interface.Storm_Direction := 0;
      Container.This_Ios_Interface.Storm_Rotation := 0;
      Container.This_Ios_Interface.Storm_Heading := 0;
      Container.This_Ios_Interface.Storm_Name := "  ";
      Container.This_Ios_Interface.Storm_Lightning_Frequency := 1;
      Container.This_Ios_Interface.Storm_Change := false;
      Container.This_Ios_Interface.Storm_Select := false;
      Container.This_Ios_Interface.Storm_Location_Select := false;
      
      Container.This_Ios_Interface.Variable_Ceiling := false;
      Container.This_Ios_Interface.Cirrus_Clouds := true;
      Container.This_Ios_Interface.Precipitation_Level := 1;
      Container.This_Ios_Interface.Weather_Off := false;

      Container.This_Ios_Interface.Snow_Enabled_Was_Set := false;
      Container.This_Ios_Interface.Precip_Type_Was_Set := False;
      Container.This_Ios_Interface.Fog_Type_Was_Set := false;
      Container.This_Ios_Interface.Lightning_Enabled_Was_Set := false;
      Container.This_Ios_Interface.Moon_Azimuth_Was_Set := false;
      Container.This_Ios_Interface.Moon_Elevation_Was_Set := false;
      Container.This_Ios_Interface.Moon_Phase_Was_Set := false;
      Container.This_Ios_Interface.Hail_Enabled_Was_Set := false;
      Container.This_Ios_Interface.Weather_Override_Was_Set := false;
      Container.This_Ios_Interface.Time_Of_Day_Was_Set := false;
      Container.This_Ios_Interface.Fog_Top_Was_Set := false;
      Container.This_Ios_Interface.Rvr_Ft_Was_Set := false;
      Container.This_Ios_Interface.Visibility_Nm_Was_Set := false;
      Container.This_Ios_Interface.Rvr_M_Was_Set := false;
      Container.This_Ios_Interface.Visibility_Km_Was_Set := false;
      Container.This_Ios_Interface.Scud_Enable_Was_Set := false;
      Container.This_Ios_Interface.LCL_Ceiling_Was_Set := false;
      Container.This_Ios_Interface.LCL_Top_Was_Set := false;
      Container.This_Ios_Interface.Storm_Type_Was_Set := false;
      Container.This_Ios_Interface.Storm_Ceiling_Was_Set := false;
      Container.This_Ios_Interface.UCL_Ceiling_Was_Set := false;
      Container.This_Ios_Interface.Storm_Direction_Was_Set := false;
      Container.This_Ios_Interface.Storm_Rotation_Was_Set := false;
      Container.This_Ios_Interface.Storm_Speed_Was_Set := false;
      Container.This_Ios_Interface.Storm_Lightning_Frequency_Was_Set := false;
      Container.This_Ios_Interface.Storm_Location_Was_Set := false;
      Container.This_Ios_Interface.Storm_Location_Select_Was_Set := false;
      Container.This_Ios_Interface.Storm_Change_Was_Set := false;
      Container.This_Ios_Interface.Storm_Select_Was_Set := false;

      Container.This_Ios_Interface.UCL_Top_Was_Set := false;
      Container.This_Ios_Interface.Lcl_Type_Was_Set := false;
      Container.This_Ios_Interface.Ucl_Type_Was_Set := false;
      Container.This_Ios_Interface.Variable_Ceiling_Was_Set := false;
      Container.This_Ios_Interface.Cirrus_Clouds_Was_Set := false;
      Container.This_Ios_Interface.Dew_Point_Was_Set := false;
      Container.This_Ios_Interface.Precipitation_Level_Was_Set := false;
      Container.This_Ios_Interface.Weather_Off_Was_Set := false;

      Jpats_Visual_Weather.Ios_If.Register_Ios_Variables;

   end Initialize;

-- Method Update
   procedure Update
     (Integration_Constant : in Float) is
      Airport_Position : Lat_Long_Types.Position;
   begin
     if (Ios.Apply_Weather_Was_Set) then
      If (Ios.Lcl_Type_Was_Set) then
         if (Ios.Lcl_Type = 1) then
            Clouds.Set_Lower_Layer_Scattered
              (Container.This_Subsystem.The_Clouds, True);
         elsif (Ios.Lcl_Type = 2) then
            Clouds.Set_Lower_Layer_Broken
              (Container.This_Subsystem.The_Clouds, True);
         elsif (Ios.Lcl_Type = 3) then
            Clouds.Set_Lower_Layer_Overcast
              (Container.This_Subsystem.The_Clouds, True);
         else
            Clouds.Set_Lower_Layer_Overcast
              (Container.This_Subsystem.The_Clouds, False);
            Clouds.Set_Lower_Layer_Broken
              (Container.This_Subsystem.The_Clouds, False);
            Clouds.Set_Lower_Layer_Scattered
              (Container.This_Subsystem.The_Clouds, False);
         end if;
         Ios.Lcl_Type_Was_Set := False;
      end if;

      If (Ios.Ucl_Type_Was_Set) then
         if (Ios.Ucl_Type = 1) then
            Clouds.Set_Upper_Layer_Scattered
              (Container.This_Subsystem.The_Clouds, True);
         elsif (Ios.Ucl_Type = 2) then
            Clouds.Set_Upper_Layer_Broken
              (Container.This_Subsystem.The_Clouds, True);
         elsif (Ios.Ucl_Type = 3) then
            Clouds.Set_Upper_Layer_Overcast
              (Container.This_Subsystem.The_Clouds, True);
         else
            Clouds.Set_Upper_Layer_Overcast
              (Container.This_Subsystem.The_Clouds, False);
            Clouds.Set_Upper_Layer_Broken
              (Container.This_Subsystem.The_Clouds, False);
            Clouds.Set_Upper_Layer_Scattered
              (Container.This_Subsystem.The_Clouds, False);
         end if;
         Ios.Ucl_Type_Was_Set := False;
      end if;

      if (Ios.Lcl_Ceiling_Was_Set) then
         Clouds.Set_Lower_Layer_Ceiling
           (Container.This_Subsystem.The_Clouds,
            Ios.Lcl_Ceiling);
         Ios.Lcl_Ceiling_Was_Set := False;
      end if;
      if (Ios.Lcl_Top_Was_Set) then
         Clouds.Set_Lower_Layer_Top
           (Container.This_Subsystem.The_Clouds,
            Ios.Lcl_Top);
         Ios.Lcl_Top_Was_Set := False;
      end if;

      if (Ios.Ucl_Ceiling_Was_Set) then
         Clouds.Set_Upper_Layer_Ceiling
           (Container.This_Subsystem.The_Clouds,
            Ios.Ucl_Ceiling);
         Ios.Ucl_Ceiling_Was_Set := False;
      end if;
      if (Ios.Ucl_Top_Was_Set) then
         Clouds.Set_Upper_Layer_Top
           (Container.This_Subsystem.The_Clouds,
            Ios.Ucl_Top);
         Ios.Ucl_Top_Was_Set := False;
      end if;

      if (Ios.Precip_Type_Was_Set) then
         if (Ios.Precip_Type = 1) then
            Vis_Precipitation.Set_Rain_Enable
              (Container.This_Subsystem.The_Precipitation, True);
            Vis_Precipitation.Set_Falling_Snow
              (Container.This_Subsystem.The_Precipitation, False);
            Vis_Precipitation.Set_Hail_Enable
              (Container.This_Subsystem.The_Precipitation, False);
         elsif (Ios.Precip_Type = 2) then
            Vis_Precipitation.Set_Rain_Enable
              (Container.This_Subsystem.The_Precipitation, False);
            Vis_Precipitation.Set_Falling_Snow
              (Container.This_Subsystem.The_Precipitation, True);
            Vis_Precipitation.Set_Hail_Enable
              (Container.This_Subsystem.The_Precipitation, False);
         elsif (Ios.Precip_Type = 3) then
            Vis_Precipitation.Set_Rain_Enable
              (Container.This_Subsystem.The_Precipitation, False);
            Vis_Precipitation.Set_Falling_Snow
              (Container.This_Subsystem.The_Precipitation, False);
            Vis_Precipitation.Set_Hail_Enable
              (Container.This_Subsystem.The_Precipitation, True);
         else
            Vis_Precipitation.Set_Rain_Enable
              (Container.This_Subsystem.The_Precipitation, False);
            Vis_Precipitation.Set_Falling_Snow
              (Container.This_Subsystem.The_Precipitation, False);
            Vis_Precipitation.Set_Hail_Enable
              (Container.This_Subsystem.The_Precipitation, False);
         end if;

         if (Ios.Precip_Type > 0) then
            if (not Clouds.Lower_Layer_Overcast
                (Container.This_Subsystem.The_Clouds) and
                not Clouds.Upper_Layer_Overcast
                (Container.This_Subsystem.The_Clouds)) then
               Clouds.Set_Lower_Layer_Overcast
                 (Container.This_Subsystem.The_Clouds, True);
            end if;
         end if;

         Vis_Precipitation.Determine_Precip_Type
           (Container.This_Subsystem.The_Precipitation);
         Visibility.Calculate_Visibility
           (Container.This_Subsystem.The_Visibility,
            Vis_Precipitation.Precipitation_Type
            (Container.This_Subsystem.The_Precipitation),
            Vis_Precipitation.Precipitation_Level
            (Container.This_Subsystem.The_Precipitation));
         Ios.Precip_Type_Was_Set := False;
      end if;

      if (Ios.Lightning_Enabled_Was_Set) then
         Vis_Precipitation.Set_Enabled
           (Container.This_Subsystem.The_Precipitation,
            Ios.Lightning_Enabled);
         if (Ios.Lightning_Enabled) then
            if (not Clouds.Lower_Layer_Overcast
                (Container.This_Subsystem.The_Clouds) and
                not Clouds.Upper_Layer_Overcast
                (Container.This_Subsystem.The_Clouds)) then
               Clouds.Set_Lower_Layer_Overcast
                 (Container.This_Subsystem.The_Clouds, True);
            end if;
         end if;
         Ios.Lightning_Enabled_Was_Set := False;
      end if;

      if (Ios.Manual_Sun_Position_Enable_Was_Set) then
         Celestial.Set_Manual_Sun_Position_Enable
           (Container.This_Subsystem.The_Celestial,
            Ios.Manual_Sun_Position_Enable);
         Ios.Manual_Sun_Position_Enable_Was_Set := False;
      end if;

      if (Ios.Manual_Moon_Position_Enable_Was_Set) then
         Celestial.Set_Manual_Moon_Position_Enable
           (Container.This_Subsystem.The_Celestial,
            Ios.Manual_Moon_Position_Enable);
         Ios.Manual_Moon_Position_Enable_Was_Set := False;
      end if;

      if (Ios.Moon_Azimuth_Was_Set) then
         Celestial.Set_Moon_Azimuth
           (Container.This_Subsystem.The_Celestial,
            Ios.Moon_Azimuth);
         Ios.Moon_Azimuth_Was_Set := False;
      end if;

      if (Ios.Moon_Elevation_Was_Set) then
         Celestial.Set_Moon_Elevation
           (Container.This_Subsystem.The_Celestial,
            Ios.Moon_Elevation);
         Ios.Moon_Elevation_Was_Set := False;
      end if;

      if (Ios.Moon_Phase_Was_Set) then
         Celestial.Set_Moon_Phase
           (Container.This_Subsystem.The_Celestial,
            Ios.Moon_Phase);
         Ios.Moon_Phase_Was_Set := False;
      end if;

      if (not Clouds.Lower_Layer_Overcast
          (Container.This_Subsystem.The_Clouds) and
          not Clouds.Upper_Layer_Overcast
          (Container.This_Subsystem.The_Clouds)) then
         Vis_Precipitation.Set_Rain_Enable
           (Container.This_Subsystem.The_Precipitation, False);
         Vis_Precipitation.Set_Falling_Snow
           (Container.This_Subsystem.The_Precipitation, False);
         Vis_Precipitation.Set_Hail_Enable
           (Container.This_Subsystem.The_Precipitation, False);
         Vis_Precipitation.Set_Enabled
           (Container.This_Subsystem.The_Precipitation, False);
         Vis_Precipitation.Determine_Precip_Type
           (Container.This_Subsystem.The_Precipitation);
         Visibility.Calculate_Visibility
           (Container.This_Subsystem.The_Visibility,
            Vis_Precipitation.Precipitation_Type
            (Container.This_Subsystem.The_Precipitation),
            Vis_Precipitation.Precipitation_Level
            (Container.This_Subsystem.The_Precipitation));
      end if;

      if (Ios.Precipitation_Level_Was_Set) then
         Vis_Precipitation.Set_Precipitation_Level
           (Container.This_Subsystem.The_Precipitation,
            Ios.Precipitation_Level);
         Visibility.Calculate_Visibility
           (Container.This_Subsystem.The_Visibility,
            Vis_Precipitation.Precipitation_Type
            (Container.This_Subsystem.The_Precipitation),
            Vis_Precipitation.Precipitation_Level
            (Container.This_Subsystem.The_Precipitation));
         Ios.Precipitation_Level_Was_Set := False;
      end if;

      if (Ios.Visibility_Nm_Was_Set) then
         Visibility.Set_Visibility_Nm
           (Container.This_Subsystem.The_Visibility,
            Ios.Visibility_Nm);
         Ios.Visibility_Nm_Was_Set := False;
      elsif (Ios.Visibility_Km_Was_Set) then
         Visibility.Set_Visibility_Km
           (Container.This_Subsystem.The_Visibility,
            Ios.Visibility_Km);
         Ios.Visibility_Km_Was_Set := False;
      end if;

      if (Ios.Rvr_Ft_Was_Set) then
         Visibility.Set_Rwy_Vis_Range_Ft
           (Container.This_Subsystem.The_Visibility,
            Ios.Rvr_Ft);
         if ((Ios.Rvr_Ft > 0) and
             ((not Fog.Fog_Active(Container.This_Subsystem.The_Fog)) or
              (not Fog.Patch_Fog(Container.This_Subsystem.The_Fog)))) then
            Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog, True);
         elsif (Ios.Rvr_Ft = 0) then
            Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog, False);
            Fog.Set_Patch_Fog(Container.This_Subsystem.The_Fog, False);
         end if;
         Ios.Rvr_Ft_Was_Set := False;
      end if;

      if (Ios.Rvr_M_Was_Set) then
         Visibility.Set_Rwy_Vis_Range_M
           (Container.This_Subsystem.The_Visibility,
            Ios.Rvr_M);
         if ((Ios.Rvr_M > 0) and
             ((not Fog.Fog_Active(Container.This_Subsystem.The_Fog)) or
              (not Fog.Patch_Fog(Container.This_Subsystem.The_Fog)))) then
            Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog, True);
         elsif (Ios.Rvr_M = 0) then
            Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog, False);
            Fog.Set_Patch_Fog(Container.This_Subsystem.The_Fog, False);
         end if;
         Ios.Rvr_M_Was_Set := False;
      end if;

      if (Ios.Fog_Type_Was_Set) then
         if (Ios.Fog_Type = 1) then
            Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog,
                               true);
         elsif (Ios.Fog_Type = 2) then
            Fog.Set_Patch_Fog(Container.This_Subsystem.The_Fog, true);
         else
            Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog,
                               false);
            Fog.Set_Patch_Fog(Container.This_Subsystem.The_Fog, false);
         end if;

         if (Ios.Fog_Type > 0) then
            if (Visibility.Rwy_Vis_Range_Ft
                (Container.This_Subsystem.The_Visibility) = 0) then
               Visibility.Set_Rwy_Vis_Range_Ft
                 (Container.This_Subsystem.The_Visibility, 1800);
            end if;
         else
            Visibility.Set_Rwy_Vis_Range_Ft
              (Container.This_Subsystem.The_Visibility, 0);
         end if;
         Ios.Fog_Type_Was_Set := False;
      end if;

      if (Ios.Fog_Top_Was_Set) then
         Fog.Set_Fog_Top(Container.This_Subsystem.The_Fog,
                         Ios.Fog_Top);
         if (Ios.Fog_Top > 0) then
            if (not Fog.Fog_Active(Container.This_Subsystem.The_Fog) or
                not Fog.Patch_Fog(Container.This_Subsystem.The_Fog)) then
               Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog, True);
            end if;
         else
            Fog.Set_Fog_Active(Container.This_Subsystem.The_Fog, False);
            Fog.Set_Patch_Fog(Container.This_Subsystem.The_Fog, False);
         end if;
         Ios.Fog_Top_Was_Set := False;
      end if;

      if (Ios.Time_Of_Day_Was_Set) then
         Container.This_Subsystem.Time_Of_Day :=
           Ios.Time_Of_Day;
         Ios.Time_Of_Day_Was_Set := False;
      end if;

      if (Ios.Cirrus_Clouds_Was_Set) then
         Clouds.Set_Cirrus_Clouds
           (Container.This_Subsystem.The_Clouds,
            Ios.Cirrus_Clouds);
         Ios.Cirrus_Clouds_Was_Set := False;
      end if;

      if (Ios.Scud_Enable_Was_Set) then
         Clouds.Set_Scud_Enabled
           (Container.This_Subsystem.The_Clouds,
            Ios.Scud_Enable);
         Ios.Scud_Enable_Was_Set := False;
      end if;

      if (Ios.Snow_Enabled_Was_Set) then
         Container.This_Subsystem.Winter_Scene :=
           Ios.Snow_Enabled;
         Ios.Snow_Enabled_Was_Set := False;
      end if;

      Airport_Position := Jpats_Visual_Airport.Position;
      Clouds.Verify_Cloud_Layers
        (Container.This_Subsystem.The_Clouds,
         Integer(Airport_Position.Altitude));

      Vis_Precipitation.Determine_Moisture
        (Container.This_Subsystem.The_Precipitation,
         Clouds.The_Cloud_Layer(Container.This_Subsystem.The_Clouds,1),
         Clouds.The_Cloud_Layer(Container.This_Subsystem.The_Clouds,2),
         Fog.Fog_Top(Container.This_Subsystem.The_Fog),
         Integer(Jpats_Simulated_Aircraft.Get_Aircraft_Geometric_Altitude),
         Integer(Airport_Position.Altitude));

      Container.This_Subsystem.IFR_Conditions :=
        (Visibility.Visibility_Nm
         (Container.This_Subsystem.The_Visibility) < 3.0) or
       ((Clouds.Lower_Layer_Ceiling
         (Container.This_Subsystem.The_Clouds) < 1000 and
         Clouds.Lower_Layer_Overcast
         (Container.This_Subsystem.The_Clouds)) or
        (Clouds.Upper_Layer_Ceiling
         (Container.This_Subsystem.The_Clouds) < 1000 and
         Clouds.Upper_Layer_Overcast
         (Container.This_Subsystem.The_Clouds))) or
        (Visibility.Rwy_Vis_Range_Ft
        (Container.This_Subsystem.The_Visibility) > 0 and
         Visibility.Rwy_Vis_Range_Ft
        (Container.This_Subsystem.The_Visibility) < 2400);

      if (Ios.Weather_Off_Was_Set) then
         if (Ios.Weather_Off) then
            Old_Clouds := Container.This_Subsystem.The_Clouds;
            Old_Visibility := Container.This_Subsystem.The_Visibility;
            Old_Precipitation := Container.This_Subsystem.The_Precipitation;
            Old_Fog := Container.This_Subsystem.The_Fog;
            Container.This_Subsystem.The_Clouds := Clear_Clouds;
            Container.This_Subsystem.The_Visibility := Clear_Visibility;
            Container.This_Subsystem.The_Precipitation := Clear_Precipitation;
            Container.This_Subsystem.The_Fog := Clear_Fog;
         else
            Container.This_Subsystem.The_Clouds := Old_Clouds;
            Container.This_Subsystem.The_Visibility := Old_Visibility;
            Container.This_Subsystem.The_Precipitation := Old_Precipitation;
            Container.This_Subsystem.The_Fog := Old_Fog;
         end if;
         Ios.Weather_Off_Was_Set := False;
      end if;

      Vis_Precipitation.Calculate_Lightning_Direction
        (Container.This_Subsystem.The_Precipitation,
         Jpats_Visual_Buffer.Lightning_Id,
         Jpats_Simulated_Aircraft.Get_North,
         Jpats_Simulated_Aircraft.Get_East,
         Jpats_Simulated_Aircraft.Get_Hdg_Angle,
         Jpats_Visual_Buffer.Lightning_Latitude,
         Jpats_Visual_Buffer.Lightning_Longitude,
         Integration_Constant);

      Ios.Time_Of_Day := Container.This_Subsystem.Time_Of_Day;
      if (Clouds.Upper_Layer_Scattered
          (Container.This_Subsystem.The_Clouds)) then
         Ios.Ucl_Type := 1;
      elsif (Clouds.Upper_Layer_Broken
             (Container.This_Subsystem.The_Clouds)) then
         Ios.Ucl_Type := 2;
      elsif (Clouds.Upper_Layer_Overcast
             (Container.This_Subsystem.The_Clouds)) then
         Ios.Ucl_Type := 3;
      else
         Ios.Ucl_Type := 0;
      end if;
      if (Clouds.Lower_Layer_Scattered
          (Container.This_Subsystem.The_Clouds)) then
         Ios.Lcl_Type := 1;
      elsif (Clouds.Lower_Layer_Broken
             (Container.This_Subsystem.The_Clouds)) then
         Ios.Lcl_Type := 2;
      elsif (Clouds.Lower_Layer_Overcast
             (Container.This_Subsystem.The_Clouds)) then
         Ios.Lcl_Type := 3;
      else
         Ios.Lcl_Type := 0;
      end if;
      Ios.Ucl_Ceiling := Clouds.Upper_Layer_Ceiling
        (Container.This_Subsystem.The_Clouds);
      Ios.Ucl_Top := Clouds.Upper_Layer_Top
        (Container.This_Subsystem.The_Clouds);
      Ios.Lcl_Ceiling := Clouds.Lower_Layer_Ceiling
        (Container.This_Subsystem.The_Clouds);
      Ios.Lcl_Top := Clouds.Lower_Layer_Top
        (Container.This_Subsystem.The_Clouds);
      Ios.Cirrus_Clouds := Clouds.Cirrus_Clouds
        (Container.This_Subsystem.The_Clouds);
      Ios.Scud_Enable := Clouds.Scud_Enabled
        (Container.This_Subsystem.The_Clouds);
      Ios.Visibility_Nm := Visibility.Visibility_Nm
        (Container.This_Subsystem.The_Visibility);
      Ios.Rvr_Ft := Visibility.Rwy_Vis_Range_Ft
        (Container.This_Subsystem.The_Visibility);
      Ios.Visibility_Km := Visibility.Visibility_Km
        (Container.This_Subsystem.The_Visibility);
      Ios.Rvr_M := Visibility.Rwy_Vis_Range_M
        (Container.This_Subsystem.The_Visibility);
      if (Vis_Precipitation.Rain_Enable
          (Container.This_Subsystem.The_Precipitation)) then
         Ios.Precip_Type := 1;
      elsif (Vis_Precipitation.Falling_Snow
             (Container.This_Subsystem.The_Precipitation)) then
         Ios.Precip_Type := 2;
      elsif (Vis_Precipitation.Hail_Enable
             (Container.This_Subsystem.The_Precipitation)) then
         Ios.Precip_Type := 3;
      else
         Ios.Precip_Type := 0;
      end if;
      Ios.Hail_Enabled := Vis_Precipitation.Hail_Enable
        (Container.This_Subsystem.The_Precipitation);
      Ios.Precipitation_Level := Vis_Precipitation.Precipitation_Level
        (Container.This_Subsystem.The_Precipitation);
      Ios.Lightning_Enabled := Vis_Precipitation.Enabled
        (Container.This_Subsystem.The_Precipitation);
      if (Fog.Fog_Active(Container.This_Subsystem.The_Fog)) then
         Ios.Fog_Type := 1;
      elsif (Fog.Patch_Fog(Container.THis_Subsystem.The_Fog)) then
         Ios.Fog_Type := 2;
      else
         Ios.Fog_Type := 0;
      end if;
      Ios.Fog_Top := Fog.Fog_Top(Container.This_Subsystem.The_Fog);

      Ios.Apply_Weather := False;
      Ios.Apply_Weather_Was_Set := False;
    elsif (Ios.Storm_Location_Select_Was_Set) then
       Storm_Location_Initialized := True;
       Storms.Set_Storm_Location
           (Container.This_Subsystem.The_Storms,
            Ios.Storm_Latitude, Ios.Storm_Longitude);
       Ios.Storm_Location_Select_Was_Set := False;
       Ios.Storm_Location_Select := False;
    elsif (Ios.Storm_Select_Was_Set) then
       if (not Storm_Location_Initialized) then
          Storms.Set_Storm_Location
              (Container.This_Subsystem.The_Storms,
               Get_North, Get_East);
          Ios.Storm_Latitude := Get_North;
          Ios.Storm_Longitude := Get_East;
       end if;      
       If (Ios.Storm_Type_Was_Set) then
          if (Ios.Storm_Type = 1) then
             Storms.Set_Storm_1
               (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 2) then
             Storms.Set_Storm_2
               (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 3) then
             Storms.Set_Storm_3
            (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 4) then
             Storms.Set_Storm_4
            (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 5) then
             Storms.Set_Storm_5
               (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 6) then
             Storms.Set_Storm_6
               (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 7) then
             Storms.Set_Storm_7
              (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 8) then
             Storms.Set_Storm_8
               (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 9) then
             Storms.Set_Storm_9
               (Container.This_Subsystem.The_Storms, True);
          elsif (Ios.Storm_Type = 10) then
            Storms.Set_Storm_10
               (Container.This_Subsystem.The_Storms, True);
          else
            Storms.Set_Storm_1
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_2
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_3
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_4
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_5
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_6
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_7
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_8
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_9
              (Container.This_Subsystem.The_Storms, False);
            Storms.Set_Storm_10
              (Container.This_Subsystem.The_Storms, False);
          end if;
          Ios.Storm_Active := Storms.Storm_Active(
                              Container.This_Subsystem.The_Storms);
          if (Ios.Storm_Active) then
             Ios.Storm_Ceiling := Storms.Storm_Ceiling(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Top := Storms.Storm_Top(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Direction := Storms.Storm_Direction(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Speed := Storms.Storm_Speed(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Rotation := Storms.Storm_Rotation(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Heading := Storms.Storm_Rotation(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Lightning_Frequency := Storms.Storm_Lightning_Frequency(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Length := Storms.Storm_Length(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Width := Storms.Storm_Width(
                               Container.This_Subsystem.The_Storms);
             Ios.Storm_Name := Storms.Storm_Name(
                               Container.This_Subsystem.The_Storms);
          end if;
          Ios.Storm_Type_Was_Set := False;
       end if;
       Ios.Storm_Select_Was_Set := False;
       Ios.Storm_Select := False;
    elsif (Ios.Storm_Change_Was_Set) then
       if (Ios.Storm_Ceiling_Was_Set) then
          Storms.Set_Storm_Ceiling
            (Container.This_Subsystem.The_Storms,
             Ios.Storm_Ceiling);
          Ios.Storm_Top := Storms.Storm_Top(Container.This_Subsystem.The_Storms);
          Ios.Storm_Ceiling_Was_Set := False;
       end if;
       if (Ios.Storm_Direction_Was_Set) then
          Storms.Set_Storm_Direction
            (Container.This_Subsystem.The_Storms,
             Ios.Storm_Direction);
          Ios.Storm_Direction_Was_Set := False;
       end if;
       if (Ios.Storm_Rotation_Was_Set) then
          Storms.Set_Storm_Rotation
            (Container.This_Subsystem.The_Storms,
             Ios.Storm_Rotation);
          Ios.Storm_Heading := Ios.Storm_Rotation;
          Ios.Storm_Rotation_Was_Set := False;
       end if;
       if (Ios.Storm_Speed_Was_Set) then
          Storms.Set_Storm_Speed
             (Container.This_Subsystem.The_Storms,
             Ios.Storm_Speed);
          Ios.Storm_Speed_Was_Set := False;
       end if;
       if (Ios.Storm_Lightning_Frequency_Was_Set) then
          Storms.Set_Storm_Lightning_Frequency
           (Container.This_Subsystem.The_Storms,
            Ios.Storm_Lightning_Frequency);
          Ios.Storm_Lightning_Frequency_Was_Set := False;
       end if;
       Ios.Storm_Change_Was_Set := False;
       Ios.Storm_Change := False;
     end if;

     if (Ios.Storm_Active) then
        Ios.Storm_Latitude := Storms.Storm_Location(
              Container.This_Subsystem.The_Storms).Latitude;
        Ios.Storm_Longitude := Storms.Storm_Location(
              Container.This_Subsystem.The_Storms).Longitude;
     end if;

   end Update;


end JPATS_Visual_Weather.Controller;
