-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;
with Clouds;
with Lat_Long_Types;
with Location;
with Celestial;
with Storms;
with Visibility;
with Vis_Precipitation;
--with Vis_Environment;
with Fog;

private package JPATS_Visual_Weather.Container is


  type Instance is record
    Category_Level : Integer;
    Radar_In_Control : Boolean;
    Weather_Preset : Integer;
    IFR_Conditions : Boolean;
    Clear_Weather : Boolean;
    Bright_Day : Boolean;
    Time_Of_Day : Integer;
    Current_Time : Integer;
    Ambient_Lighting : Float;
    Winter_Scene : Boolean;
    The_Celestial   : Celestial.Instance;
    The_Clouds : Clouds.Instance;
    The_Storms : Storms.Instance;
    The_Visibility : Visibility.Instance;
    The_Precipitation : Vis_Precipitation.Instance;
--    The_Environment : Vis_Environment.Instance;
    The_Fog : Fog.Instance;
  end record;

  This_Subsystem : Instance;

  type Ios_Interface_Instance is record
    Snow_Enabled : Boolean;
    Precip_Type : Integer;
    Fog_Type : Integer;
    Lightning_Enabled : Boolean;
    Manual_Sun_Position_Enable : Boolean;
    Manual_Moon_Position_Enable : Boolean;
    Atmospheric_Illuminance : Integer;
    Sun_Azimuth : Float;
    Sun_Elevation : Float;
    Moon_Azimuth : Float;
    Moon_Elevation : Float;
    Moon_Phase : Integer;
    Star_Field : Integer;
    Hail_Enabled : Boolean;
    Weather_Override : Integer;
    Time_Of_Day : Integer;
    Fog_Top : Integer;
    Rvr_Ft : Integer;
    Visibility_Nm : Float;
    Rvr_M : Integer;
    Visibility_Km : Float;
    Scud_Enable : Boolean;
    LCL_Ceiling : Integer;
    LCL_Top : Integer;
    UCL_Ceiling : Integer;
    UCL_Top : Integer;
    Lcl_Type : Integer;
    Ucl_Type : Integer;
    Storm_Active : Boolean;
    Storm_Type : Integer;
    Storm_Ceiling : Jpats_Visual_Weather_Types.Storm_Ceiling_Type;
    Storm_Top : Jpats_Visual_Weather_Types.Storm_Top_Type;
    Storm_Longitude : Lat_Long_Types.Longitude_Degrees;
    Storm_Latitude : Lat_Long_Types.Latitude_Degrees;
    Storm_Direction : Jpats_Visual_Weather_Types.Storm_Direction_Type;
    Storm_Rotation  : Jpats_Visual_Weather_Types.Storm_Rotation_Type;
    Storm_Heading  : Jpats_Visual_Weather_Types.Storm_Rotation_Type;
    Storm_Length : Jpats_Visual_Weather_Types.Storm_Length_Type;
    Storm_Width : Jpats_Visual_Weather_Types.Storm_Width_Type;
    Storm_Speed : Jpats_Visual_Weather_Types.Storm_Speed_Type;
    Storm_Name : Jpats_Visual_Weather_Types.Storm_Name_Type;
    Storm_Lightning_Frequency : Jpats_Visual_Weather_Types.Storm_Lightning_Frequency_Type;
    Storm_Change : Boolean;
    Storm_Select : Boolean;
    Storm_Location_Select : Boolean;
    Variable_Ceiling : Boolean;
    Cirrus_Clouds : Boolean;
    Precipitation_Level : Integer;
    Weather_Off : Boolean;
    Apply_Weather : Boolean;

    Snow_Enabled_Was_Set : Boolean;
    Precip_Type_Was_Set : Boolean;
    Fog_Type_Was_Set : Boolean;
    Lightning_Enabled_Was_Set : Boolean;
    Manual_Sun_Position_Enable_Was_Set : Boolean;
    Manual_Moon_Position_Enable_Was_Set : Boolean;
    Atmospheric_Illuminance_Was_Set : Boolean;
    Sun_Azimuth_Was_Set : Boolean;
    Sun_Elevation_Was_Set : Boolean;
    Moon_Azimuth_Was_Set : Boolean;
    Moon_Elevation_Was_Set : Boolean;
    Moon_Phase_Was_Set : Boolean;
    Star_Field_Was_Set : Boolean;
    Hail_Enabled_Was_Set : Boolean;
    Weather_Override_Was_Set : Boolean;
    Time_Of_Day_Was_Set : Boolean;
    Fog_Top_Was_Set : Boolean;
    Rvr_Ft_Was_Set : Boolean;
    Visibility_Nm_Was_Set : Boolean;
    Rvr_M_Was_Set : Boolean;
    Visibility_Km_Was_Set : Boolean;
    Scud_Enable_Was_Set : Boolean;
    LCL_Ceiling_Was_Set : Boolean;
    LCL_Top_Was_Set : Boolean;
    UCL_Ceiling_Was_Set : Boolean;
    UCL_Top_Was_Set : Boolean;
    Lcl_Type_Was_Set : Boolean;
    Ucl_Type_Was_Set : Boolean;
    Storm_Type_Was_Set : Boolean;
    Storm_Ceiling_Was_Set : Boolean;
    Storm_Direction_Was_Set : Boolean;
    Storm_Speed_Was_Set : Boolean;
    Storm_Rotation_Was_Set : Boolean;
    Storm_Lightning_Frequency_Was_Set : Boolean;
    Storm_Location_Was_Set : Boolean;
    Storm_Location_Select_Was_Set : Boolean;
    Storm_Change_Was_Set : Boolean;
    Storm_Select_Was_Set : Boolean;
    Variable_Ceiling_Was_Set : Boolean;
    Cirrus_Clouds_Was_Set : Boolean;
    Dew_Point_Was_Set : Boolean;
    Precipitation_Level_Was_Set : Boolean;
    Weather_Off_Was_Set : Boolean;
    Apply_Weather_Was_Set : Boolean;
  end record;

  This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Visual_Weather.Container;
