-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;

package Fog is


  type Instance is private;

-- Access Fog_Active
   function  Fog_Active (An_Instance : in Instance) return Boolean;
   procedure Set_Fog_Active
     (An_Instance : in out Instance;
      Fog_On : in Boolean);

-- Access Fog_Top
   function  Fog_Top (An_Instance : in Instance) return Integer;
   procedure Set_Fog_Top
     (An_Instance : in out Instance;
      Fog_Top_Altitude : in Integer);

-- Access Patch_Fog
   function  Patch_Fog (An_Instance : in Instance) return Boolean;
   procedure Set_Patch_Fog
     (An_Instance : in out Instance;
      Fog_Is_Patchy : in Boolean);

-- Initialize Procedure
   procedure Initialize
     (An_Instance : in out Instance);


private

  type Instance is record
    Fog_Active : Boolean;
    Fog_Top : Natural;
    Patch_Fog : Boolean;
  end record;


end Fog;
