-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Fog is


-- Access Fog_Active
   function  Fog_Active
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Fog_Active;
   end Fog_Active;

   procedure Set_Fog_Active
     (An_Instance : in out Instance;
      Fog_On : in Boolean) is
   begin
      An_Instance.Fog_Active := Fog_On;
      if Fog_On then
         if An_Instance.Patch_Fog then
            An_Instance.Patch_Fog := False;
         end if;
         if An_Instance.Fog_Top = 0 then
            An_Instance.Fog_Top := 200;
         end if;
      elsif not An_Instance.Patch_Fog then
         An_Instance.Fog_Top := 0;
      end if;
   end Set_Fog_Active;

-- Access Fog_Top
   function  Fog_Top
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Fog_Top;
   end Fog_Top;

   procedure Set_Fog_Top
     (An_Instance : in out Instance;
      Fog_Top_Altitude : in Integer) is
   begin
      if Fog_Top_Altitude > 10000 then
         An_Instance.Fog_Top := 10000;
      elsif Fog_Top_Altitude < 0 then
         An_Instance.Fog_Top := 200;
      else
         An_Instance.Fog_Top := Fog_Top_Altitude;
      end if;
      if An_Instance.Fog_Top /= 0 then
         if not An_Instance.Fog_Active or not An_Instance.Patch_Fog then
            An_Instance.Fog_Active := True;
         end if;
      else
         An_Instance.Fog_Active := False;
         An_Instance.Patch_Fog := False;
      end if;
   end Set_Fog_Top;

-- Access Patch_Fog
   function  Patch_Fog
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Patch_Fog;
   end Patch_Fog;

   procedure Set_Patch_Fog
     (An_Instance : in out Instance;
      Fog_Is_Patchy : in Boolean) is
   begin
      An_Instance.Patch_Fog := Fog_Is_Patchy;
      if Fog_Is_Patchy then
         if An_Instance.Fog_Active then
            An_Instance.Fog_Active := False;
         end if;
         if An_Instance.Fog_Top = 0 then
            An_Instance.Fog_Top := 200;
         end if;
      elsif not An_Instance.Fog_Active then
         An_Instance.Fog_Top := 0;
      end if;
   end Set_Patch_Fog;

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Fog_Active := False;
      An_Instance.Patch_Fog := False;
      An_Instance.Fog_Top := 0;
   end Initialize;


end Fog;
