-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;
with Cloud_Layer;

package Clouds is

  type Cloud_Array is array (Positive range <>) of Cloud_Layer.Instance;

  type Instance is private;


-- Access Cirrus_Clouds
   function  Cirrus_Clouds (An_Instance : in Instance) return Boolean;
   procedure Set_Cirrus_Clouds
     (An_Instance : in out Instance;
      Cirrus_Clouds_On : in Boolean);

-- Access Scud_Enabled
   function Scud_Enabled (An_Instance : in Instance) return Boolean;
   procedure Set_Scud_Enabled
     (An_Instance : in out Instance;
      Scud_On : in Boolean);

-- Return A Cloud Layer
   function The_Cloud_Layer
     (An_Instance : in Instance;
      A_Layer : in Integer)
      return Cloud_Layer.Instance;

-- Cloud Layer Functions
   procedure Set_Lower_Layer_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Integer);
   procedure Set_Lower_Layer_Top
     (An_Instance : in out Instance;
      An_Altitude : in Integer);
   procedure Set_Upper_Layer_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Integer);
   procedure Set_Upper_Layer_Top
     (An_Instance : in out Instance;
      An_Altitude : in Integer);
   procedure Set_Lower_Layer_Overcast
     (An_Instance : in out Instance;
      Overcast_On : in Boolean);
   procedure Set_Lower_Layer_Scattered
     (An_Instance : in out Instance;
      Scattered_On : in Boolean);
   procedure Set_Lower_Layer_Broken
     (An_Instance : in out Instance;
      Broken_On : in Boolean);
   procedure Set_Lower_Layer_Active
     (An_Instance : in out Instance;
      Cloud_Active : in Boolean);
   procedure Set_Upper_Layer_Overcast
     (An_Instance : in out Instance;
      Overcast_On : in Boolean);
   procedure Set_Upper_Layer_Scattered
     (An_Instance : in out Instance;
      Scattered_On : in Boolean);
   procedure Set_Upper_Layer_Broken
     (An_Instance : in out Instance;
      Broken_On : in Boolean);
   procedure Set_Upper_Layer_Active
     (An_Instance : in out Instance;
      Cloud_Active : in Boolean);

   function Lower_Layer_Ceiling
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type;
   function Lower_Layer_Top
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Top_Type;
   function Lower_Layer_Active
     (An_Instance : in Instance) return Boolean;
   function Lower_Layer_Overcast
     (An_Instance : in Instance) return Boolean;
   function Lower_Layer_Scattered
     (An_Instance : in Instance) return Boolean;
   function Lower_Layer_Broken
     (An_Instance : in Instance) return Boolean;
   function Upper_Layer_Ceiling
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type;
   function Upper_Layer_Top
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Top_Type;
   function Upper_Layer_Active
     (An_Instance : in Instance) return Boolean;
   function Upper_Layer_Overcast
     (An_Instance : in Instance) return Boolean;
   function Upper_Layer_Scattered
     (An_Instance : in Instance) return Boolean;
   function Upper_Layer_Broken
     (An_Instance : in Instance) return Boolean;

-- Method Verify_Cloud_Layers
   procedure Verify_Cloud_Layers
     (An_Instance : in out Instance;
      Airport_Elevation : in Integer);

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance);


private

  type Instance is record
    Cirrus_Clouds : Boolean;
    Scud_Enabled : Boolean;
    The_Cloud_Layer : Cloud_Array (1..2);
  end record;


end Clouds;
