-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Clouds is


-- Access Cirrus_Clouds
   function  Cirrus_Clouds
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Cirrus_Clouds;
   end Cirrus_Clouds;

   procedure Set_Cirrus_Clouds
     (An_Instance : in out Instance;
      Cirrus_Clouds_On : in Boolean) is
   begin
      An_Instance.Cirrus_Clouds := Cirrus_Clouds_On;
   end Set_Cirrus_Clouds;

-- Access Scud_Enabled
   function Scud_Enabled
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Scud_Enabled;
   end Scud_Enabled;

   procedure Set_Scud_Enabled
     (An_Instance : in out Instance;
      Scud_On : in Boolean) is
   begin
      An_Instance.Scud_Enabled := Scud_On;
   end Set_Scud_Enabled;

-- Return A Cloud Layer
   function The_Cloud_Layer
     (An_Instance : in Instance;
      A_Layer : in Integer)
      return Cloud_Layer.Instance is
   begin
      return An_Instance.The_Cloud_Layer(A_Layer);
   end The_Cloud_Layer;

-- Method Verify_Cloud_Layers
   procedure Verify_Cloud_Layers
     (An_Instance : in out Instance;
      Airport_Elevation : in Integer) is
      Cloud_Ceiling_1 : Integer;
      Cloud_Top_1 : Integer;
      Cloud_Ceiling_2 : Integer;
      Cloud_Top_2 : Integer;
   begin
      Cloud_Ceiling_1 :=
        Cloud_Layer.Ceiling(An_Instance.The_Cloud_Layer(1));
      Cloud_Top_1 :=
        Cloud_Layer.Top(An_Instance.The_Cloud_Layer(1));
      Cloud_Ceiling_2 :=
        Cloud_Layer.Ceiling(An_Instance.The_Cloud_Layer(2));
      Cloud_Top_2 :=
        Cloud_Layer.Top(An_Instance.The_Cloud_Layer(2));

      if ((Cloud_Top_1 <= Cloud_Ceiling_1 + Airport_Elevation) and
          (Cloud_Ceiling_1 /= 0)) then
         Cloud_Top_1 := Cloud_Ceiling_1 + Airport_Elevation + 1000;
         Cloud_Layer.Set_Top
           (An_Instance.The_Cloud_Layer(1), Cloud_Top_1);
      end if;

      if ((Cloud_Ceiling_2 <= Cloud_Top_1) and
          ((Cloud_Ceiling_2 /= 0) or (Cloud_Top_2 /= 0)) and
          (Cloud_Top_1 /= 0)) then
         Cloud_Ceiling_2 := Cloud_Top_1 + 1000;
         Cloud_Layer.Set_Ceiling
           (An_Instance.The_Cloud_Layer(2), Cloud_Ceiling_2);
      elsif ((Cloud_Ceiling_2 < Airport_Elevation) and
             Cloud_Ceiling_2 /= 0) then
         Cloud_Ceiling_2 := Cloud_Top_1 + Airport_Elevation;
         Cloud_Layer.Set_Ceiling
           (An_Instance.The_Cloud_Layer(2), Cloud_Ceiling_2);
      end if;

      if ((Cloud_Top_2 <= Cloud_Ceiling_2) and
          (Cloud_Ceiling_2 /= 0)) then
         Cloud_Top_2 := Cloud_Ceiling_2 + 1000;
         Cloud_Layer.Set_Top
           (An_Instance.The_Cloud_Layer(2), Cloud_Top_2);
      end if;

    end Verify_Cloud_Layers;

-- Cloud Layer Functions
   procedure Set_Lower_Layer_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      Cloud_Layer.Set_Ceiling(An_Instance.The_Cloud_Layer(1), An_Altitude);
   end Set_Lower_Layer_Ceiling;

   procedure Set_Lower_Layer_Top
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      Cloud_Layer.Set_Top(An_Instance.The_Cloud_Layer(1), An_Altitude);
   end Set_Lower_Layer_Top;

   procedure Set_Upper_Layer_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      Cloud_Layer.Set_Ceiling(An_Instance.The_Cloud_Layer(2), An_Altitude);
   end Set_Upper_Layer_Ceiling;

   procedure Set_Upper_Layer_Top
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      Cloud_Layer.Set_Top(An_Instance.The_Cloud_Layer(2), An_Altitude);
   end Set_Upper_Layer_Top;

   procedure Set_Lower_Layer_Overcast
     (An_Instance : in out Instance;
      Overcast_On : in Boolean) is
   begin
      Cloud_Layer.Set_Overcast(An_Instance.The_Cloud_Layer(1), Overcast_On);
   end Set_Lower_Layer_Overcast;

   procedure Set_Lower_Layer_Scattered
     (An_Instance : in out Instance;
      Scattered_On : in Boolean) is
   begin
      Cloud_Layer.Set_Scattered(An_Instance.The_Cloud_Layer(1), Scattered_On);
   end Set_Lower_Layer_Scattered;

   procedure Set_Lower_Layer_Broken
     (An_Instance : in out Instance;
      Broken_On : in Boolean) is
   begin
      Cloud_Layer.Set_Broken(An_Instance.The_Cloud_Layer(1), Broken_On);
   end Set_Lower_Layer_Broken;

   procedure Set_Lower_Layer_Active
     (An_Instance : in out Instance;
      Cloud_Active : in Boolean) is
   begin
      Cloud_Layer.Set_Active(An_Instance.The_Cloud_Layer(1), Cloud_Active);
   end Set_Lower_Layer_Active;

   procedure Set_Upper_Layer_Overcast
     (An_Instance : in out Instance;
      Overcast_On : in Boolean) is
   begin
      Cloud_Layer.Set_Overcast(An_Instance.The_Cloud_Layer(2), Overcast_On);
   end Set_Upper_Layer_Overcast;

   procedure Set_Upper_Layer_Scattered
     (An_Instance : in out Instance;
      Scattered_On : in Boolean) is
   begin
      Cloud_Layer.Set_Scattered(An_Instance.The_Cloud_Layer(2), Scattered_On);
   end Set_Upper_Layer_Scattered;

   procedure Set_Upper_Layer_Broken
     (An_Instance : in out Instance;
      Broken_On : in Boolean) is
   begin
      Cloud_Layer.Set_Broken(An_Instance.The_Cloud_Layer(2), Broken_On);
   end Set_Upper_Layer_Broken;

   procedure Set_Upper_Layer_Active
     (An_Instance : in out Instance;
      Cloud_Active : in Boolean) is
   begin
      Cloud_Layer.Set_Active(An_Instance.The_Cloud_Layer(2), Cloud_Active);
   end Set_Upper_Layer_Active;


   function Lower_Layer_Ceiling
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type is
   begin
      return Cloud_Layer.Ceiling(An_Instance.The_Cloud_Layer(1));
   end Lower_Layer_Ceiling;

   function Upper_Layer_Ceiling
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type is
   begin
      return Cloud_Layer.Ceiling(An_Instance.The_Cloud_Layer(2));
   end Upper_Layer_Ceiling;

   function Lower_Layer_Top
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Top_Type is
   begin
      return Cloud_Layer.Top(An_Instance.The_Cloud_Layer(1));
   end Lower_Layer_Top;

   function Upper_Layer_Top
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Top_Type is
   begin
      return Cloud_Layer.Top(An_Instance.The_Cloud_Layer(2));
   end Upper_Layer_Top;

   function Lower_Layer_Active
     (An_Instance : in Instance)
      return Boolean is
   begin
      return Cloud_Layer.Active(An_Instance.The_Cloud_Layer(1));
   end Lower_Layer_Active;

   function Upper_Layer_Active
     (An_Instance : in Instance)
      return Boolean is
   begin
      return Cloud_Layer.Active(An_Instance.The_Cloud_Layer(2));
   end Upper_Layer_Active;

   function Lower_Layer_Overcast
     (An_Instance : in Instance) return Boolean is
   begin
      return Cloud_Layer.Overcast(An_Instance.The_Cloud_Layer(1));
   end Lower_Layer_Overcast;

   function Lower_Layer_Scattered
     (An_Instance : in Instance) return Boolean is
   begin
      return Cloud_Layer.Scattered(An_Instance.The_Cloud_Layer(1));
   end Lower_Layer_Scattered;

   function Lower_Layer_Broken
     (An_Instance : in Instance) return Boolean is
   begin
      return Cloud_Layer.Broken(An_Instance.The_Cloud_Layer(1));
   end Lower_Layer_Broken;

   function Upper_Layer_Overcast
     (An_Instance : in Instance) return Boolean is
   begin
      return Cloud_Layer.Overcast(An_Instance.The_Cloud_Layer(2));
   end Upper_Layer_Overcast;

   function Upper_Layer_Scattered
     (An_Instance : in Instance) return Boolean is
   begin
      return Cloud_Layer.Scattered(An_Instance.The_Cloud_Layer(2));
   end Upper_Layer_Scattered;

   function Upper_Layer_Broken
     (An_Instance : in Instance) return Boolean is
   begin
      return Cloud_Layer.Broken(An_Instance.The_Cloud_Layer(2));
   end Upper_Layer_Broken;

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      Cloud_Layer.Initialize(An_Instance.The_Cloud_Layer(1));
      Cloud_Layer.Initialize(An_Instance.The_Cloud_Layer(2));
      An_Instance.Cirrus_Clouds := True;
      An_Instance.Scud_Enabled := False;
   end Initialize;


end Clouds;
