-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Weather_Types;

package Cloud_Layer is


  type Instance is private;

-- Access Broken
   function  Broken
     (An_Instance : in Instance)
      return Boolean;

   procedure Set_Broken
     (An_Instance : in out Instance;
      Broken_On : in Boolean);

-- Access Scattered
   function  Scattered
     (An_Instance : in Instance)
      return Boolean;

   procedure Set_Scattered
     (An_Instance : in out Instance;
      Scattered_On : in Boolean);

-- Access Overcast
   function  Overcast
     (An_Instance : in Instance)
      return Boolean;

   procedure Set_Overcast
     (An_Instance : in out Instance;
      Overcast_On : in Boolean);

-- Access Ceiling
  function  Ceiling (An_Instance : in Instance)
                     return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type;
   procedure Set_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Integer);

-- Access Top
   function  Top (An_Instance : in Instance)
                  return Jpats_Visual_Weather_Types.Cloud_Top_Type;
   procedure Set_Top
     (An_Instance : in out Instance;
      An_Altitude : in Integer);

-- Access Scud_Enabled
   function  Active (An_Instance : in Instance) return Boolean;
   procedure Set_Active
     (An_Instance : in out Instance;
      Is_Active : in Boolean);

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance);

private

   type Instance is record
      Overcast : Boolean;
      Broken : Boolean;
      Scattered : Boolean;
      Ceiling : Jpats_Visual_Weather_Types.Cloud_Ceiling_Type;
      Top : Jpats_Visual_Weather_Types.Cloud_Top_Type;
      Active : Boolean;
  end record;


end Cloud_Layer;
