-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Cloud_Layer is


-- Access Broken
   function  Broken
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Broken;
   end Broken;

   procedure Set_Broken
     (An_Instance : in out Instance;
      Broken_On : in Boolean) is
   begin
      An_Instance.Broken := Broken_On;
      if (Broken_On) then
         An_Instance.Scattered := False;
         An_Instance.Overcast := False;
         if ((An_Instance.Ceiling = 0) and (An_Instance.Top = 0))then
            An_Instance.Ceiling := 4000;
            An_Instance.Top := 15000;
            An_Instance.Active := True;
         end if;
      else
         An_Instance.Ceiling := 0;
         An_Instance.Top := 0;
         An_Instance.Active := False;
      end if;
   end Set_Broken;

-- Access Scattered
   function  Scattered
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Scattered;
   end Scattered;

   procedure Set_Scattered
     (An_Instance : in out Instance;
      Scattered_On : in Boolean) is
   begin
      An_Instance.Scattered := Scattered_On;
      if (Scattered_On) then
         An_Instance.Broken := False;
         An_Instance.Overcast := False;
         if ((An_Instance.Ceiling = 0) and (An_Instance.Top = 0))then
            An_Instance.Ceiling := 4000;
            An_Instance.Top := 15000;
            An_Instance.Active := True;
         end if;
      else
         An_Instance.Ceiling := 0;
         An_Instance.Top := 0;
         An_Instance.Active := False;
      end if;
   end Set_Scattered;

-- Access Overcast
   function  Overcast
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Overcast;
   end Overcast;

   procedure Set_Overcast
     (An_Instance : in out Instance;
      Overcast_On : in Boolean) is
   begin
      An_Instance.Overcast := Overcast_On;
      if (Overcast_On) then
         An_Instance.Scattered := False;
         An_Instance.Broken := False;
         if ((An_Instance.Ceiling = 0) and (An_Instance.Top = 0))then
            An_Instance.Ceiling := 4000;
            An_Instance.Top := 15000;
            An_Instance.Active := True;
         end if;
      else
         An_Instance.Ceiling := 0;
         An_Instance.Top := 0;
         An_Instance.Active := False;
      end if;
   end Set_Overcast;

-- Access Ceiling
   function  Ceiling
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Ceiling_Type is
   begin
      return An_Instance.Ceiling;
   end Ceiling;

   procedure Set_Ceiling
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      if An_Altitude > Jpats_Visual_Weather_Types.Cloud_Ceiling_Type'Last then
         An_Instance.Ceiling :=
           Jpats_Visual_Weather_Types.Cloud_Ceiling_Type'Last;
      elsif An_Altitude <
           Jpats_Visual_Weather_Types.Cloud_Ceiling_Type'First then
         An_Instance.Ceiling :=
           Jpats_Visual_Weather_Types.Cloud_Ceiling_Type'First;
      else
         An_Instance.Ceiling := An_Altitude;
      end if;

      if An_Instance.Ceiling > 0 then
         if (not An_Instance.Overcast and
             not An_Instance.Scattered and
             not An_Instance.Broken) then
           An_Instance.Overcast := True;
           An_Instance.Active := True;
         end if;
      elsif (An_Instance.Top <= 0) then
         An_Instance.Overcast := False;
         An_Instance.Scattered := False;
         An_Instance.Broken := False;
         An_Instance.Active := False;
      end if;
   end Set_Ceiling;

-- Access Top
   function  Top
     (An_Instance : in Instance)
      return Jpats_Visual_Weather_Types.Cloud_Top_Type is
   begin
      return An_Instance.Top;
   end Top;

   procedure Set_Top
     (An_Instance : in out Instance;
      An_Altitude : in Integer) is
   begin
      if An_Altitude > Jpats_Visual_Weather_Types.Cloud_Top_Type'Last then
         An_Instance.Top := Jpats_Visual_Weather_Types.Cloud_Top_Type'Last;
      elsif An_Altitude < Jpats_Visual_Weather_Types.Cloud_Top_Type'First then
         An_Instance.Top := Jpats_Visual_Weather_Types.Cloud_Top_Type'First;
      else
         An_Instance.Top := An_Altitude;
      end if;

      if An_Instance.Top > 0 then
         if (not An_Instance.Overcast and
             not An_Instance.Scattered and
             not An_Instance.Broken) then
            An_Instance.Overcast := True;
            An_Instance.Active := True;
         end if;
      else
         An_Instance.Overcast := False;
         An_Instance.Scattered := False;
         An_Instance.Broken := False;
         An_Instance.Active := False;
         An_Instance.Ceiling := 0;
      end if;
   end Set_Top;

-- Access Scud_Enabled
   function  Active
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Active;
   end Active;

   procedure Set_Active
     (An_Instance : in out Instance;
      Is_Active : in Boolean) is
   begin
      An_Instance.Active := Is_Active;
   end Set_Active;

-- Initialize
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Overcast := False;
      An_Instance.Broken := False;
      An_Instance.Scattered := False;
      An_Instance.Ceiling := 0;
      An_Instance.Top := 0;
      An_Instance.Active := False;
   end Initialize;


end Cloud_Layer;
