-------------------------------------------------------------------------------
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
--
-------------------------------------------------------------------------------


package Celestial is


  type Instance is private;

   -- Manual Sun Position Enable
   function  Manual_Sun_Position_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_Manual_Sun_Position_Enable
     (An_Instance                   : in out Instance;
      An_Manual_Sun_Position_Enable : in Boolean);

   -- Manual Moon Position Enable
   function Manual_Moon_Position_Enable (An_Instance : in Instance) return Boolean;
   procedure Set_Manual_Moon_Position_Enable
     (An_Instance                    : in out Instance;
      An_Manual_Moon_Position_Enable : in Boolean);

   -- Atmospheric Illuminance
   function Atmospheric_Illuminance (An_Instance : in Instance) return Integer;
   procedure Set_Atmospheric_Illuminance
     (An_Instance                : in out Instance;
      An_Atmospheric_Illuminance : in Integer);

   -- Sun Azimuth
   function Sun_Azimuth (An_Instance : in Instance) return Float;
   procedure Set_Sun_Azimuth
     (An_Instance     : in out Instance;
      An_Sun_Azimuth  : in Float);

   -- Sun Elevation  
   function Sun_Elevation (An_Instance : in Instance) return Float;
   procedure Set_Sun_Elevation
     (An_Instance       : in out Instance;
      An_Sun_Elevation  : in Float);

   -- Moon Azimuth
   function  Moon_Azimuth (An_Instance : in Instance) return Float;
   procedure Set_Moon_Azimuth
     (An_Instance : in out Instance;
      An_Moon_Azimuth  : in Float);

   -- Moon Elevation
   function  Moon_Elevation (An_Instance : in Instance) return Float;
   procedure Set_Moon_Elevation
     (An_Instance  : in out Instance;
      An_Moon_Elevation : in Float);

   -- Moon Phase
   function  Moon_Phase (An_Instance : in Instance) return Integer;
   procedure Set_Moon_Phase
     (An_Instance   : in out Instance;
      An_Moon_Phase : in Integer);

   -- Star Field
   function Star_Field (An_Instance : in Instance) return Integer;
   procedure Set_Star_Field
     (An_Instance   : in out Instance;
      An_Star_Field : in Integer);

   -- Initialize Procedure
   procedure Initialize
     (An_Instance : in out Instance);


private

  type Instance is record
    Manual_Sun_Position_Enable  : Boolean;
    Manual_Moon_Position_Enable : Boolean;
    Atmospheric_Illuminance     : Integer;
    Sun_Azimuth                 : Float;
    Sun_Elevation               : Float;
    Moon_Elevation              : Float;
    Moon_Azimuth                : Float;
    Moon_Phase                  : Integer;
    Star_Field                  : Integer;
  end record;


end Celestial;
