-------------------------------------------------------------------------------
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package body Celestial is


   -- Get Manual Sun Position Enable
   function  Manual_Sun_Position_Enable (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Manual_Sun_Position_Enable;
   end Manual_Sun_Position_Enable;

   -- Set Manual Sun Position Enable
   procedure Set_Manual_Sun_Position_Enable
     (An_Instance                   : in out Instance;
      An_Manual_Sun_Position_Enable : in Boolean) is
   begin
      An_Instance.Manual_Sun_Position_Enable := An_Manual_Sun_Position_Enable;
   end Set_Manual_Sun_Position_Enable;

   -- Get Manual Moon Position Enable
   function Manual_Moon_Position_Enable (An_Instance : in Instance) return Boolean is
   begin
      return An_Instance.Manual_Moon_Position_Enable;
   end Manual_Moon_Position_Enable;

   -- Set Manual Moon Position Enable
   procedure Set_Manual_Moon_Position_Enable
     (An_Instance                    : in out Instance;
      An_Manual_Moon_Position_Enable : in Boolean) is
   begin
      An_Instance.Manual_Moon_Position_Enable := An_Manual_Moon_Position_Enable;
   end Set_Manual_Moon_Position_Enable;

   -- Get Atmospheric Illuminance
   function Atmospheric_Illuminance (An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Atmospheric_Illuminance;
   end Atmospheric_Illuminance;

   -- Set Atmospheric Illuminance
   procedure Set_Atmospheric_Illuminance
     (An_Instance                : in out Instance;
      An_Atmospheric_Illuminance : in Integer) is
   begin
      An_Instance.Atmospheric_Illuminance := An_Atmospheric_Illuminance;
   end Set_Atmospheric_Illuminance;

   -- Get Sun Azimuth
   function Sun_Azimuth (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Sun_Azimuth;
   end Sun_Azimuth;

   -- Set Sun Azimuth
   procedure Set_Sun_Azimuth
     (An_Instance     : in out Instance;
      An_Sun_Azimuth  : in Float) is
   begin
      An_Instance.Sun_Azimuth := An_Sun_Azimuth;
   end Set_Sun_Azimuth;

   -- Get Sun Elevation  
   function Sun_Elevation (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Sun_Elevation;
   end Sun_Elevation;

   -- Set Sun Elevation
   procedure Set_Sun_Elevation
     (An_Instance       : in out Instance;
      An_Sun_Elevation  : in Float)is
   begin
      An_Instance.Sun_Elevation := An_Sun_Elevation;
   end Set_Sun_Elevation;

   -- Get Moon Azimuth
   function  Moon_Azimuth (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Moon_Azimuth;
   end Moon_Azimuth;

   -- Set Moon Azimuth
   procedure Set_Moon_Azimuth
     (An_Instance : in out Instance;
      An_Moon_Azimuth  : in Float) is
   begin
      An_Instance.Moon_Azimuth := An_Moon_Azimuth;
   end Set_Moon_Azimuth;

   -- Get Moon Elevation
   function  Moon_Elevation (An_Instance : in Instance) return Float is
   begin
      return An_Instance.Moon_Elevation;
   end Moon_Elevation;

   -- Set Moon Elevation
   procedure Set_Moon_Elevation
     (An_Instance  : in out Instance;
      An_Moon_Elevation : in Float) is
   begin
      An_Instance.Moon_Elevation := An_Moon_Elevation;
   end Set_Moon_Elevation;

   -- Get Moon Phase
   function Moon_Phase (An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Moon_Phase;
   end Moon_Phase;

   -- Set Moon Phase
   procedure Set_Moon_Phase
     (An_Instance : in out Instance;
      An_Moon_Phase    : in Integer) is
   begin
      An_Instance.Moon_Phase := An_Moon_Phase;
   end Set_Moon_Phase;

   -- Get Star Field
   function Star_Field (An_Instance : in Instance) return Integer is
   begin
      return An_Instance.Star_Field;
   end Star_Field;

   -- Set Star Field
   procedure Set_Star_Field
     (An_Instance   : in out Instance;
      An_Star_Field : in Integer) is
   begin
      An_Instance.Star_Field := An_Star_Field;
   end Set_Star_Field;
      

   -- Initialize Procedure
   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Manual_Sun_Position_Enable  := False;
      An_Instance.Manual_Moon_Position_Enable := True;
      An_Instance.Atmospheric_Illuminance     := 90;
      An_Instance.Sun_Azimuth                 := 0.0;
      An_Instance.Sun_Elevation               := 0.0;
      An_Instance.Moon_Elevation              := -90.0;
      An_Instance.Moon_Azimuth                := -90.0;
      An_Instance.Moon_Phase                  := 0;
      An_Instance.Star_Field                  := 8;
   end Initialize;

end Celestial;
