-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Visual_Hazard.Air_Hazard is


-- Access Hazard_Bearing
   function  Hazard_Bearing
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Hazard_Bearing;
   end Hazard_Bearing;

   procedure Set_Hazard_Bearing
     (An_Instance : in out Instance;
      Selected_Bearing : in Float) is
   begin
      An_Instance.Hazard_Bearing := Selected_Bearing;
   end Set_Hazard_Bearing;

-- Access Time_To_Impact
   function  Time_To_Impact
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Time_To_Impact;
   end Time_To_Impact;

   procedure Set_Time_To_Impact
     (An_Instance : in out Instance;
      Impact_Time : in Integer) is
   begin
      An_Instance.Time_To_Impact := Impact_Time;
   end Set_Time_To_Impact;


end Visual_Hazard.Air_Hazard;
