-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;

package Traffic_Model is


  type Instance is private;

-- Access Air_Traffic
   function  Air_Traffic (An_Instance : in Instance) return Boolean;
   procedure Set_Air_Traffic
     (An_Instance : in out Instance;
      Air_Traffic_Enabled : in Boolean);

-- Access Ground_Traffic
   function  Ground_Traffic (An_Instance : in Instance) return Boolean;
   procedure Set_Ground_Traffic
     (An_Instance : in out Instance;
      Ground_Traffic_Enabled : in Boolean);

-- Access Ramp_Traffic
   function  Ramp_Traffic (An_Instance : in Instance) return Boolean;
   procedure Set_Ramp_Traffic
     (An_Instance : in out Instance;
      Ramp_Traffic_Enabled : in Boolean);

-- Initialize Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is record
    Air_Traffic : Boolean;
    Ground_Traffic : Boolean;
    Ramp_Traffic : Boolean;
  end record;


end Traffic_Model;
