-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;

package Moving_Models is


   type Instance is tagged private;

-- Access Model_ID
   function Model_Id (An_Instance : in Instance) return Integer;
   procedure Set_Model_Id
     (An_Instance : in out Instance;
      An_Id : in Integer);

-- Access Model_Type
   function Model_Type (An_Instance : in Instance) return Integer;
   procedure Set_Model_Type
     (An_Instance : in out Instance;
      A_Type : in Integer);

-- Access Active
   function Active (An_Instance : in Instance) return Boolean;
   procedure Set_Active
     (An_Instance : in out Instance;
      Is_Active : in Boolean);

private

  type Instance is tagged record
    Model_Id : Integer;
    Model_Type : Integer;
    Active : Boolean;
  end record;


end Moving_Models;

