-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;
with Moving_Models;
with Lat_Long_Types;

package Moving_Models.Position is

  type Instance is new Moving_Models.Instance with private;
-- Access Position
  function  Position (An_Instance : in Instance)
    return Lat_Long_Types.Position;
   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position);

-- Access Heading
   function  Heading (An_Instance : in Instance)
     return Jpats_Visual_Models_Types.Heading_Type;
   procedure Set_Heading
     (An_Instance : in out Instance;
      A_Heading : in Jpats_Visual_Models_Types.Heading_Type);

-- Access HOT_Request
   function Hot_Request (An_Instance : in Instance) return Boolean;
   procedure Set_Hot_Request
     (An_Instance : in out Instance;
      Hot_Requested : in Boolean);


private

  type Instance is new Moving_Models.Instance with record
    Position : Lat_Long_Types.Position;
    Heading : Jpats_Visual_Models_Types.Heading_Type;
    Hot_Request : Boolean;
  end record;


end Moving_Models.Position;
