-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package body Moving_Models.Position is


-- Access Position
   function  Position
     (An_Instance : in Instance)
      return Lat_Long_Types.Position is
   begin
      return An_Instance.Position;
   end Position;

   procedure Set_Position
     (An_Instance : in out Instance;
      A_Position : in Lat_Long_Types.Position) is
   begin
      An_Instance.Position.Latitude := A_Position.Latitude;
      An_Instance.Position.Longitude := A_Position.Longitude;
      An_Instance.Position.Altitude := A_Position.Altitude;
   end Set_Position;

-- Access Heading
   function  Heading
     (An_Instance : in Instance)
      return Jpats_Visual_Models_Types.Heading_Type is
   begin
      return An_Instance.Heading;
   end Heading;

   procedure Set_Heading
     (An_Instance : in out Instance;
      A_Heading : in Jpats_Visual_Models_Types.Heading_Type) is
   begin
      An_Instance.Heading := A_Heading;
   end Set_Heading;

-- Access HOT_Request
   function Hot_Request
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Hot_Request;
   end Hot_Request;

   procedure Set_Hot_Request
     (An_Instance : in out Instance;
      Hot_Requested : in Boolean) is
   begin
      An_Instance.Hot_Request := Hot_Requested;
   end Set_Hot_Request;


end Moving_Models.Position;
