-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Moving_Models.Position.Storm_Model is


-- Access Storm_Lightning
   function  Storm_Lightning
     (An_Instance : in Instance)
      return Integer is
   begin
      return An_Instance.Storm_Lightning;
   end Storm_Lightning;

   procedure Set_Storm_Lightning
     (An_Instance : in out Instance;
      Storm_Lightning_Selected : in Integer) is
   begin
      An_Instance.Storm_Lightning := Storm_Lightning_Selected;
   end Set_Storm_Lightning;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Model_Id := 0;
      An_Instance.Model_Type := 0;
      An_Instance.Active := False;
      An_Instance.Position.Latitude := 0.0;
      An_Instance.Position.Longitude := 0.0;
      An_Instance.Position.Altitude := 0.0;
      An_Instance.Heading := 0.0;
      An_Instance.Hot_Request := False;
      An_Instance.Storm_Lightning := 0;
   end Initialize;


end Moving_Models.Position.Storm_Model;
