-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;
with Moving_Models.Position;

package Moving_Models.Position.Host_Hazard is


  type Instance is new Moving_Models.Position.Instance with private;

-- Access Hazard_Pitch
   function  Hazard_Pitch (An_Instance : in Instance) return Float;
   procedure Set_Hazard_Pitch
     (An_Instance : in out Instance;
      Model_Pitch : in Float);

-- Access Hazard_Roll
   function  Hazard_Roll (An_Instance : in Instance) return Float;
   procedure Set_Hazard_Roll
     (An_Instance : in out Instance;
      Model_Roll : in Float);

-- Initialize Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is new Moving_Models.Position.Instance with record
    Hazard_Pitch : Float;
    Hazard_Roll : Float;
  end record;


end Moving_Models.Position.Host_Hazard;
