-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Moving_Models.Position.Host_Hazard is


-- Access Hazard_Pitch
   function  Hazard_Pitch
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Hazard_Pitch;
   end Hazard_Pitch;

   procedure Set_Hazard_Pitch
     (An_Instance : in out Instance;
      Model_Pitch : in Float) is
   begin
      An_Instance.Hazard_Pitch := Model_Pitch;
   end Set_Hazard_Pitch;

-- Access Hazard_Roll
   function  Hazard_Roll
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Hazard_Roll;
   end Hazard_Roll;

   procedure Set_Hazard_Roll
     (An_Instance : in out Instance;
      Model_Roll : in Float) is
   begin
      An_Instance.Hazard_Roll := Model_Roll;
   end Set_Hazard_Roll;

   procedure Initialize
     (An_Instance : in out Instance) is
   begin
      An_Instance.Model_Id := 0;
--      An_Instance.Model_Type := 457;
      An_Instance.Active := False;
      An_Instance.Position.Latitude := 0.0;
      An_Instance.Position.Longitude := 0.0;
      An_Instance.Position.Altitude := 0.0;
      An_Instance.Heading := 0.0;
      An_Instance.Hot_Request := False;
      An_Instance.Hazard_Pitch := 0.0;
      An_Instance.Hazard_Roll := 0.0;
   end Initialize;


end Moving_Models.Position.Host_Hazard;

