-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;
with Moving_Models;

package Moving_Models.Ground_Hazard is


  type Instance is new Moving_Models.Instance with private;

-- Access Hazard_Path
   function  Hazard_Path (An_Instance : in Instance) return Integer;
   procedure Set_Hazard_Path
     (An_Instance : in out Instance;
      A_Path : in Integer);

-- Access Hazard_Pause
   function  Hazard_Pause (An_Instance : in Instance) return Boolean;
   procedure Set_Hazard_Pause
     (An_Instance : in out Instance;
      Hazard_Paused : in Boolean);

-- Initialize Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is new Moving_Models.Instance with record
    Hazard_Path : Integer;
    Hazard_Pause : Boolean;
  end record;


end Moving_Models.Ground_Hazard;
