-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;
with Moving_Models;

package Moving_Models.Air_Hazard is


  type Instance is new Moving_Models.Instance with private;

-- Access Hazard_Bearing
   function  Hazard_Bearing (An_Instance : in Instance) return Float;
   procedure Set_Hazard_Bearing
     (An_Instance : in out Instance;
      Selected_Bearing : in Float);

-- Access Time_To_Impact
   function  Time_To_Impact (An_Instance : in Instance) return Integer;
   procedure Set_Time_To_Impact
     (An_Instance : in out Instance;
      Impact_Time : in Integer);

-- Initialize Procedure
   procedure Initialize (An_Instance : in out Instance);

private

  type Instance is new Moving_Models.Instance with record
    Hazard_Bearing : Float;
    Time_To_Impact : Integer;
  end record;


end Moving_Models.Air_Hazard;
