-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models_Types;
with Jpats_Avionics_Types;
with Lat_Long_Types;

package JPATS_Visual_Models is

-- Access Cloud_Model
   function  Cloud_Position (Index : in Integer)
     return Lat_Long_Types.Position;
   function  Cloud_Heading (Index : in Integer) return Float;
   function  Cloud_Hot_Request (Index : in Integer) return Boolean;
   function  Cloud_Type (Index : in Integer) return Integer;
   function  Cloud_Model_ID (Index : in Integer) return Integer;
   function  Cloud_Lightning (Index : in Integer) return Integer;
   function  Cloud_Active (Index : in Integer) return Boolean;

-- Access Storm_Model
   function  Storm_Position (Index : in Integer)
     return Lat_Long_Types.Position;
   function  Storm_Heading (Index : in Integer) return Float;
   function  Storm_Hot_Request (Index : in Integer) return Boolean;
   function  Storm_Type (Index : in Integer) return Integer;
   function  Storm_Lightning (Index : in Integer) return Integer;
   function  Storm_Active (Index : in Integer) return Boolean;
   function  Storm_Model_Id (Index : in Integer) return Integer;

-- Access Host_Hazard
   function  Host_Hazard_Position (Index : in Integer)
     return Lat_Long_Types.Position;
   function  Host_Hazard_Heading (Index : in Integer) return Float;
   function  Host_Hazard_Hot_Request (Index : in Integer) return Boolean;
   function  Host_Hazard_Active (Index : in Integer) return Boolean;
   function  Host_Hazard_Pitch (Index : in Integer) return Float;
   function  Host_Hazard_Roll (Index : in Integer) return Float;
   function  Host_Hazard_Type (Index : in Integer) return Integer;
   function  Host_Hazard_Id (Index : in Integer) return Integer;

-- Access Formation_Model
   function  Formation_Model_Position return Lat_Long_Types.Position;
   function  Formation_Model_Heading return Float;
   function  Formation_Model_Hot_Request return Boolean;
   function  Formation_Model_Active return Boolean;
   function  Formation_Model_Pitch return Float;
   function  Formation_Model_Roll return Float;
   function  Formation_Model_Type return Integer;
   function  Formation_Model_Id return Integer;

-- Access Air_Hazard
   function  Air_Hazard_Active  return Boolean;
   function  Air_Hazard_ID  return Integer;
   function  Air_Hazard_Model_Type  return Integer;
   function  Air_Hazard_Bearing  return Float;
   function  Air_Hazard_Time_To_Impact  return Integer;

-- Access Ground_Hazard
   function  Ground_Hazard_Active  return Boolean;
   function  Ground_Hazard_ID  return Integer;
   function  Ground_Hazard_Model_Type  return Integer;
   function  Ground_Hazard_Path  return Integer;
   function  Ground_Hazard_Pause  return Boolean;

-- Access Traffic_Model
   function  Air_Traffic  return Boolean;
   function  Ground_Traffic  return Boolean;
   function  Ramp_Traffic  return Boolean;

   function Intruder_Drive return
     JPATS_Avionics_Types.Intruder_Drive_Array_Type;

end JPATS_Visual_Models;
