-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  James F. Narrin
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Visual_Models.Container;
with Moving_Models.Position.Cloud_Model;
with Moving_Models.Position.Storm_Model;
with Moving_Models.Position.Host_Hazard;
with Moving_Models.Air_Hazard;
with Moving_Models.Ground_Hazard;
with Traffic_Model;
with Jpats_Avionics_Types;

package body JPATS_Visual_Models is

   function Intruder_Drive
     return JPATS_Avionics_Types.Intruder_Drive_Array_Type is

   begin

      return Container.This_Subsystem.The_Intruder_Drive;

   end Intruder_Drive;

   function Cloud_Active (Index : in Integer) return Boolean is
   begin
      return Moving_Models.Position.Cloud_Model.Active
        (Container.This_Subsystem.The_Cloud_Model(Index));
   end Cloud_Active;

   function  Cloud_Position  (Index : in Integer)
     return Lat_Long_Types.Position is
   begin
      return Moving_Models.Position.Cloud_Model.Position
        (Container.This_Subsystem.The_Cloud_Model(Index));
   end Cloud_Position;

   function  Cloud_Heading  (Index : in Integer) return Float is
   begin
      return Moving_Models.Position.Cloud_Model.Heading
        (Container.This_Subsystem.The_Cloud_Model(Index));
   end Cloud_Heading;

   function  Cloud_Hot_Request  (Index : in Integer) return Boolean is
   begin
      return Moving_Models.Position.Cloud_Model.Hot_Request
        (Container.This_Subsystem.The_Cloud_Model(Index));
   end Cloud_Hot_Request;

   function Cloud_Type  (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Cloud_Model.Model_Type
        (Container.This_Subsystem.The_Cloud_Model(Index));
   end Cloud_Type;

   function Cloud_Model_ID  (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Cloud_Model.Model_Id
        (Container.This_Subsystem.The_Cloud_Model(Index));
   end Cloud_Model_Id;

   function Cloud_Lightning  (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Cloud_Model.Cloud_Lightning
        (Container.This_Subsystem.The_Cloud_Model(Index));
   end Cloud_Lightning;

-- Access Storm_Model
   function Storm_Active
     (Index : in Integer) return Boolean is
   begin
      return Moving_Models.Position.Storm_Model.Active
        (Container.This_Subsystem.The_Storm_Model(Index));
   end Storm_Active;

   function  Storm_Position
     (Index : in Integer) return Lat_Long_Types.Position is
   begin
      return Moving_Models.Position.Storm_Model.Position
        (Container.This_Subsystem.The_Storm_Model(Index));
   end Storm_Position;

   function  Storm_Heading
     (Index : in Integer) return Float is
   begin
      return Moving_Models.Position.Storm_Model.Heading
        (Container.This_Subsystem.The_Storm_Model(Index));
   end Storm_Heading;

   function  Storm_Hot_Request
     (Index : in Integer) return Boolean is
   begin
      return Moving_Models.Position.Storm_Model.Hot_Request
        (Container.This_Subsystem.The_Storm_Model(Index));
   end Storm_Hot_Request;

   function  Storm_Type
     (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Storm_Model.Model_Type
        (Container.This_Subsystem.The_Storm_Model(Index));
   end Storm_Type;

   function Storm_Model_Id
     (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Storm_Model.Model_Id
        (Container.This_Subsystem.The_Storm_Model(Index));
   end Storm_Model_Id;

   function  Storm_Lightning
     (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Storm_Model.Storm_Lightning
        (Container.This_Subsystem.The_Storm_Model(Index));
   end Storm_Lightning;

-- Access Host_Hazard
   function Host_Hazard_Active
     (Index : in Integer) return Boolean is
   begin
      return Moving_Models.Position.Host_Hazard.Active
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Active;

   function  Host_Hazard_Position
     (Index : in Integer) return Lat_Long_Types.Position is
   begin
      return Moving_Models.Position.Host_Hazard.Position
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Position;

   function  Host_Hazard_Heading
     (Index : in Integer) return Float is
   begin
      return Moving_Models.Position.Host_Hazard.Heading
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Heading;

   function  Host_Hazard_Hot_Request
     (Index : in Integer) return Boolean is
   begin
      return Moving_Models.Position.Host_Hazard.Hot_Request
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Hot_Request;

   function  Host_Hazard_Pitch
     (Index : in Integer) return Float is
   begin
      return Moving_Models.Position.Host_Hazard.Hazard_Pitch
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Pitch;

   function  Host_Hazard_Roll
     (Index : in Integer) return Float is
   begin
      return Moving_Models.Position.Host_Hazard.Hazard_Roll
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Roll;

   function  Host_Hazard_Type
     (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Host_Hazard.Model_Type
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Type;

   function Host_Hazard_Id
     (Index : in Integer) return Integer is
   begin
      return Moving_Models.Position.Host_Hazard.Model_Id
        (Container.This_Subsystem.The_Host_Hazard(Index));
   end Host_Hazard_Id;

-- Access Formation_Model
   function Formation_Model_Active
     return Boolean is
   begin
      return Moving_Models.Position.Host_Hazard.Active
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Active;

   function  Formation_Model_Position
     return Lat_Long_Types.Position is
   begin
      return Moving_Models.Position.Host_Hazard.Position
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Position;

   function  Formation_Model_Heading
     return Float is
   begin
      return Moving_Models.Position.Host_Hazard.Heading
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Heading;

   function  Formation_Model_Hot_Request
     return Boolean is
   begin
      return Moving_Models.Position.Host_Hazard.Hot_Request
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Hot_Request;

   function  Formation_Model_Pitch
     return Float is
   begin
      return Moving_Models.Position.Host_Hazard.Hazard_Pitch
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Pitch;

   function  Formation_Model_Roll
     return Float is
   begin
      return Moving_Models.Position.Host_Hazard.Hazard_Roll
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Roll;

   function  Formation_Model_Type
     return Integer is
   begin
      return Moving_Models.Position.Host_Hazard.Model_Type
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Type;

   function Formation_Model_Id
     return Integer is
   begin
      return Moving_Models.Position.Host_Hazard.Model_Id
        (Container.This_Subsystem.The_Formation_Model);
   end Formation_Model_Id;

-- Access Air_Hazard
   function  Air_Hazard_Active  return Boolean is
   begin
      return Moving_Models.Air_Hazard.Active
        (Container.This_Subsystem.The_Air_Hazard);
   end Air_Hazard_Active;

   function  Air_Hazard_ID  return Integer is
   begin
      return Moving_Models.Air_Hazard.Model_Id
        (Container.This_Subsystem.The_Air_Hazard);
   end Air_Hazard_Id;

   function  Air_Hazard_Model_Type  return Integer is
   begin
      return Moving_Models.Air_Hazard.Model_Type
        (Container.This_Subsystem.The_Air_Hazard);
   end Air_Hazard_Model_Type;

   function  Air_Hazard_Bearing  return Float is
   begin
      return Moving_Models.Air_Hazard.Hazard_Bearing
        (Container.This_Subsystem.The_Air_Hazard);
   end Air_Hazard_Bearing;

   function  Air_Hazard_Time_To_Impact  return Integer is
   begin
      return Moving_Models.Air_Hazard.Time_To_Impact
        (Container.This_Subsystem.The_Air_Hazard);
   end Air_Hazard_Time_To_Impact;

-- Access Ground_Hazard
   function  Ground_Hazard_Active  return Boolean is
   begin
      return Moving_Models.Ground_Hazard.Active
        (Container.This_Subsystem.The_Ground_Hazard);
   end Ground_Hazard_Active;

   function  Ground_Hazard_ID  return Integer is
   begin
      return Moving_Models.Ground_Hazard.Model_Id
        (Container.This_Subsystem.The_Ground_Hazard);
   end Ground_Hazard_Id;

   function  Ground_Hazard_Model_Type  return Integer is
   begin
      return Moving_Models.Ground_Hazard.Model_Type
        (Container.This_Subsystem.The_Ground_Hazard);
   end Ground_Hazard_Model_Type;

   function  Ground_Hazard_Path  return Integer is
   begin
      return Moving_Models.Ground_Hazard.Hazard_Path
        (Container.This_Subsystem.The_Ground_Hazard);
   end Ground_Hazard_Path;

   function  Ground_Hazard_Pause  return Boolean is
   begin
      return Moving_Models.Ground_Hazard.Hazard_Pause
        (Container.This_Subsystem.The_Ground_Hazard);
   end Ground_Hazard_Pause;

-- Access Traffic_Model
   function  Air_Traffic  return Boolean is
   begin
      return Traffic_Model.Air_Traffic
        (Container.This_Subsystem.The_Traffic_Model);
   end Air_Traffic;

   function  Ground_Traffic  return Boolean is
   begin
      return Traffic_Model.Ground_Traffic
        (Container.This_Subsystem.The_Traffic_Model);
   end Ground_Traffic;

   function  Ramp_Traffic  return Boolean is
   begin
      return Traffic_Model.Ramp_Traffic
        (Container.This_Subsystem.The_Traffic_Model);
   end Ramp_Traffic;


end JPATS_Visual_Models;
